% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marginal_effects.R
\name{plot_marginal_effects}
\alias{plot_marginal_effects}
\title{Plot Marginal Effects from a Fitted Model}
\usage{
plot_marginal_effects(
  x,
  ylab = "Estimated response",
  length.out = 100,
  type = "state",
  link = FALSE
)
}
\arguments{
\item{x}{A `multiScaleR` object containing at least the elements `opt_mod` (the fitted model)
and `scl_params` (a list with `mean` and `sd` for each covariate used for scaling).}

\item{ylab}{Character. Y-axis label for the marginal effect plots. Default is `"Estimated response"`.}

\item{length.out}{Integer. Number of points at which to evaluate the marginal effect curve.
Default is 100.}

\item{type}{For `unmarked` models, Default is `"state"`}

\item{link}{Logical. An optional switch to predict values on the response scale. Default = `FALSE`. If predicted values seem incorrect, try switching to `TRUE`}
}
\value{
A named list of `ggplot` objects, one for each covariate, showing the predicted
  response and 95% confidence interval across the observed range of that covariate
  while holding other covariates at their mean values.
}
\description{
Generates marginal effect plots with 95% confidence intervals for each covariate
in a fitted model stored within a `multiScaleR` object.
}
\details{
For `unmarked` models, predictions are made using `type = "state"` and
  the `predict` method for state variables. For other models (e.g., `lm`, `glm`),
  predictions are made using the standard `predict(..., se.fit = TRUE)` call and
  transformed by the model's inverse link function .
}
