#' Reset the index offset
#'
#' @keywords internal
resetIndices = function() {
  pkgEnv$index = 0
}

#' Return a vector of indices
#'
#' Given a desired number of indices, this returns an integer vector of
#' that many unused indices into the parameter vector
#'
#' @param n integer, the desired number of indices
#'
#' @return an integer vector of unused indices
#' @keywords internal
getIndices = function(n=1) {
  if (n<=0) return(c())

  indices = (1:n)+pkgEnv$index
  pkgEnv$index   = pkgEnv$index + n
  return(indices)
}

#' Return the number of indices assigned so far
#'
#' @return an integer
#' @keywords internal
nIndices = function() {
  return(pkgEnv$index)
}
