% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deviance2.R
\name{deviance2}
\alias{deviance2}
\title{Deviance of a psychometric function}
\usage{
deviance2( r, m, pfit )
}
\arguments{
\item{r}{number of successes}

\item{m}{number of trials}

\item{pfit}{fittd values}
}
\value{
\verb{D  } deviance
}
\description{
This function calculates the deviance for the fitted values of the psychometric function pfit.
}
\examples{
data("Carcagno")
x = Carcagno$x
r = Carcagno$r
m = Carcagno$m
plot( x, r / m, xlim = c( 1.95, 4.35 ), ylim = c( 0.24, 0.99 ), type = "p", pch="*" )
guess = 1/3; # guessing rate
laps = 0; # lapsing rate
val <- binomfit_lims( r, m, x, link = "probit", guessing = guess, lapsing = laps )
pfit<-predict( val$fit, data.frame( x = x ), type = "response" )
d2 = deviance2( r, m, pfit )

}
