#' @importFrom utils bibentry
bibentries = c(
  bischl_2021 = bibentry("misc",
    key           = "bischl_2021",
    title         = "Hyperparameter Optimization: Foundations, Algorithms, Best Practices and Open Challenges",
    author        = "Bernd Bischl and Martin Binder and Michel Lang and Tobias Pielok and Jakob Richter and Stefan Coors and Janek Thomas and Theresa Ullmann and Marc Becker and Anne-Laure Boulesteix and Difan Deng and Marius Lindauer",
    journal       = "Wiley Interdisciplinary Reviews: Data Mining and Knowledge Discovery",
    volume        = "13",
    number        = "2",
    pages         = "e1484",
    year          = "2023",
    publisher     = "Wiley Online Library"
  ),

  kuehn_2018 = bibentry("misc",
    key           = "kuehn_2018",
    title         = "Automatic Exploration of Machine Learning Experiments on OpenML",
    author        = "Daniel Kuehn and Philipp Probst and Janek Thomas and Bernd Bischl",
    year          = "2018",
    eprint        = "1806.10961",
    archivePrefix = "arXiv",
    primaryClass  = "stat.ML",
    url = "https://arxiv.org/abs/1806.10961"
  ),

  binder_2020 = bibentry("misc",
    key       = "binder_2020",
    title     = "Collecting Empirical Data About Hyperparameters for Data Driven AutoML",
    author    = "Martin Binder and Florian Pfisterer and Bernd Bischl",
    year      = "2020",
    booktitle = "Proceedings of the 7th ICML Workshop on Automated Machine Learning (AutoML 2020)",
    date      = "2020",
    url       = "https://www.automl.org/wp-content/uploads/2020/07/AutoML_2020_paper_63.pdf"
  )
)
