% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpRandomResponse.R
\name{mlr_pipeops_randomresponse}
\alias{mlr_pipeops_randomresponse}
\alias{PipeOpRandomResponse}
\title{Generate a Randomized Response Prediction}
\format{
\code{\link[R6:R6Class]{R6Class}} object inheriting from \code{\link{PipeOp}}.
}
\description{
Takes in a \code{\link[mlr3:Prediction]{Prediction}} of \code{predict_type} \code{"prob"}
(for \code{\link[mlr3:PredictionClassif]{PredictionClassif}}) or \code{"se"}
(for \code{\link[mlr3:PredictionRegr]{PredictionRegr}}) and generates a randomized \code{"response"}
prediction.

For \code{"prob"}, the responses are sampled according to
the probabilities of the input \code{\link[mlr3:PredictionClassif]{PredictionClassif}}. For \code{"se"},
responses are randomly drawn according to the \code{rdistfun} parameter (default is \code{\link{rnorm}}) by using
the original responses of the input \code{\link[mlr3:PredictionRegr]{PredictionRegr}} as the mean and the
original standard errors of the input \code{\link[mlr3:PredictionRegr]{PredictionRegr}} as the standard
deviation (sampling is done observation-wise).
}
\section{Construction}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{PipeOpRandomResponse$new(id = "randomresponse", param_vals = list(), packages = character(0))
}\if{html}{\out{</div>}}
\itemize{
\item \code{id} :: \code{character(1)}\cr
Identifier of the resulting object, default \code{"randomresponse"}.
\item \code{param_vals} :: named \code{list}\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would otherwise
be set during construction. Default \code{list()}.
\item packages :: \code{character}\cr
Set of all required packages for the \code{private$.predict()} methods related to the \code{rdistfun}
parameter. Default is \code{character(0)}.
}
}

\section{Input and Output Channels}{

\code{\link{PipeOpRandomResponse}} has one input channel named \code{"input"}, taking \code{NULL} during training and
a \code{\link[mlr3:Prediction]{Prediction}} during prediction.

\code{\link{PipeOpRandomResponse}} has one output channel named \code{"output"}, producing \code{NULL} during
training and a \code{\link[mlr3:Prediction]{Prediction}} with random responses during prediction.
}

\section{State}{

The \verb{$state} is left empty (\code{list()}).
}

\section{Parameters}{

\itemize{
\item \code{rdistfun} :: \code{function} \cr
A function for generating random responses when the predict type is \code{"se"}. This function must
accept the arguments \code{n} (integerish number of responses), \code{mean} (\code{numeric} for the mean),
and \code{sd} (\code{numeric} for the  standard deviation), and must \emph{vectorize} over \code{mean}
and \code{sd}. Default is \code{\link{rnorm}}.
}
}

\section{Internals}{

If the \code{predict_type} of the input \code{\link[mlr3:Prediction]{Prediction}} does not match \code{"prob"} or
\code{"se"}, the input \code{\link[mlr3:Prediction]{Prediction}} will be returned unaltered.
}

\section{Fields}{

Only fields inherited from \code{\link{PipeOp}}.
}

\section{Methods}{

Only methods inherited from \code{\link{PipeOp}}.
}

\examples{
\dontshow{if (requireNamespace("rpart")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(mlr3)
library(mlr3learners)

task1 = tsk("iris")
g1 = LearnerClassifRpart$new() \%>>\% PipeOpRandomResponse$new()
g1$train(task1)
g1$pipeops$classif.rpart$learner$predict_type = "prob"
set.seed(2409)
g1$predict(task1)

task2 = tsk("mtcars")
g2 = LearnerRegrLM$new() \%>>\% PipeOpRandomResponse$new()
g2$train(task2)
g2$pipeops$regr.lm$learner$predict_type = "se"
set.seed(2906)
g2$predict(task2)
\dontshow{\}) # examplesIf}
}
\seealso{
https://mlr-org.com/pipeops.html

Other PipeOps: 
\code{\link{PipeOp}},
\code{\link{PipeOpEncodePL}},
\code{\link{PipeOpEnsemble}},
\code{\link{PipeOpImpute}},
\code{\link{PipeOpTargetTrafo}},
\code{\link{PipeOpTaskPreproc}},
\code{\link{PipeOpTaskPreprocSimple}},
\code{\link{mlr_pipeops}},
\code{\link{mlr_pipeops_adas}},
\code{\link{mlr_pipeops_blsmote}},
\code{\link{mlr_pipeops_boxcox}},
\code{\link{mlr_pipeops_branch}},
\code{\link{mlr_pipeops_chunk}},
\code{\link{mlr_pipeops_classbalancing}},
\code{\link{mlr_pipeops_classifavg}},
\code{\link{mlr_pipeops_classweights}},
\code{\link{mlr_pipeops_colapply}},
\code{\link{mlr_pipeops_collapsefactors}},
\code{\link{mlr_pipeops_colroles}},
\code{\link{mlr_pipeops_copy}},
\code{\link{mlr_pipeops_datefeatures}},
\code{\link{mlr_pipeops_decode}},
\code{\link{mlr_pipeops_encode}},
\code{\link{mlr_pipeops_encodeimpact}},
\code{\link{mlr_pipeops_encodelmer}},
\code{\link{mlr_pipeops_encodeplquantiles}},
\code{\link{mlr_pipeops_encodepltree}},
\code{\link{mlr_pipeops_featureunion}},
\code{\link{mlr_pipeops_filter}},
\code{\link{mlr_pipeops_fixfactors}},
\code{\link{mlr_pipeops_histbin}},
\code{\link{mlr_pipeops_ica}},
\code{\link{mlr_pipeops_imputeconstant}},
\code{\link{mlr_pipeops_imputehist}},
\code{\link{mlr_pipeops_imputelearner}},
\code{\link{mlr_pipeops_imputemean}},
\code{\link{mlr_pipeops_imputemedian}},
\code{\link{mlr_pipeops_imputemode}},
\code{\link{mlr_pipeops_imputeoor}},
\code{\link{mlr_pipeops_imputesample}},
\code{\link{mlr_pipeops_kernelpca}},
\code{\link{mlr_pipeops_learner}},
\code{\link{mlr_pipeops_learner_pi_cvplus}},
\code{\link{mlr_pipeops_learner_quantiles}},
\code{\link{mlr_pipeops_missind}},
\code{\link{mlr_pipeops_modelmatrix}},
\code{\link{mlr_pipeops_multiplicityexply}},
\code{\link{mlr_pipeops_multiplicityimply}},
\code{\link{mlr_pipeops_mutate}},
\code{\link{mlr_pipeops_nearmiss}},
\code{\link{mlr_pipeops_nmf}},
\code{\link{mlr_pipeops_nop}},
\code{\link{mlr_pipeops_ovrsplit}},
\code{\link{mlr_pipeops_ovrunite}},
\code{\link{mlr_pipeops_pca}},
\code{\link{mlr_pipeops_proxy}},
\code{\link{mlr_pipeops_quantilebin}},
\code{\link{mlr_pipeops_randomprojection}},
\code{\link{mlr_pipeops_regravg}},
\code{\link{mlr_pipeops_removeconstants}},
\code{\link{mlr_pipeops_renamecolumns}},
\code{\link{mlr_pipeops_replicate}},
\code{\link{mlr_pipeops_rowapply}},
\code{\link{mlr_pipeops_scale}},
\code{\link{mlr_pipeops_scalemaxabs}},
\code{\link{mlr_pipeops_scalerange}},
\code{\link{mlr_pipeops_select}},
\code{\link{mlr_pipeops_smote}},
\code{\link{mlr_pipeops_smotenc}},
\code{\link{mlr_pipeops_spatialsign}},
\code{\link{mlr_pipeops_subsample}},
\code{\link{mlr_pipeops_targetinvert}},
\code{\link{mlr_pipeops_targetmutate}},
\code{\link{mlr_pipeops_targettrafoscalerange}},
\code{\link{mlr_pipeops_textvectorizer}},
\code{\link{mlr_pipeops_threshold}},
\code{\link{mlr_pipeops_tomek}},
\code{\link{mlr_pipeops_tunethreshold}},
\code{\link{mlr_pipeops_unbranch}},
\code{\link{mlr_pipeops_updatetarget}},
\code{\link{mlr_pipeops_vtreat}},
\code{\link{mlr_pipeops_yeojohnson}}
}
\concept{PipeOps}
