% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{ModeCanada}
\alias{ModeCanada}
\title{Mode Choice for the Montreal-Toronto Corridor}
\format{
A dataframe containing

- case: the individual index,
- alt: the alternative, one of train, car, bus and air,
- choice: one if the mode is chosen, zero otherwise,
- cost: monetary cost,
- ivt: in vehicule time,
- ovt: out vehicule time,
- frequency: frequency,
- income: income,
- urban: urban,
- noalt: the number of alternatives available.
}
\source{
kindly provided by S. Koppelman
}
\description{
A sample of 3880 travellers for the Montreal-Toronto corridor
}
\examples{
data("ModeCanada", package = "mlogit")
bususers <- with(ModeCanada, case[choice == 1 & alt == "bus"])
ModeCanada <- subset(ModeCanada, ! case \%in\% bususers)
ModeCanada <- subset(ModeCanada, noalt == 4)
ModeCanada <- subset(ModeCanada, alt != "bus")
ModeCanada$alt <- ModeCanada$alt[drop = TRUE]
KoppWen00 <- mlogit.data(ModeCanada, shape='long', chid.var = 'case',
                         alt.var = 'alt', choice = 'choice',
                         drop.index = TRUE)
pcl <- mlogit(choice ~ freq + cost + ivt + ovt, KoppWen00, reflevel = 'car',
              nests = 'pcl', constPar = c('iv:train.air'))

}
\references{
\insertRef{BHAT:95}{mlogit}

\insertRef{KOPP:WEN:00}{mlogit}

\insertRef{WEN:KOPP:01}{mlogit}
}
\keyword{datasets}
