% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/animateSpectra.R
\name{animateSpectra}
\alias{animateSpectra}
\title{Animation of the abundance spectra}
\usage{
animateSpectra(
  sim,
  species = NULL,
  time_range,
  wlim = c(NA, NA),
  ylim = c(NA, NA),
  power = 1,
  total = FALSE,
  resource = TRUE
)
}
\arguments{
\item{sim}{A MizerSim object}

\item{species}{Name or vector of names of the species to be plotted. By
default all species are plotted.}

\item{time_range}{The time range to animate over. Either a vector of values
or a vector of min and max time. Default is the entire time range of the
simulation.}

\item{wlim}{A numeric vector of length two providing lower and upper limits
for the w axis. Use NA to refer to the existing minimum or maximum.}

\item{ylim}{A numeric vector of length two providing lower and upper limits
for the y axis. Use NA to refer to the existing minimum or maximum. Any
values below 1e-20 are always cut off.}

\item{power}{The abundance is plotted as the number density times the weight
raised to \code{power}. The default \code{power = 1} gives the biomass
density, whereas \code{power = 2} gives the biomass density with respect
to logarithmic size bins.}

\item{total}{A boolean value that determines whether the total over all
species in the system is plotted as well. Default is FALSE.}

\item{resource}{A boolean value that determines whether resource is included.
Default is TRUE.}
}
\value{
A plotly object
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
\donttest{
animateSpectra(NS_sim, power = 2, wlim = c(0.1, NA), time_range = 1997:2007)
}
}
\seealso{
Other plotting functions: 
\code{\link{plot,MizerParams,missing-method}},
\code{\link{plot,MizerSim,missing-method}},
\code{\link{plotBiomass}()},
\code{\link{plotDiet}()},
\code{\link{plotFMort}()},
\code{\link{plotFeedingLevel}()},
\code{\link{plotGrowthCurves}()},
\code{\link{plotPredMort}()},
\code{\link{plotSpectra}()},
\code{\link{plotYield}()},
\code{\link{plotYieldGear}()},
\code{\link{plotting_functions}}
}
\concept{plotting functions}
