% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{extract_indiv_data}
\alias{extract_indiv_data}
\title{Extract the individual level data from the dataset for use in posterior analysis}
\usage{
extract_indiv_data(data, data_cols = NULL)
}
\arguments{
\item{data}{The dataset}

\item{data_cols}{The individual level columns of attributes - Can be null to take aggregate for each column}
}
\value{
dataframe of all individual level data for each ID
}
\description{
Extract the individual level data from the dataset for use in posterior analysis
}
\examples{
data("Train", package="mlogit")
Train$ID <- Train$id
Train$CHOICE <- as.numeric(Train$choice)
#in this case not actually individual data columns 
#an ID column is required here
extract_indiv_data(Train, c('comfort_A', 'comfort_B'))
}
