% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lr_sex.R
\name{lr_sex}
\alias{lr_sex}
\title{Likelihood Ratio for Biological Sex}
\usage{
lr_sex(
  MPs = "F",
  eps = 0.05,
  erRs = eps,
  numsims = 1000,
  Ps = c(0.5, 0.5),
  H = 1,
  LR = FALSE,
  seed = 1234,
  nsims = NULL
)
}
\arguments{
\item{MPs}{Character. Missing person's biological sex: "F" for female,
"M" for male. Default: "F".}

\item{eps}{Numeric (0-1). Error rate (epsilon) for sex observation.
Probability of misclassifying sex when recording. Default: 0.05.}

\item{erRs}{Numeric (0-1). Error rate in the database/reference.
Defaults to \code{eps} if not specified.}

\item{numsims}{Integer. Number of simulations to perform. Default: 1000.}

\item{Ps}{Numeric vector of length 2. Sex proportions in the population,
c(proportion_female, proportion_male). Must sum to 1. Default: c(0.5, 0.5).}

\item{H}{Integer (1 or 2). Hypothesis to simulate under:
\itemize{
\item 1: H1 (Related) - Unidentified person IS the missing person
\item 2: H2 (Unrelated) - Unidentified person is NOT the missing person
}
Default: 1.}

\item{LR}{Logical. If TRUE, compute and return LR values for each
simulated observation. Default: FALSE.}

\item{seed}{Integer. Random seed for reproducibility. Default: 1234.}

\item{nsims}{Deprecated. Use \code{numsims} instead.}
}
\value{
A data.frame with column \code{Sexo} containing simulated sex
observations ("F" or "M"). If \code{LR = TRUE}, also includes column
\code{LRs} with the likelihood ratio for each observation.
}
\description{
Simulates observations of biological sex and optionally computes likelihood
ratios (LRs) under either H1 (unidentified person is the missing person) or
H2 (unidentified person is not the missing person).
}
\details{
\strong{Under H1 (Related):}
The observed sex matches the MP's true sex with probability (1 - erRs),
and is incorrectly recorded with probability erRs.

\strong{Under H2 (Unrelated):}
Sex is sampled from the population proportions Ps.

\strong{LR Calculation:}
For a matching observation: \code{LR = (1 - eps) / Ps_MP}
For a non-matching observation: \code{LR = eps / Ps_other}
}
\examples{
# Simulate under H1 (related)
sim_h1 <- lr_sex(MPs = "F", H = 1, numsims = 100)
table(sim_h1$Sexo)

# Simulate under H2 (unrelated) with LR values
sim_h2 <- lr_sex(MPs = "F", H = 2, numsims = 100, LR = TRUE)
head(sim_h2)

# Different population proportions
sim_custom <- lr_sex(
  MPs = "M",
  Ps = c(0.52, 0.48),  # 52\% female population
  numsims = 500,
  LR = TRUE
)
summary(sim_custom$LRs)
}
\references{
Marsico FL, et al. (2023). "Likelihood ratios for non-genetic evidence
in missing person cases." \emph{Forensic Science International: Genetics},
66, 102891. \doi{10.1016/j.fsigen.2023.102891}
}
\seealso{
\code{\link{sim_lr_prelim}} for unified preliminary LR simulations,
\code{\link{lr_age}}, \code{\link{lr_hair_color}} for other variables.
}
