# WARNING - Generated by {fusen} from dev/flat_teaching.Rmd: do not edit by hand

test_that("w2l_nest functions correctly", {
  # Setup test data
  test_dt <- data.table::data.table(
    id = 1:4,
    group = c("A", "A", "B", "B"),
    val1 = c(10, 20, 30, 40),
    val2 = c(100, 200, 300, 400)
  )
  
  test_df <- as.data.frame(test_dt)
  
  # Test basic functionality
  test_that("basic functionality works", {
    # Test with data.table input
    result1 <- w2l_nest(test_dt, cols2l = c("val1", "val2"))
    expect_true(data.table::is.data.table(result1))
    expect_equal(nrow(result1), 2)  # One row for each value column
    expect_equal(names(result1), c("name", "data"))
    
    # Test with data.frame input
    result2 <- w2l_nest(test_df, cols2l = c("val1", "val2"))
    expect_true(data.table::is.data.table(result2))
    expect_equal(result1, result2)
  })
  
  # Test different parameter combinations
  test_that("parameter combinations work correctly", {
    # Test with by parameter
    result <- w2l_nest(test_dt, cols2l = c("val1", "val2"), by = "group")
    expect_equal(nrow(result), 4)  # 2 value columns × 2 groups
    expect_equal(names(result), c("name", "group", "data"))
    
    # Test with numeric indices
    result_num <- w2l_nest(test_dt, cols2l = c(3, 4), by = 2)
    expect_equal(result, result_num)
    
    # Test with nest_type = "df"
    result_df <- w2l_nest(test_dt, cols2l = c("val1", "val2"), nest_type = "df")
    expect_true(is.data.frame(result_df$data[[1]]))
    
    # Test with NULL cols2l
    result_null <- w2l_nest(test_dt, cols2l = NULL, by = "group")
    expect_equal(nrow(result_null), 2)  # One row for each group
    expect_equal(names(result_null), c("group", "data"))
  })
  
  # Test error handling
  test_that("error handling works correctly", {
    # Test invalid input type
    expect_error(
      w2l_nest(list(a = 1)),
      "Data must be either a data.frame or a data.table."
    )
    
    # Test invalid cols2l
    expect_error(
      w2l_nest(test_dt, cols2l = "nonexistent"),
      "Some columns specified in cols2l are not present in the data"
    )
    
    expect_error(
      w2l_nest(test_dt, cols2l = 10),
      "Numeric indices in cols2l are out of bounds"
    )
    
    # Test invalid by
    expect_error(
      w2l_nest(test_dt, cols2l = c("val1", "val2"), by = "nonexistent"),
      "Grouping variables not present in data"
    )
    
    expect_error(
      w2l_nest(test_dt, cols2l = c("val1", "val2"), by = 10),
      "Numeric indices in by are out of bounds"
    )
    
    # Test invalid nest_type
    expect_error(
      w2l_nest(test_dt, cols2l = c("val1", "val2"), nest_type = "invalid"),
      "Invalid nest_type provided"
    )
    
    # Test missing by when cols2l is NULL
    expect_error(
      w2l_nest(test_dt, cols2l = NULL),
      "When cols2l is NULL, by parameter must be provided"
    )
  })
  
  # Test edge cases
  test_that("edge cases are handled correctly", {
    # Single column to nest
    result <- w2l_nest(test_dt, cols2l = "val1")
    expect_equal(nrow(result), 1)
    
    # Single group
    result <- w2l_nest(test_dt, cols2l = c("val1", "val2"), by = "id")
    expect_equal(nrow(result), 8)  # 2 value columns × 4 ids
    
    # Empty groups
    empty_dt <- test_dt[0,]
    result <- w2l_nest(empty_dt, cols2l = c("val1", "val2"))
    expect_equal(nrow(result), 0)
  })
  
  # Test nested data content
  test_that("nested data content is correct", {
    result <- w2l_nest(test_dt, cols2l = c("val1", "val2"), by = "group")
    
    # Check first nested dataset
    first_nest <- result$data[[1]]
    expect_true(data.table::is.data.table(first_nest))
    expect_equal(names(first_nest), c("id", "value"))
    
    # Verify values are correctly nested
    group_a_val1 <- result[name == "val1" & group == "A"]$data[[1]]
    expect_equal(group_a_val1$value, c(10, 20))
    
    group_b_val2 <- result[name == "val2" & group == "B"]$data[[1]]
    expect_equal(group_b_val2$value, c(300, 400))
  })
})
