# WARNING - Generated by {fusen} from dev/flat_teaching.Rmd: do not edit by hand

# Create test data
create_test_data <- function() {
  dt <- data.table(
    id = 1:10,
    x1 = letters[1:10],
    x2 = LETTERS[1:10],
    x3 = month.abb[1:10],
    group = rep(c("A", "B"), each = 5)
  )
  return(dt)
}

# Basic functionality test
test_that("c2p_nest returns correct structure", {
  test_data <- create_test_data()
  
  # Test with basic parameters
  result <- c2p_nest(test_data, cols2bind = c("x1", "x2", "x3"))
  
  # Check return structure
  expect_true(is.data.table(result))
  expect_true(all(c("pairs", "data") %in% names(result)))
  expect_equal(ncol(result), 2)
  
  # Check pairs combinations
  expected_pairs <- combn(c("x1", "x2", "x3"), 2, paste, collapse = "-")
  expect_equal(sort(unique(result$pairs)), sort(expected_pairs))
  
  # Check nested data structure
  expect_true(all(sapply(result$data, is.data.table)))
  first_nested_dt <- result$data[[1]]
  expect_true(all(c("id", "group", "value1", "value2") %in% names(first_nested_dt)))
})

# Test different nest_type options
test_that("c2p_nest handles different nest_type correctly", {
  test_data <- create_test_data()
  
  # Test with dt
  result_dt <- c2p_nest(test_data, cols2bind = c("x1", "x2"), nest_type = "dt")
  expect_true(all(sapply(result_dt$data, is.data.table)))
  
  # Test with df
  result_df <- c2p_nest(test_data, cols2bind = c("x1", "x2"), nest_type = "df")
  expect_true(all(sapply(result_df$data, is.data.frame)))
  expect_false(any(sapply(result_df$data, is.data.table)))
})

# Test grouping functionality
test_that("c2p_nest handles grouping correctly", {
  test_data <- create_test_data()
  
  # Test with by parameter
  result <- c2p_nest(test_data, cols2bind = c("x1", "x2"), by = "group")
  
  # Check structure
  expect_true(all(c("pairs", "group", "data") %in% names(result)))
  
  # Check grouping results
  expect_equal(nrow(result), length(unique(test_data$group)) * choose(2, 2))
  
  # Check that each group contains correct data
  first_group_data <- result[group == "A"]$data[[1]]
  expect_equal(nrow(first_group_data), 5)
})

# Test pairs_n parameter
test_that("c2p_nest handles different pairs_n correctly", {
  test_data <- create_test_data()
  
  # Test with pairs_n = 2
  result_2 <- c2p_nest(test_data, cols2bind = c("x1", "x2", "x3"), pairs_n = 2)
  expect_equal(nrow(result_2), choose(3, 2))
  
  # Test with pairs_n = 3
  result_3 <- c2p_nest(test_data, cols2bind = c("x1", "x2", "x3"), pairs_n = 3)
  expect_equal(nrow(result_3), choose(3, 3))
})

# Error handling tests
test_that("c2p_nest handles invalid inputs correctly", {
  test_data <- create_test_data()
  
  # Invalid data type
  expect_error(c2p_nest(list(), cols2bind = c("x1", "x2")))
  
  # Invalid cols2bind
  expect_error(c2p_nest(test_data, cols2bind = "non_existent_col"))
  expect_error(c2p_nest(test_data, cols2bind = 100))
  expect_error(c2p_nest(test_data, cols2bind = list()))
  
  # Invalid by parameter
  expect_error(c2p_nest(test_data, cols2bind = c("x1", "x2"), by = "non_existent_col"))
  expect_error(c2p_nest(test_data, cols2bind = c("x1", "x2"), by = 100))
  
  # Invalid pairs_n
  expect_error(c2p_nest(test_data, cols2bind = c("x1", "x2"), pairs_n = 1))
  expect_error(c2p_nest(test_data, cols2bind = c("x1", "x2"), pairs_n = 3))
  expect_error(c2p_nest(test_data, cols2bind = c("x1", "x2"), pairs_n = 1.5))
  
  # Invalid nest_type
  expect_error(c2p_nest(test_data, cols2bind = c("x1", "x2"), nest_type = "invalid"))
})

# Test different input column specifications
test_that("c2p_nest handles different column specifications correctly", {
  test_data <- create_test_data()
  
  # Test with column names
  result_names <- c2p_nest(test_data, cols2bind = c("x1", "x2"))
  
  # Test with column indices
  result_indices <- c2p_nest(test_data, cols2bind = c(2, 3))
  
  # Results should be identical
  expect_equal(result_names, result_indices)
})

# Test separator parameter
test_that("c2p_nest handles different separators correctly", {
  test_data <- create_test_data()
  
  # Test with different separators
  result_dash <- c2p_nest(test_data, cols2bind = c("x1", "x2"), sep = "-")
  result_underscore <- c2p_nest(test_data, cols2bind = c("x1", "x2"), sep = "_")
  
  # Check pair names
  expect_true(all(grepl("-", result_dash$pairs)))
  expect_true(all(grepl("_", result_underscore$pairs)))
})
