% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rmax.R
\name{rmaxp}
\alias{rmaxp}
\title{Maximum possible gain}
\usage{
rmaxp(
  traits,
  ref = NULL,
  clmin = 2,
  clmax,
  meanvec = NULL,
  criteria = NULL,
  data
)
}
\arguments{
\item{traits}{A vector with the names of the columns in the data corresponding to the target traits to be optimized, i.e., those included in the objective function.}

\item{ref}{Name of the reference column (e.g., genotype ID). Defaults to the first column.}

\item{clmin}{An integer specifying the minimum group size. If omitted, equal to 2.}

\item{clmax}{An integer specifying the maximum group size. If omitted, equal to \code{clmin}.}

\item{meanvec}{A named numeric vector of trait means; if omitted, data are assumed to be already normalized by the mean.}

\item{criteria}{A named numeric vector indicating the selection criterion for each trait: 1 for traits to be increased, -1 for traits to be decreased. If omitted, all traits are assumed to be selected for increase.}

\item{data}{A data frame comprising the input data consisting of the Predictors of genetic effects, which serve as the basis for the selection procedure.}
}
\value{
A list with the following components:
\itemize{
\item \code{gain}  with the gains of the several traits in each dimension
\item \code{selected}  with the reference of the clones selected in the group of each dimension
}
}
\description{
The maximum possible is the mean of the EBLUPs of the genotypic effects of the best n clones in a given trait, as a percentage of the overall mean. This function calculates the maximum possible gain achieved in the specified traits.
}
\note{
The order of the traits must be consistent across \code{traits}, \code{meanvec}, and \code{criteria}.
}
\examples{
mymeanvec <- c(pa = 12.760)
mytraits <- c("pa")
maxpos <- rmaxp(
   traits = mytraits,
   clmin = 7,
   clmax = 20,
   meanvec = mymeanvec,
   data = Gouveio
   )
maxpos
}
\references{
Surgy, S., Cadima, J. & Gonçalves, E. Integer programming as a powerful tool for polyclonal selection in ancient grapevine varieties. Theor Appl Genet 138, 122 (2025). \doi{10.1007/s00122-025-04885-0}
}
