% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Main.R
\name{polyclonal}
\alias{polyclonal}
\title{Integer programming calculations}
\usage{
polyclonal(
  traits,
  ref = NULL,
  clmin = 2,
  clmax,
  dmg = NULL,
  meanvec = NULL,
  criteria = NULL,
  data
)
}
\arguments{
\item{traits}{A vector with the names of the columns in the data corresponding to the target traits to be optimized, i.e., those included in the objective function.}

\item{ref}{Name of the reference column (e.g., genotype ID). Defaults to the first column.}

\item{clmin}{An integer specifying the minimum group size. If omitted, equal to 2.}

\item{clmax}{An integer specifying the maximum group size. If omitted, equal to \code{clmin}.}

\item{dmg}{A \code{data.frame} with three columns defining constraints: trait names; constraints signs (\code{">="}, \code{"<="} or \code{"=="}); and  \emph{right-hand side} values of the constraints.}

\item{meanvec}{A named numeric vector of trait means; if omitted, data are assumed to be already normalized by the mean.}

\item{criteria}{A named numeric vector indicating the selection criterion for each trait: 1 for traits to be increased, -1 for traits to be decreased. If omitted, all traits are assumed to be selected for increase.}

\item{data}{A data frame comprising the input data consisting of the Predictors of genetic effects, which serve as the basis for the selection procedure.}
}
\value{
A list with the following components:
\itemize{
\item \code{gain}  with the gains of the several traits in each dimension
\item \code{selected}  with the reference os the clones selected in the group of each dimension
}
}
\description{
This function maximizes the predicted genetic gain in the selection of groups of genotypes based on the predictors of genotypic effects.
}
\note{
The order of traits must be consistent across \code{traits}, \code{dmg}, \code{meanvec}, and \code{criteria}. Both \code{meanvec} and \code{criteria} must include values for all traits specified in \code{traits} and \code{dmg}.
}
\examples{
mymeanvec <- c(yd = 3.517, pa = 12.760, ta = 4.495, ph = 3.927, bw = 1.653)
mytraits <- c("yd", "pa",  "ta", "ph", "bw")
mydmg <- data.frame(
  lhs = c("yd", "pa", "ta", "ph", "bw"),
  rel = c(">=", ">=", ">=", ">=", ">="),
  rhs = c(20, 3, 3, 1, 2)
  )
mycriteria <- c(yd = 1, pa = 1, ta = 1, ph = -1, bw = -1)
selections <- polyclonal(
   traits = mytraits,
   clmin = 7,
   clmax = 20,
   dmg = mydmg,
   meanvec = mymeanvec,
   criteria = mycriteria,
   data = Gouveio
   )
selections
summary(selections)
}
\references{
Surgy, S., Cadima, J. & Gonçalves, E. Integer programming as a powerful tool for polyclonal selection in ancient grapevine varieties. Theor Appl Genet 138, 122 (2025). \doi{10.1007/s00122-025-04885-0}
}
