% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_fict.R
\docType{data}
\name{fict_greys}
\alias{fict_greys}
\title{One-mode undirected network of characters hook-ups on Grey's Anatomy TV show}
\format{
\if{html}{\out{<div class="sourceCode">}}\preformatted{#> -- # Grey's Anatomy ------------------------------------------------------------
#> # A labelled, undirected network of 53 characters and 56 hook-up ties
#> 
#> -- Nodes
#> # A tibble: 53 x 7
#>   name               sex   race  birthyear position  season sign  
#>   <chr>              <chr> <chr>     <dbl> <chr>      <dbl> <chr> 
#> 1 Addison Montgomery F     White      1967 Attending      1 Libra 
#> 2 Adele Webber       F     Black      1949 Non-Staff      2 Leo   
#> 3 Teddy Altman       F     White      1969 Attending      6 Pisces
#> 4 Amelia Shepherd    F     White      1981 Attending      7 Libra 
#> 5 Arizona Robbins    F     White      1976 Attending      5 Leo   
#> 6 Rebecca Pope       F     White      1975 Non-Staff      3 Gemini
#> # i 47 more rows
#> 
#> -- Ties
#> # A tibble: 56 x 2
#>    from    to
#>   <int> <int>
#> 1     5    47
#> 2    21    47
#> 3     5    46
#> 4     5    41
#> 5    18    41
#> 6    21    41
#> # i 50 more rows
#> 
}\if{html}{\out{</div>}}
}
\usage{
data(fict_greys)
}
\description{
Grey's Anatomy is an American medical drama television series running on ABC since 2005.
It focuses on the personal and professional lives of surgical interns, residents, and attendings
at Seattle Grace Hospital, later renamed as the Grey Sloan Memorial Hospital.
\href{https://gweissman.github.io/post/grey-s-anatomy-network-of-sexual-relations/}{Gary Weissman}
collected data on the sexual contacts between characters on the television show
through observation of the story lines in the episodes and fan pages,
and this data was extended by
\href{http://badhessian.org/2012/09/lessons-on-exponential-random-graph-modeling-from-greys-anatomy-hook-ups/}{Benjamin Lind}
including nodal attributes:
\itemize{
\item 'name': first and, where available, surname
\item 'sex': \code{F} for female and \code{M} for male
\item 'race': \code{White}, \code{Black}, or \code{Other}
\item 'birthyear': year born (some missing data)
\item 'position': \code{"Chief"}, \code{"Attending"}, \code{"Resident"}, \code{"Intern"}, \code{"Nurse"}, \code{"Non-Staff"}, \code{"Other"}
\item 'season': season that the character joined the show
\item 'sign': character's astrological starsign, if known
}

The data is current up to (I think?) season 10?
}
\author{
Gary Weissman and Benjamin Lind
}
\keyword{datasets}
