% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mExplorer.R
\name{mExplorer}
\alias{mExplorer}
\title{Selection of process-specific regulators from high-throughput data using multinomial regression models.}
\usage{
mExplorer(dframe, response, interactions = F, significance = 0.05,
  n_cores = 1, multitest = "BY")
}
\arguments{
\item{dframe}{Data frame of predictors. Row and column names are required for identifying samples (genes) and predictors (gene regulators), respectively.}

\item{response}{Vector of factors. Names of vector need to correspond to rownames in dframe.}

\item{interactions}{If enabled, pairs of predictors as interactions will be evaluated (much slower).}

\item{significance}{Significance cutoff for p-values from log likelihood ratio tests.}

\item{n_cores}{Number of processor cores to engage in computation. Use all available cores by default (n_cores=0).}

\item{multitest}{Method to perform multiple testing correction for p-values from predictor evaluation. See p.adjust() for details.}
}
\value{
Vector of scores, with names corresponding to predictors.
}
\description{
Selection of process-specific regulators from high-throughput data using multinomial regression models.
}
\examples{
\donttest{
data(yeastCCgenes)
data(yeastTFdata)
mExplorer(yeastTFdata, yeastCCgenes)
}
data(mExplorer_small_test_data)
small_test_results = mExplorer(small_test_dframe, small_test_response_vec)
}
\references{
m:Explorer - multinomial regression models reveal positive and negative regulators of longevity in yeast quiescence (2012, Genome Biology) by Juri Reimand, Anu Aun, Jaak Vilo, Juan M. Vaquerizas, Juhan Sedman, and Nicholas M. Luscombe
}
\author{
Juri Reimand <juri.reimand@utoronto.ca>
}
