% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithm-trk.R
\name{track_sensor_gatziolis2019}
\alias{track_sensor_gatziolis2019}
\alias{Gatziolis2019}
\title{Sensor tracking algorithm}
\usage{
Gatziolis2019(SEGLENFactor = 1.0059, AngleFactor = 0.8824, deltaT = 0.5)
}
\arguments{
\item{SEGLENFactor}{scalar. Weighting factor for the distance b/w 1st and last pulse returns}

\item{AngleFactor}{scalar. Weighting factor for view angle of mother pulse of a return}

\item{deltaT}{scalar. TimeBlock duration (in seconds)}
}
\description{
This function is made to be used in \link{track_sensor}. It implements an algorithm from Gatziolis
and McGaughey 2019 (see reference) for sensor tracking using multiple returns to estimate the positioning
of the sensor by computing the intersection in space of the lines passing through the first and
last returns.
}
\details{
In the original paper, two steps are described: (1) closest point approach (CPA) and (2) cubic
spline fitting. Technically, the cubic spline fitting step is a post-processing step and is not
included in this algorithm.\cr\cr
The source code of the algorithm is a slight modification of the original source code provided
with the paper to fit with the lidR package.
}
\examples{
# A valid file properly populated
LASfile <- system.file("extdata", "Topography.laz", package="lidR")
las = readLAS(LASfile)
flightlines <- track_sensor(las, Gatziolis2019())

plot(las@header)
plot(flightlines, add = TRUE)
}
\references{
Gatziolis, D., & McGaughey, R. J. (2019). Reconstructing Aircraft Trajectories from
Multi-Return Airborne Laser-Scanning Data. Remote Sensing, 11(19), 2258.
}
\author{
Demetrios Gaziolis and Jean-Romain Roussel
}
