% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_lares.R
\name{theme_lares}
\alias{theme_lares}
\title{Theme for ggplot2 (lares)}
\usage{
theme_lares(
  font = Sys.getenv("LARES_FONT"),
  size = 12,
  main_colour = "darkorange3",
  hard_colour = "black",
  soft_colour = "grey30",
  plot_colour = "transparent",
  panel_colour = "transparent",
  background = "transparent",
  no_facets = FALSE,
  legend = NULL,
  grid = TRUE,
  axis = TRUE,
  clean = FALSE,
  mg = 9,
  pal = 0,
  palette = NULL,
  which = "fc",
  quiet = TRUE,
  ...
)
}
\arguments{
\item{font, size}{Character and numeric. Base font family and base size for texts.
\code{Arial Narrow} is set by default when the library is loaded; you may change it
with \code{Sys.setenv("LARES_FONT" = "X")} or by using this parameter manually.
If \code{font} is "ignore" or NA, it'll be ignored.}

\item{main_colour, hard_colour, soft_colour, plot_colour, panel_colour}{Character. Main colours for your theme.}

\item{background}{Character. Main colour for your background. Overwrites
\code{plot_colour} and \code{panel_colour}.}

\item{no_facets}{Boolean. Suppress facet labels?}

\item{legend}{Character. Legend position: \code{"top"}, \code{"right"},
\code{"bottom"}, or \code{"left"} You can also set to \code{FALSE} or
\code{"none"} to suppress legend.}

\item{grid}{Character or Boolean. Use \code{TRUE/FALSE} or a combination of
\code{X}, \code{x}, \code{Y}, \code{y} to enable/disable minor and major grids.}

\item{axis}{Character or Boolean. Use \code{TRUE/FALSE}, \code{x} or \code{Y}
to enable X and/or Y axis lines.}

\item{clean}{Boolean. Suppress grids and axis? Overwrites both parameters.}

\item{mg}{Numeric. External margins reference.}

\item{pal}{Integer. \code{1} for fill and colour palette,
\code{2} for only colour palette, \code{3} for only fill palette, \code{4} for
personal labels-colour palette. \code{0} for nothing.}

\item{palette}{Character vector. Pass a vector with HEX colour
codes to use a custom palette. If you pass a named vector, the name values will be
used as fill and the values will be used as colour.}

\item{which}{Character. When \code{pal = 3}, select which colours should be
added with the custom colours palette: fill, colour, text (fct) - first letters.}

\item{quiet}{Boolean. Keep quiet? If not, informative messages will be shown.}

\item{...}{Additional parameters.}
}
\value{
Themed ggplot2 object
}
\description{
Based on \code{hrbrthemes}' \code{theme_ipsum} and customized for \code{lares} usage.
With this team you can custom the colour and fill palettes, global colour parameters,
major and minor grids, legend, font and font size.
}
\section{Why Arial Narrow?}{

First and foremost, Arial Narrow is generally installed by default or readily
available on any modern system, so it's "free"-ish; plus, it is a condensed font
with solid default kerning pairs and geometric numbers.
}

\examples{
\donttest{
data(dft)
library(ggplot2)
p <- ggplot(dft, aes(x = Pclass, y = sum(Fare), fill = Pclass)) +
  geom_col()
p + theme_lares()
p + theme_lares(pal = 1)
p + theme_lares(background = "#999999", mg = 25)
p + theme_lares(legend = "top", grid = "Yy")
p + theme_lares(clean = TRUE)
}
}
\seealso{
Other Themes: 
\code{\link{gg_fill_customs}()},
\code{\link{lares_pal}()},
\code{\link{plot_palette}()}
}
\concept{Themes}
