% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ksrlive.R
\name{random.data}
\alias{random.data}
\title{Create random data}
\usage{
random.data(data, back_data = NULL, n = 50, random.seed = NULL)
}
\arguments{
\item{data}{data frame of time course of substrates, each substrate is a row}

\item{back_data}{data frame of numeric values that can to be used as background data, 
if not provided a values are drawn from a uniform distribution between minimum and maximum
of input data}

\item{n}{numeric specifying how many rows should be contained in the resulting data frame}

\item{random.seed}{numeric used as seed}
}
\value{
data frame of random numeric values with n-nrow(data) rows and same number of 
columns as input data

}
\description{
\code{random.data} returns a data frame of random numeric values
}
\details{
The function random.data returns a data frame of random numeric values with the same 
number of columns as the input data and with n-nrow(data) rows. By default the values are drawn
from a uniform distribution of values between the minimum and the maximum of the input data. Values
can be drawn from background data instead if included.
}
\examples{
data(phosphonetworkdf)
data(datakin)
# only need what is present in data
phosphonetwork_data <- phosphonetwork_df[
phosphonetwork_df[,"SUB_IDENT"] \%in\% data_kin[,"SUB_IDENT"]
,]
fam <- list(akt = c("P31749", "P31751"))
kin_data_fam_exc <- KSR.list(phosphonetwork_data[, c("SUB_IDENT", "KIN_ACC_ID")], 
                             kinasefamilies = fam,
                             exclusive = TRUE)
# only do for Akt and Mtor (P31749, P42345)
substrate_profiles <- lapply(kin_data_fam_exc[c("P31749", "P42345")], 
function(x){data_kin[match(x, data_kin[,"SUB_IDENT"]),1:9]})

substrate_profiles_random <- lapply(substrate_profiles, 
function(x){rbind(x, random.data(x, random.seed = 123))})
}

