% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/seriation_permute.R
\docType{methods}
\name{permute}
\alias{permute}
\alias{permute-method}
\alias{permute,data.frame,PermutationOrder-method}
\alias{permute,matrix,PermutationOrder-method}
\title{Rearrange a Data Matrix}
\usage{
permute(object, order, ...)

\S4method{permute}{data.frame,PermutationOrder}(object, order)

\S4method{permute}{matrix,PermutationOrder}(object, order)
}
\arguments{
\item{object}{A \eqn{m \times p}{m x p} \code{numeric} \code{\link{matrix}} or
\code{\link{data.frame}} of count data (absolute frequencies giving the number of
individuals for each category, i.e. a contingency table).}

\item{order}{A \code{\linkS4class{PermutationOrder}} object giving the permutation
order for rows and columns.}

\item{...}{Currently not used.}
}
\value{
A permuted \code{matrix} or a permuted \code{data.frame} (the same as \code{object}).
}
\description{
Rearranges a data matrix according to a permutation order.
}
\examples{
## Replicates Desachy 2004 results
data("compiegne", package = "folio")

## Get seriation order for columns on EPPM using the reciprocal averaging method
## Expected column order: N, A, C, K, P, L, B, E, I, M, D, G, O, J, F, H
(indices <- seriate_rank(compiegne, EPPM = TRUE, margin = 2))

## Get permutation order
order_rows(indices)
order_columns(indices)

## Permute columns
(new <- permute(compiegne, indices))
}
\seealso{
Other seriation methods: 
\code{\link{as_seriation}()},
\code{\link{assess}()},
\code{\link{order}()},
\code{\link{refine}()},
\code{\link{seriate_average}()},
\code{\link{seriate_rank}()}
}
\author{
N. Frerebeau
}
\concept{seriation methods}
