% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reverse_pointer.R
\name{reverse_pointer}
\alias{reverse_pointer}
\title{Reverse DNS pointer}
\usage{
reverse_pointer(x)
}
\arguments{
\item{x}{An \code{\link{ip_address}} vector}
}
\value{
A character vector
}
\description{
Returns the PTR record used by reverse DNS.
}
\details{
These documents describe reverse DNS lookup in more detail:
\itemize{
\item \strong{IPv4:} \href{https://www.rfc-editor.org/rfc/rfc1035}{RFC-1035 Section 3.5}
\item \strong{IPv6:} \href{https://www.rfc-editor.org/rfc/rfc3596}{RFC-3596 Section 2.5}
}
}
\examples{
reverse_pointer(ip_address("127.0.0.1"))

reverse_pointer(ip_address("2001:db8::1"))
}
