% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iotable_year_get.R
\name{iotable_year_get}
\alias{iotable_year_get}
\title{Get available years from bulk IO tables}
\usage{
iotable_year_get(
  labelled_io_data = NULL,
  source = "germany_1995",
  geo = "DE",
  unit = "MIO_EUR",
  time_unit = "year",
  stk_flow = "TOTAL",
  data_directory = NULL,
  force_download = TRUE
)
}
\arguments{
\item{labelled_io_data}{Optional labelled IO data from
\code{\link[=iotables_download]{iotables_download()}}. If supplied, avoids re-reading from disk.}

\item{source}{Character. Eurostat product code (see Details).}

\item{geo}{Country code or name (e.g. \code{"SK"} or \code{"Slovakia"}).}

\item{unit}{Currency unit. Defaults to \code{"MIO_NAC"} (millions of national
currency). Alternative: \code{"MIO_EUR"}.}

\item{time_unit}{Return mode for time. \code{"year"} (default) returns numeric
years; \code{"time"} returns a vector of dates.}

\item{stk_flow}{Flow type. Defaults to \code{"DOM"} (domestic output).
Alternatives:
\itemize{
\item \code{"IMP"} for imports
\item \code{"TOTAL"} for total output
For sources \code{"naio_10_cp1620"} (margins) and \code{"naio_10_cp1630"} (taxes),
only \code{"TOTAL"} is used.
}}

\item{data_directory}{Optional path used with \code{\link[=iotable_get]{iotable_get()}} or
\code{\link[=iotables_download]{iotables_download()}} to persist bulk data.}

\item{force_download}{Logical. Defaults to \code{TRUE}. If \code{FALSE}, reuse an
existing file in \code{data_directory} or \code{tempdir()} when available.}
}
\value{
A numeric vector of years, or a date vector if
\code{time_unit = "time"}.
}
\description{
Query which years are available for a given Eurostat IO product,
country (\code{geo}), and currency unit in a bulk download.
}
\details{
This function is usually called indirectly via \code{\link[=iotable_get]{iotable_get()}}.
You normally do not need to call \code{\link[=iotables_download]{iotables_download()}} yourself
unless working with bulk Eurostat files.

Supported Eurostat products include (non-exhaustive):
\itemize{
\item \code{"naio_10_cp1700"} — Symmetric IO table, basic prices (product × product)
\item \code{"naio_10_cp1750"} — Symmetric IO table, basic prices (industry × industry)
\item \code{"naio_10_pyp1700"} — Symmetric IO table (product × product),
previous years’ prices
\item \code{"naio_10_pyp1750"} — Symmetric IO table (industry × industry),
previous years’ prices
\item \code{"naio_10_cp1620"} / \code{"naio_10_pyp1620"} — Trade & transport margins
\item \code{"naio_10_cp1630"} / \code{"naio_10_pyp1630"} — Taxes less subsidies on products
}

See the \href{https://ec.europa.eu/eurostat/web/esa-supply-use-input-tables/overview}{Eurostat Symmetric Input–Output Tables page}.
}
\examples{
germany_years <- iotable_year_get(
  source = "germany_1995", geo = "DE", unit = "MIO_EUR"
)
# Return as dates
germany_dates <- iotable_year_get(
  source = "germany_1995", geo = "DE",
  unit = "MIO_EUR", time_unit = "time"
)

}
\seealso{
Other iotables processing functions: 
\code{\link{conforming_vector_create}()},
\code{\link{empty_remove}()},
\code{\link{household_column_find}()},
\code{\link{household_column_get}()},
\code{\link{key_column_create}()},
\code{\link{matrix_round}()},
\code{\link{output_get}()},
\code{\link{primary_input_get}()},
\code{\link{rows_add}()},
\code{\link{supplementary_add}()},
\code{\link{total_tax_add}()},
\code{\link{vector_transpose_longer}()},
\code{\link{vector_transpose_wider}()}
}
\concept{iotables processing functions}
