% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{inline_switch}
\alias{inline_switch}
\title{Inline on/off switch}
\usage{
inline_switch(id, value, on = "On", off = "Off", meaning = NULL)
}
\arguments{
\item{id}{The \code{input} slot that will be used to access the value.}

\item{value}{Whether the switch is initially off or on; \code{FALSE} for off,
\code{TRUE} for on.}

\item{on, off}{Labels that will appear to the right of the switch when the
switch is on or off, respectively. These can be character strings or
HTML elements. For example, you can style these with a
\link[htmltools:builder]{span} and apply one of the
\href{https://getbootstrap.com/docs/5.3/utilities/colors/}{Bootstrap 5 text color classes}
(see examples). \code{NULL} for no labels.}

\item{meaning}{A descriptive label, for people using assistive technology
such as screen readers.}
}
\value{
An inline widget to be included in an \code{\link[=inline]{inline()}} wrapper.
}
\description{
An on/off switch widget similar to \code{\link[bslib:input_switch]{bslib::input_switch()}} that can be
included in an \code{\link[=inline]{inline()}} wrapper.
}
\examples{
ui <- bslib::page_fixed(
    shiny::h1("Switch test"),
    inline("The server is now ",
        inline_switch("myswitch", TRUE,
            on = shiny::span(class = "text-success", "powered ON"),
            off = shiny::span(class = "text-danger", "powered OFF"),
            meaning = "Server power switch"),
        "."
    )
)
}
\seealso{
\link[bslib:input_switch]{bslib::input_switch} for how the switch works with your Shiny server.
}
