% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/action.R
\name{inline_button}
\alias{inline_button}
\title{Inline action button}
\usage{
inline_button(id, label, icon = NULL, meaning = label, accent = NULL)
}
\arguments{
\item{id}{The \code{input} slot that will be used to access the value.}

\item{label}{The text appearing within the button. This can be a character
string or any other HTML, or \code{NULL} for no text (but then you will
probably at least want an \code{icon}).}

\item{icon}{An optional \code{\link[shiny:icon]{shiny::icon()}} which will appear to the left of the
button.}

\item{meaning}{A descriptive label, for people using assistive technology
such as screen readers.}

\item{accent}{A Bootstrap "accent" (such as \code{"primary"}, \code{"danger"}, etc.)
that will be used to set the class of the button (such as \code{"btn-primary"},
etc.), or \code{NULL} for the default (\code{"btn-default"}). See
\href{https://getbootstrap.com/docs/5.3/components/buttons/}{Bootstrap 5 buttons}
for all the options. If you provide multiple accents in a character
vector, each one will be appended to \code{"btn-"} and added to the button.}
}
\value{
An inline widget to be included in an \code{\link[=inline]{inline()}} wrapper.
}
\description{
A button widget similar to \code{\link[shiny:actionButton]{shiny::actionButton()}} that can be included in an
\code{\link[=inline]{inline()}} wrapper.
}
\examples{
ui <- bslib::page_fixed(
    shiny::h1("A wonderful button"),
    inline("To update, please feel free to press the ",
        inline_button("mybutton",
            label = shiny::span(style = "font-style:italic", "button"),
            icon = shiny::icon("play"),
            meaning = "Update button", accent = "success"),
        "."
    )
)
}
\seealso{
\link[shiny:actionButton]{shiny::actionButton} for how the button works with your Shiny server.
}
