\name{pbeta4me}
\alias{pbeta4me}

\title{
Phylogenetic Beta Biversity for MacroEcology
}
\description{
It estimates the phylogenetic beta diversity of focal cells within a SpatVector 
object by considering neighboring cells located within a specified buffer.
}
\usage{
pbeta4me(PAM, PHYLO, SHP, width = 10000, index.family="sorensen", verbose =TRUE)
}

\arguments{
  \item{PAM}{
  A presence/absence matrix where sites are organized in rows and species in 
  columns.
}
  \item{PHYLO}{
  A phylogenetic rooted tree, which includes branch lengths, is required. The 
  tip labels must exactly match the species names in the presence/absence 
  matrix (PAM).
}
  \item{SHP}{
  A SpatVector object representing cells distributed over a geographic space
}
  \item{width}{
  Refers to the radius of the buffer. If the SpatVector object uses a 
  latitude/longitude projection, the width is specified in meters.
}
  \item{index.family}{
  Choose either the 'sorensen' or 'jaccard' dissimilarity index.
}
  \item{verbose}{
  Logical, indicating whether messages and the progress bar are shown. The 
  default is TRUE.
}
}

\value{
The function returns a data frame that includes turnover, nestedness, total 
beta diversity, and the number of cells contributing to the mean diversity of 
the focal cell. The IDs of the cells are used as the row names of the 
data frame.
}

\references{
Graham, C. H., & Fine, P. V. (2008). Phylogenetic beta diversity: linking 
ecological and evolutionary processes across space in time. Ecology letters, 
11(12), 1265-1277.
}

\author{
Guevara, R., roger.guevara@inecol.mx
}

\examples{
%Example 1
data(PHYLO)
data(PAM)
SHP <- terra::vect(paste(system.file("extdata", package = "inecolr"),
"/test.shp", sep=""))
SHP <- SHP[1:10]
pb_beta <- pbeta4me(PAM, PHYLO, SHP, width = 10000, index.family="sorensen")
head(pb_beta)

%Example 2
data(PHYLO)
data(PAM)
SHP <- terra::vect(paste(system.file("extdata", package = "inecolr"),
"/test.shp", sep=""))
SHP <- SHP[1:10]
pb_beta <- pbeta4me(PAM, PHYLO, SHP, width = 10000, index.family="sorensen", 
verbose=FALSE)
head(pb_beta)
}
