% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rawplot.R
\name{plot.inz_ts}
\alias{plot.inz_ts}
\title{Draw a simple time series plot}
\usage{
\method{plot}{inz_ts}(
  x,
  var = NULL,
  xlab = NULL,
  ylab = NULL,
  title = NULL,
  xlim = NULL,
  aspect = NULL,
  compare = TRUE,
  pal = NULL,
  smoother = TRUE,
  sm_model = "stl",
  t = 0,
  mult_fit = FALSE,
  emphasise = NULL,
  non_emph_opacity = 0.2,
  show_iso_obs = TRUE,
  iso_obs_size = 1,
  seasonal_adjustment = FALSE,
  ...
)
}
\arguments{
\item{x}{An \code{inzightts} (\code{inz_ts}) object representing the time series.}

\item{var}{A character vector specifying the variable(s) to be plotted,
or set to \code{NULL}.}

\item{xlab}{A title for the x-axis of the plot.}

\item{ylab}{A title for the y-axis of the plot.}

\item{title}{A title for the graph.}

\item{xlim}{Axis limits, specified as dates or years.}

\item{aspect}{The aspect ratio of the plot; it will be about \code{aspect} times
wider than it is high.}

\item{compare}{Logical; set to \code{TRUE} to plot the key levels in a single
plot.}

\item{pal}{(Only if a categorical variable is passed to \code{var}): The colour
palette for the categorical plot. The palette vector should be in
the same order per the rows of \code{tsibble::key_data(x)}.}

\item{smoother}{Logical; if \code{TRUE}, the smoother will be drawn.}

\item{sm_model}{The smoothing method to be used.}

\item{t}{The smoothing parameter (between 0 and 100).}

\item{mult_fit}{Logical; set to \code{TRUE} for a multiplicative model, or
\code{FALSE} for the default additive model.}

\item{emphasise}{Integer vector to specify the key level(s) to focus in the
plot. The integer maps to the specific key level(s)
corresponding to the ith row of \code{tsibble::key_data(x)}.}

\item{non_emph_opacity}{Numeric. If \verb{(0, 1]}, this argument determines the
opacity of the series other than the focused one(s)
(to highlight the focused series). If
\code{non_emph_opacity = 0}, the plot draws the focused
series in its own scales.}

\item{show_iso_obs}{Logical; set to \code{TRUE} to plot isolated observations
between time series gaps (if any).}

\item{iso_obs_size}{Numeric; scaling the size of isolated observations,
if \code{show_iso_obs = TRUE} and they exist.}

\item{seasonal_adjustment}{Logical; set to \code{TRUE} to show the seasonally adjusted time series (i.e., removed the estimated seasonal effects as determined by STL decomoposition; see \code{decomp()}).}

\item{...}{Additional arguments (ignored).}
}
\value{
A time series plot (constructed with ggplot2) is returned, which
can be added to if desired.
}
\description{
Draws a plot of a given \code{inzightts} (\code{inz_ts}) object with the trend
superimposed.
}
\examples{
t <- inzightts(visitorsQ, var = c(2, 4))

\dontrun{
plot(t)
plot(t, var = names(t)[-1])
plot(t, var = "Japan")
plot(t, mult_fit = TRUE)
}

}
\seealso{
\code{\link[tsibble]{key_data}}
}
\keyword{timeseries}
