% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gwrpv.R
\name{loop_calc_pvalue}
\alias{loop_calc_pvalue}
\title{loop_calc_pvalue()}
\usage{
loop_calc_pvalue(lowone, highone, lowtwo, hightwo, lowthree, highthree, n0a,
  n1a, n2a, n0, n1, n2, pa, pb, x, mua, mub, sumsqx, siga, sigb, vary, beta,
  skipiter, pvalue)
}
\arguments{
\item{lowone}{lower bound outer loop}

\item{highone}{upper bound outer loop}

\item{lowtwo}{lower bound middle loop}

\item{hightwo}{upper bound middle loop}

\item{lowthree}{lower bound inner loop}

\item{highthree}{upper bound inner loop}

\item{n0a}{outer loop index}

\item{n1a}{middle loop index}

\item{n2a}{inner loop index}

\item{n0}{the major allele homozygotes}

\item{n1}{the major allele heterozygotes}

\item{n2}{the minor allele zygotes}

\item{pa}{parameter of the mixture distribution, a real number between zero and one with pa+pb=1}

\item{pb}{parameter of the mixture distribution, a real number between zero and one with pa+pb=1}

\item{x}{a zero mean explanatory variable from the SNP data set}

\item{mua}{parameter of the mixture distribution, can be any real number}

\item{mub}{parameter of the mixture distribution, can be any real number}

\item{sumsqx}{sum of the squares of x}

\item{siga}{parameter of the mixture distribution, can be any real number}

\item{sigb}{parameter of the mixture distribution, can be any real number}

\item{vary}{vary <- pa*(mua^2+siga^2)+pb*(mub^2+sigb^2)-(pa*mua+pb*mub)^2}

\item{beta}{the beta from the regression being tested}

\item{skipiter}{flag to determine if we can skip some calculations}

\item{pvalue}{the input pvalue prior to calculating new improved pvalue}
}
\value{
pvalue
}
\description{
calls calc_pvalue()
}

