% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{latex}
\alias{latex}
\title{Interpret input text as LaTeX-formatted text}
\usage{
latex(text)
}
\arguments{
\item{text}{\emph{LaTeX text}

\verb{scalar<character>} // \strong{required}

The text that is understood to be LaTeX text, which is to be preserved in
the LaTeX output context.}
}
\value{
A character object of class \code{latex}. It's tagged as an latex fragment
that is not to be sanitized.
}
\description{
For certain pieces of text (like in column labels or table headings) we may
want to express them as raw LaTeX. In fact, with LaTeX, so much more can be done for formatting.
The \code{latex()} function will guard the input LaTeX from being escaped.
}
\section{Examples}{


Use the \code{\link{exibble}} dataset to create a \strong{gt} table. When adding a title
through \code{\link[=tab_header]{tab_header()}}, we'll use the \code{latex()} helper to signify to \strong{gt}
that we're using LaTeX formatting.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{exibble |>
  dplyr::select(currency, char) |>
  gt() |>
  tab_header(title = latex("\\\\emph\{LaTeX\}"))
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_latex_1.png" alt="This image of a table was generated from the first code example in the `latex()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

8-2
}

\section{Function Introduced}{

\code{v1.0.1} (May 10, 2025)
}

\seealso{
Other helper functions: 
\code{\link{adjust_luminance}()},
\code{\link{cell_borders}()},
\code{\link{cell_fill}()},
\code{\link{cell_text}()},
\code{\link{currency}()},
\code{\link{default_fonts}()},
\code{\link{escape_latex}()},
\code{\link{from_column}()},
\code{\link{google_font}()},
\code{\link{gt_latex_dependencies}()},
\code{\link{html}()},
\code{\link{md}()},
\code{\link{nanoplot_options}()},
\code{\link{pct}()},
\code{\link{px}()},
\code{\link{random_id}()},
\code{\link{row_group}()},
\code{\link{stub}()},
\code{\link{system_fonts}()},
\code{\link{unit_conversion}()}
}
\concept{helper functions}
