% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transport1d.R, R/transport_df.R
\name{transport_df.numeric}
\alias{transport_df.numeric}
\alias{transport_df}
\alias{transport_df.otgridtransport}
\alias{transport_df.otgrid}
\title{Optimal Transport Plan}
\usage{
\method{transport_df}{numeric}(x, y, threshold = 1e-15, ...)

transport_df(x, ...)

\method{transport_df}{otgridtransport}(x, ...)

\method{transport_df}{otgrid}(x, ...)
}
\arguments{
\item{x}{a vector of weights, an object of class \code{"otgridtransport"} or \code{"otgrid"}, in the latter case \code{...} must be the arguments of \code{\link{pivot_measure}}.}

\item{y}{second weight vector.}

\item{threshold}{small value that indicates when a value is considered to be zero.}

\item{...}{further arguments (for \code{\link{pivot_measure}} if \code{x} is an object of class \code{"otgrid"}).}
}
\value{
a data frame representing the optimal transport plan. It has columns \code{from}, \code{to} and \code{mass} that specify
between which points of the two grids how much mass is transported.

In the two-dimensional case, a point is given by the index in column-mayor format and the data frame is actually stored in the element
\code{df} of an object of class \code{"otgridtransport"}.
}
\description{
Calculate the optimal transport plan.
}
\details{
In case of two-dimensional grids, the pivot measure is used to calculate the optimal transport plan.

For one-dimensional optimal transport, we assume that the optimal transport plan is the monotone plan. For example, this is the case
for costs of the form \eqn{c(x, y) = | x - y |^p} for some \eqn{p \geq 1}.
In this case, the north-west-corner algorithm is used.
}
\examples{
## one-dimensional example
set.seed(1)
wa <- rep(1/5, 5)
wb <- runif(6)
wb <- wb / sum(wb)
transport_df(wa, wb)

## two-dimensional example
x <- otgrid(cbind(0:1, 1:0))
y <- otgrid(cbind(1:0, 0:1))

# first calculate pivot manually
pm <- pivot_measure(x, y)
pm <- transport_df(pm)

# or just
pm2 <- transport_df(x, y)
}
\seealso{
pivot measure \code{\link{pivot_measure}}
}
