% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pwe.R
\name{ppwe}
\alias{ppwe}
\title{Cumulative distribution function of the PWE for a vectorized hazard
rate parameter}
\usage{
ppwe(hazard, end_of_study, cutpoints)
}
\arguments{
\item{hazard}{matrix. A matrix of hazard rate parameters with number of
columns equal to the length of the \code{cutpoints} vector. The number of
rows can be anything, and is typically dictated by the number of MCMC
draws.}

\item{end_of_study}{scalar. Length of the study; i.e. time at which endpoint
will be evaluated.}

\item{cutpoints}{vector. The change-point vector indicating time when the
hazard rates change. Note the first element of \code{cutpoints} should
always be 0.}
}
\value{
A vector of (0, 1) probabilities from evaluation of the PWE
cumulative distribution function. Length of the vector matches the number
of rows of the \code{hazard} matrix parameter.
}
\description{
Extends the \code{\link[PWEALL]{pwe}} function to allow for
vectorization over the hazard rates.
}
