% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coord_radial.R
\name{coord_radial}
\alias{coord_radial}
\title{Radial axes}
\usage{
coord_radial(theta = "x", start = 0, direction = 1, clip = "on")
}
\arguments{
\item{theta}{variable to map angle to (\code{x} or \code{y})}

\item{start}{Offset of starting point from 12 o'clock in radians. Offset
is applied clockwise or anticlockwise depending on value of \code{direction}.}

\item{direction}{1, clockwise; -1, anticlockwise}

\item{clip}{Should drawing be clipped to the extent of the plot panel? A
setting of \code{"on"} (the default) means yes, and a setting of \code{"off"}
means no. For details, please see \code{\link[ggplot2:coord_cartesian]{coord_cartesian()}}.}
}
\description{
A radial (spider) coordinate. A wrapper of the function \code{coord_polar()} by
forcing it linear.
}
\details{
The serial histogram and serial density cannot be applied on
a radial coordinate yet.
}
\examples{
if(require("dplyr")) {
ggplot(NBAstats2021, mapping = aes(colour = Playoff)) +
  geom_serialaxes(
    axes.sequence = c("PTS", "OPTS", "3PM", "O3PM", "PTS"),
      scaling = "variable"
    ) +
  coord_radial() +
  scale_x_continuous(
    breaks = 1:5,
    labels = c("Points",
               "Oppo Points",
               "3P Made",
               "Oppo 3P Made",
               "Points Per Game")) +
  scale_y_continuous(labels = NULL) +
  facet_wrap(~CONF)
  }
}
