% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggmugs.R
\name{ggmugs}
\alias{ggmugs}
\title{Visualizing Multiple Genetic Studies}
\usage{
ggmugs(
  study_name = c("sumstat1", "sumstat2", "sumstat3", "sumstat4", "sumstat5"),
  summary_stat = c("data/sumstat1.txt", "data/sumstat2.txt", "data/sumstat3.txt",
    "data/sumstat4.txt", "data/sumstat5.txt"),
  p1 = 0.001,
  p2 = 5e-05,
  p3 = 1e-08,
  color1 = "#FFFFE0",
  color2 = "#FFC300",
  color3 = "#FF5733"
)
}
\arguments{
\item{study_name}{A character vector of names for the studies.}

\item{summary_stat}{A character vector of file paths where each path points to the summary
statistics data file for the corresponding study. Files should be in a tabular format
readable by `fread` from the `data.table` package.
The files should contain 3 fields: `chr` (Chromosome), `pos` (chromosome position), and `p` (association p-value).
The positions of multiple GWAS summary statistics should have consistent genome builds.}

\item{p1}{The first significance level threshold for p-values (default is 1e-3).}

\item{p2}{The second, more stringent significance level threshold for p-values (default is 5e-5).}

\item{p3}{The most stringent significance level threshold for p-values (default is 1e-8).}

\item{color1}{The color for points below the first significance level (default is "#FFFFE0").}

\item{color2}{The color for points between the first and second significance levels (default is "#FFC300").}

\item{color3}{The color for points above the second significance level (default is "#FF5733").}
}
\value{
A `ggplot` object representing the visualization with the specified data.
}
\description{
This function processes and combines summary statistics from multiple genetic studies and
creates a visualization for all studies. The genetic loci are colored based on three significance
thresholds to facilitate the visualization of highly significant genomic regions.
}
\examples{
### NOT RUN
# ggmugs(
#   study_name = c("study1", "study2", "study3", "study4", "study5"),
#   summary_stat = c("https://raw.githubusercontent.com/Broccolito/ggmugs_data/main/sumstat1.txt",
#                    "https://raw.githubusercontent.com/Broccolito/ggmugs_data/main/sumstat2.txt",
#                    "https://raw.githubusercontent.com/Broccolito/ggmugs_data/main/sumstat3.txt",
#                    "https://raw.githubusercontent.com/Broccolito/ggmugs_data/main/sumstat4.txt",
#                    "https://raw.githubusercontent.com/Broccolito/ggmugs_data/main/sumstat5.txt"),
#   p1 = 1e-4,
#   p2 = 1e-6,
#   p3 = 1e-8,
#   color1 = "#FFFFE0",
#   color2 = "#FFC300",
#   color3 = "#FF5733"
# )
}
