% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-class.R
\docType{class}
\name{prior-class}
\alias{prior-class}
\title{An S4 Class to Represent a Joint Prior Distribution}
\value{
An S4 object of class \code{"prior"}, used in computing prior 
densities and visualising prior distributions.
}
\description{
This class encapsulates the structure of prior distributions used in 
hierarchical Bayesian modelling. It stores both subject-level and 
population-level (hyperparameter) priors for a model’s parameters, 
and is used in Bayesian inference workflows, particularly with 
models from the \pkg{lbaModel} or \pkg{ddModel} packages.
}
\section{Slots}{

\describe{
\item{\code{nparameter}}{Integer. Number of free parameters in the model.}

\item{\code{pnames}}{Character vector. Names of the free parameters.}

\item{\code{p_prior}}{List. Represents the joint prior distribution at the subject
level, usually constructed from standard or truncated distributions.}

\item{\code{h_prior}}{List. Representing the joint prior at the population 
level, typically containing location and scale parameters for hierarchical
models. The 'h' prefix refers to hyperparameters.}
}}

\section{Structure}{

An object of class \code{"prior"} contains the following components:
\describe{
  \item{\code{nparameter}}{Number of free parameters.}
  \item{\code{pnames}}{Names of the model's free parameters.}
  \item{\code{p_prior}}{Subject-level prior specification. Conceptually
analogous to the model likelihood in a hierarchical Bayesian model.}
  \item{\code{h_prior}}{Hyperparameter-level (group-level) prior specification.}
}
}

\section{Usage}{

Used to define priors for hierarchical Bayesian cognitive models. This 
class allows structured specification of priors at both individual and 
group levels. Prior objects are commonly constructed using 
\code{\link{set_priors}}, which integrates multiple \code{\link{BuildPrior}} 
outputs into a single prior structure.
}

\seealso{
\code{\link{BuildPrior}}
}
