% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggdmcPrior.R
\name{BuildPrior}
\alias{BuildPrior}
\title{Build a Joint Prior Distribution}
\usage{
BuildPrior(
  p0,
  p1,
  lower = rep(NA, length(p0)),
  upper = rep(NA, length(p0)),
  dists = rep("norm", length(p0)),
  log_p = rep(TRUE, length(p0)),
  types = c("tnorm", "beta", "gamma", "lnorm", "cauchy", "unif", "norm")
)
}
\arguments{
\item{p0}{the first parameter of a distribution (e.g., mean, shape1, etc.).}

\item{p1}{the second parameter of a distribution (e.g., sd, shape2, etc.).}

\item{lower}{lower support (boundary). Default is \code{NA},
which will be converted to a real value or -Inf based on the distribution
type.}

\item{upper}{upper support (boundary). Default is \code{NA}, which will be
converted to a real value or Inf based on the distribution type.}

\item{dists}{a vector of character strings specifying the distribution type
for each parameter. Valid types are: \code{"tnorm"}, \code{"beta"},
\code{"gamma"}, \code{"lnorm"}, \code{"cauchy"}, \code{"unif"}, and
\code{"norm"}. Default is \code{"norm"}.}

\item{log_p}{logical; if \code{TRUE}, probabilities are given as
\code{log(p)}. Default is \code{TRUE}.}

\item{types}{available distribution types.}
}
\value{
a list of lists, where each sub-list contains the parameter for its
prior definition.
        Each sub-list includes:
        \itemize{
          \item \code{p0}: The first parameter of the distribution.
          \item \code{p1}: The second parameter of the distribution.
          \item \code{lower}: The lower bound of the distribution.
          \item \code{upper}: The upper bound of the distribution.
          \item \code{dist}: A numeric code representing the distribution
                             type.
          \item \code{log_p}: Logical indicating whether probabilities
                              are logged.
        }
}
\description{
\code{BuildPrior} sets up a joint distribution of the prior. Each model
parameter is assigned one probability distribution.
\code{p0} and \code{p1} refer to the first and second parameters.
I use the convention of the 0-based index to work with the C++ and the
Python sister package, 'pydmc' (coming soon). \code{p0} must comes with 
parameter names.
}
\details{
Seven distributions are implemented:
\enumerate{
\item Truncated normal distribution, where: \code{p0 = mean}, \code{p1 = sd}.
      When the lower and upper bounds are not provided, they are set
      to \code{-Inf} and \code{Inf}, rendering a normal distribution
      (see \link{tnorm}). Type name is \code{"tnorm"}.
\item Beta distribution, where: \code{p0 = shape1} and \code{p1 = shape2}
      (see \link{pbeta}). Note the uniform distribution is a special case
      of the beta with \code{p0 = 1} and \code{p1 = 1}. Type name is
      \code{"beta"}.
\item Gamma distribution, where \code{p0 = shape} and \code{p1 = scale}
      (see \link{pgamma}). Note \code{p1} is scale, not rate. Type name is
      \code{"gamma"}.
\item Log-normal, where \code{p0 = meanlog} and \code{p1 = sdlog}
      (see \link{plnorm}). Type name is \code{"lnorm"}.
\item Cauchy distribution, where \code{p0 = location} and \code{p1 = scale}
      (see \link{pcauchy}). Type name is \code{"cauchy"}.
\item Uniform distribution, where \code{p0 = lower} and \code{p1 = upper}
      (see \link{punif}). Type name is \code{"unif"}.
\item Normal distribution, where \code{p0 = mean} and \code{p1 = sd}
      (see \link{pnorm}). Type name is \code{"norm"}.
}
}
\examples{
# Using dbeta to represent a uniform distribution of bounds(0, 1)
x <- seq(-.1, 1.1, .001)
plot(x, dbeta(x, 1, 1),
    type = "l", ylab = "Density", xlab = "x",
    lwd = 2, cex.lab = 1.5, cex.axis = 2
)

## Create an S4 prior object
p_prior <- BuildPrior(
    p0 = c(A = 0.15, B = 0.45, mean_v = 2.25, sd_v = 0.15, t0 = 0.2),
    p1 = rep(0.1, 5),
    lower = rep(NA, 5),
    upper = rep(NA, 5),
    dist = rep("tnorm", 5),
    log_p = rep(NA, 5)
)

print_prior(p_prior)

# Use the beta distribution to create uniform densities
# lower and upper set the bounds. If lower is NA, it will be set to 0.
# If upper is NA, it will be set to 1.
p_prior <- BuildPrior(
    p0 = c(A = 1, B = 1, mean_v = 1, sd_v = 1, t0 = 1),
    p1 = rep(1, 5),
    lower = rep(0, 5),
    upper = rep(5, 5),
    dist = rep("beta", 5),
    log_p = rep(FALSE, 5)
)

p0 <- plot_prior(p_prior, font_size = 3.5, cex = 3.5)
}
