% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grob_arrow_curve.R
\name{grob_arrow_curve}
\alias{grob_arrow_curve}
\title{Arrow curve grob.}
\usage{
grob_arrow_curve(
  x1,
  y1,
  x2,
  y2,
  default.units = "mm",
  curvature = 1,
  angle = 90,
  ncp = 1,
  shape = 0.5,
  square = TRUE,
  squareShape = 1,
  inflect = FALSE,
  open = TRUE,
  name = NULL,
  gp = gpar(),
  vp = NULL,
  ...,
  width_head = unit(1, "mm"),
  width_fins = unit(1, "mm")
)
}
\arguments{
\item{x1}{A numeric vector or unit object specifying the x-location of
    the start point.}

\item{y1}{A numeric vector or unit object specifying the y-location of
    the start point.}

\item{x2}{A numeric vector or unit object specifying the x-location of
    the end point.}

\item{y2}{A numeric vector or unit object specifying the y-location of
    the end point.}

\item{default.units}{A string indicating the default units to use
    if \code{x1}, \code{y1}, \code{x2} or \code{y2}
    are only given as numeric values.}

\item{curvature}{A numeric value giving the amount of curvature.
    Negative values produce left-hand curves, positive values
    produce right-hand curves, and zero produces a straight line.}

\item{angle}{A numeric value between 0 and 180,
    giving an amount to skew the control
    points of the curve.  Values less than 90 skew the curve towards
    the start point and values greater than 90 skew the curve
    towards the end point.}

\item{ncp}{The number of control points used to draw the curve.
    More control points creates a smoother curve.}

\item{shape}{A numeric vector of values between -1 and 1, which
    control the shape of the curve relative to its control points.
    See \code{grid.xspline} for more details.}

\item{square}{A logical value that controls whether control
    points for the curve are created city-block fashion or
    obliquely.  When \code{ncp} is 1 and \code{angle} is 90,
    this is typically \code{TRUE}, otherwise this should probably
    be set to \code{FALSE} (see Examples below).}

\item{squareShape}{A \code{shape} value to control the behaviour
    of the curve relative to any additional control point that
    is inserted if \code{square} is \code{TRUE}.}

\item{inflect}{A logical value specifying whether the curve
    should be cut in half and inverted (see Examples below).}

\item{open}{A logical value indicating whether to close the curve
    (connect the start and end points).}

\item{name}{ A character identifier. }

\item{gp}{An object of class \code{"gpar"}, typically the output
    from a call to the function \code{\link[grid]{gpar}}.  This is basically
    a list of graphical parameter settings.}

\item{vp}{A Grid viewport object (or NULL).}

\item{...}{
  Arguments passed on to \code{\link[=grob_arrow]{grob_arrow}}
  \describe{
    \item{\code{arrow_head,arrow_fins,arrow_mid}}{A \verb{<matrix[n, 2]>}, such as those
returned by \link[=arrow_ornaments]{arrow ornament} functions, giving arrow
shapes. The matrix can (should) have the \code{notch_angle} attribute that will
be used to fuse the shaft to the arrow ornaments. If \code{NULL}, no ornament
will be drawn.}
    \item{\code{length_head,length_fins,length_mid}}{A \code{\link[grid:unit]{<unit>}} object
controlling the size of the arrow ornaments.}
    \item{\code{resect,resect_fins,resect_head}}{A \code{\link[grid:unit]{<unit>}} object that
can be used to create an offset between the endings of the coordinates
and where the arrow will be displayed visually. \code{resect_fins} and
\code{resect_head} control this offset at the start and end of the arrow
respectively and both default to \code{resect}.}
    \item{\code{force_arrow}}{A \code{logical(1)} which, if \code{TRUE} an arrow will be drawn
even when the length of the arrow is shorter than the arrow heads and fins.
If \code{FALSE}, will drop such arrows.}
    \item{\code{justify}}{A \code{numeric(1)} between [0-1] to control where the
arrows should be drawn relative to the path's endpoints. A value of \code{0}
sets the arrow's tips at the path's end, whereas a value of \code{1} sets the
arrow's base at the path's end.}
    \item{\code{mid_place}}{Sets the location of middle (interior) arrows, when
applicable. Can be one of the following:
\describe{
\item{A \code{numeric} vector}{with values between [0-1] to set middle
arrows at relative positions along the arc-length of a path.}
\item{A \code{<}\code{\link[grid:unit]{unit}}\code{>}}{to fill a path with arrows with
the provided unit as distance between one arrow to the next.}
}}
    \item{\code{x}}{A numeric vector or unit object specifying x-values.}
    \item{\code{y}}{A numeric vector or unit object specifying y-values.}
    \item{\code{id}}{A numeric vector used to separate locations in \code{x} and
    \code{y} into multiple lines.  All locations with the same
    \code{id} belong to the same line.}
    \item{\code{id.lengths}}{A numeric vector used to separate locations in \code{x} and
    \code{y} into multiple lines.  Specifies consecutive blocks of
    locations which make up separate lines.}
  }}

\item{width_fins, width_head}{A \code{\link[grid:unit]{<unit>}} object controlling the
width of the arrow's shaft at the \verb{(x1, y1)} and \verb{(x2, y2)} location
respectively.}
}
\value{
A \verb{<curve_arrow>} \link[grid:grid.grob]{graphical object}.
}
\description{
Creates a graphical object that draws curved arrows.
}
\examples{
requireNamespace("grid")

# Creating the curved arrow
grob <- grob_arrow_curve(
  x1 = unit(0.25, "npc"), y1 = unit(0.25, "npc"),
  x2 = unit(0.75, "npc"), y2 = unit(0.75, "npc"),
  angle = 90, curvature = 0.5, ncp = 5,
  arrow_head = arrow_head_line()
)

# Drawing the arrow
grid::grid.newpage(); grid::grid.draw(grob)
}
