% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stabnew.r
\name{stab.mean}
\alias{stab.mean}
\title{Group means and ranks with resampling}
\usage{
stab.mean(Y, class, cls2 = NULL, resample, times = NULL, alpha = NULL)
}
\arguments{
\item{Y}{A matrix including One or more traits}

\item{class}{A vector of the first factor for calculating variance. For example, a vector of genotypes.}

\item{cls2}{A vector of the second factor used within-group bootstraping for variance. It can be default}

\item{resample}{Resampling technique option. resample="Boot" is for bootstrapping. resample="Perm" is for permutation.}

\item{times}{Number of resampling used. The default number is 1000.}

\item{alpha}{A nomimal probability used for statistical test. The default value is 0.05.}
}
\value{
A list of variances and confidence intervals for genotypes or environments
}
\description{
Group mean and rank calculation with two resampling techniques:permuation and bootstraping
}
\examples{
data(maize)
#names(maize)
Geno=as.vector(maize$Cultivar)
Env=paste(maize$Location,maize$Year,sep=":")
y=maize$Yld
res=stab.mean(y,class=Geno,cls2=Env,resample="Boot",times=100)
res
res=stab.mean(y,class=Geno,resample="Perm",times=100)
res
}
\references{
Finlay, K.W., G.N. Wilkinson 1963. The analysis of adaptation in a plant breeding programme. Australian Journal of Agricultural Research 14: 742-754.

Wu, J., K. Glover, W. Berzonsky, 2012. Statistical tests for stability analysis with resampling techniques. 25th Conference of Applied Statistics in Agriculture. p88-108. April 29- May 01, 2012. Manhattan, KS
}
\author{
Jixiang Wu <jixiang.wu@sdstate.edu>
}
