% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gammaFuncModel.R
\name{calculate_Cmax}
\alias{calculate_Cmax}
\title{Function that produces Cmax property for a single individual in a particular group, for a specific metabolite}
\usage{
calculate_Cmax(data, model, grp_var, ID, grp_name = "Diet", Tmax)
}
\arguments{
\item{data}{Data frame containing columns Group(factor); ID(subject ID: character); Time(positive: numeric); other individiual characteristics covariates (exlcluding other forms of 'Time')
Note: Data must be complete (No missing values).}

\item{model}{Fitted model for the metabolite in question}

\item{grp_var}{Value of the grouping variable}

\item{ID}{Subject ID}

\item{grp_name}{Name of the grouping variable. Default is 'Diet'}

\item{Tmax}{for this metabolite, in a particular group for a single individual}
}
\value{
Cmax for this metabolite, in a particular group for a single individual
}
\description{
Function that produces Cmax property for a single individual in a particular group, for a specific metabolite
}
\examples{
\donttest{
require(gammaFuncModel)
require(rootSolve)
require(dplyr)
require(nlme)
df <- data.frame(
  ID = rep(sprintf("\%02d", 1:10), each = 9 * 3),  
  Time = rep(rep(1:9, each = 3), 10),             
  Diet = as.factor(rep(1:3, times = 9 * 10)),     
  Age = rep(sample(20:70, 10, replace = TRUE), each = 9 * 3),
  BMI = round(rep(runif(10, 18.5, 35), each = 9 * 3), 1),     
  Concentration = round(runif(270, 5, 15), 2)
)
covariates <- c("ID", "Diet", "Age", "BMI")
model <- gammaFunction(
  df, 
  covariates, 
  time_grp_inter = FALSE, 
  return_ml_model = FALSE, 
  include_grp = TRUE
  )[[1]]
test_data = df \%>\% filter(Diet == 1 & ID == "02") \%>\% select(-c("Concentration", "ID", "Diet")) 
Tmax <- calculate_Tmax(data = test_data, model, grp_var = 1, ID = "02", grp_name = 'Diet', ref = 1)
Cmax <- calculate_Cmax(data = test_data, model, grp_var = 1, ID = "02", grp_name = "Diet", Tmax)
}
}
\references{
Wickham, H. (2022). dplyr: A Grammar of Data Manipulation. R package version 1.0.10. 
Available at: \url{https://CRAN.R-project.org/package=dplyr}

Pinheiro, J. C., & Bates, D. M. (2022). nlme: Linear and Nonlinear Mixed Effects Models. R package version 3.1-153.
Available at: \url{https://CRAN.R-project.org/package=nlme}
}
