% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/difference_join.R
\name{difference_join}
\alias{difference_join}
\alias{difference_inner_join}
\alias{difference_left_join}
\alias{difference_right_join}
\alias{difference_full_join}
\alias{difference_semi_join}
\alias{difference_anti_join}
\title{Join two tables based on absolute difference between their columns}
\usage{
difference_join(
  x,
  y,
  by = NULL,
  max_dist = 1,
  mode = "inner",
  distance_col = NULL
)

difference_inner_join(x, y, by = NULL, max_dist = 1, distance_col = NULL)

difference_left_join(x, y, by = NULL, max_dist = 1, distance_col = NULL)

difference_right_join(x, y, by = NULL, max_dist = 1, distance_col = NULL)

difference_full_join(x, y, by = NULL, max_dist = 1, distance_col = NULL)

difference_semi_join(x, y, by = NULL, max_dist = 1, distance_col = NULL)

difference_anti_join(x, y, by = NULL, max_dist = 1, distance_col = NULL)
}
\arguments{
\item{x}{A tbl}

\item{y}{A tbl}

\item{by}{Columns by which to join the two tables}

\item{max_dist}{Maximum distance to use for joining}

\item{mode}{One of "inner", "left", "right", "full" "semi", or "anti"}

\item{distance_col}{If given, will add a column with this
name containing the difference between the two}
}
\description{
Join two tables based on absolute difference between their columns
}
\examples{

library(dplyr)

head(iris)
sepal_lengths <- data_frame(Sepal.Length = c(5, 6, 7), Type = 1:3)

iris \%>\%
  difference_inner_join(sepal_lengths, max_dist = .5)

}
