% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_dti_tracks.R
\name{vis.dti.trk}
\alias{vis.dti.trk}
\title{Visualize DTI tracks from Diffusion Toolkit/TrackVis TRK format file.}
\usage{
vis.dti.trk(
  trk,
  filter_tracks = list(min_length = 15, min_segment_count = 6),
  color_by_orientation = FALSE
)
}
\arguments{
\item{trk}{character string, the path to a TRK file that should be loaded. Alternatively, a loaded \code{trk} instance as returned by \code{freesurferformats::read.dti.trk}.}

\item{filter_tracks}{optional, named list of filters. Can contain fields \code{min_length} and \code{min_segment_count}. Set the whole thing to \code{NULL} or an entry to 0 for no filtering.}

\item{color_by_orientation}{logical, whether to color the tracks by orientation. Slower, but may make the resulting visualization easier to interprete.}
}
\value{
The (loaded or received) \code{trk} instance. Note that this function is typically called for the side effect of visualization.
}
\description{
Visualize DTI tracks from Diffusion Toolkit/TrackVis TRK format file.
}
\note{
The current simple implementation is very slow if the number of tracks becomes large (several thousand tracks).
}
\examples{
\dontrun{
# Create the following file with Diffusion Toolkit from your DTI data:
trk = freesurferformats::read.dti.trk("~/data/tim_only/tim/DICOM/dti.trk");
vis.dti.trk(trk);
}

}
