% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{label.border.fast}
\alias{label.border.fast}
\title{Compute border vertices of a label using Rvcg.}
\usage{
label.border.fast(surface_mesh, label)
}
\arguments{
\item{surface_mesh}{an fs.surface instance, see \code{\link{subject.surface}}.}

\item{label}{an fs.label instance (see \code{\link{subject.label}}) or an integer vector, the vertex indices of the label.}
}
\value{
named list with entry 'vertices' containing an integer vector with the indices of the border vertices.
}
\description{
Compute border vertices of a label using Rvcg.
}
\note{
This is faster than using the \code{\link{label.border}} function, but it does not fully match its functionality (some parameter are not implemented for this function), and it requires the \code{Rvcg} package, which is an optional dependency.
}
\examples{
\dontrun{
sjd = fsaverage.path(T);
sj = "fsaverage";
mesh = subject.surface(sjd, sj, hemi="lh");
lab = subject.label(sjd, sj, "cortex", hemi = "lh");
col = rep("white", nrow(mesh$vertices));
bd = fsbrain:::label.border.fast <- function(surface_mesh, label);
col[bd$vertices] = "red";
vis.fs.surface(mesh, col=col);
}

}
\seealso{
\code{\link{label.border}}, which is slower but provides more options and does not require Rvcg.
}
\keyword{internal}
