structure(list(method = "GET", url = "https://zenodo.org/api/records?q=conceptrecid:7390791&all_versions=true", 
    status_code = 200L, headers = structure(list(server = "nginx", 
        date = "Thu, 24 Apr 2025 08:09:10 GMT", `content-type` = "application/json", 
        `transfer-encoding` = "chunked", vary = "Accept-Encoding", 
        `access-control-allow-origin` = "*", `access-control-expose-headers` = "Content-Type, ETag, Link, X-RateLimit-Limit, X-RateLimit-Remaining, X-RateLimit-Reset", 
        `x-ratelimit-limit` = "133", `x-ratelimit-remaining` = "131", 
        `x-ratelimit-reset` = "1745482211", `retry-after` = "60", 
        `permissions-policy` = "interest-cohort=()", `x-frame-options` = "sameorigin", 
        `x-xss-protection` = "1; mode=block", `x-content-type-options` = "nosniff", 
        `content-security-policy` = "default-src 'self' fonts.googleapis.com *.gstatic.com data: 'unsafe-inline' 'unsafe-eval' blob: zenodo-broker.web.cern.ch zenodo-broker-qa.web.cern.ch maxcdn.bootstrapcdn.com cdnjs.cloudflare.com ajax.googleapis.com webanalytics.web.cern.ch", 
        `strict-transport-security` = "max-age=31556926; includeSubDomains", 
        `referrer-policy` = "strict-origin-when-cross-origin", 
        `strict-transport-security` = "max-age=15768000", `x-request-id` = "839baa1f842547c85b9a782b368bedbe", 
        `content-encoding` = "gzip"), redact = character(0), class = "httr2_headers"), 
    body = charToRaw("{\"hits\": {\"hits\": [{\"created\": \"2023-12-12T10:09:28.227904+00:00\", \"modified\": \"2023-12-14T08:46:31.844922+00:00\", \"id\": 10361711, \"conceptrecid\": \"7390791\", \"doi\": \"10.5281/zenodo.10361711\", \"conceptdoi\": \"10.5281/zenodo.7390791\", \"doi_url\": \"https://doi.org/10.5281/zenodo.10361711\", \"metadata\": {\"title\": \"The FORCIS database: A global census of planktonic Foraminifera from ocean waters\", \"doi\": \"10.5281/zenodo.10361711\", \"publication_date\": \"2023-12-12\", \"description\": \"<p>The FORCIS (Foraminifera Response to Climatic Stress) database&nbsp;is a synthesis grouping datasets on living planktonic foraminifera. We assembled foraminiferal diversity and distribution data in the global oceans from 1910 until 2018, curating published and unpublished datasets. This database includes data collected using plankton tows, continuous plankton recorder, sediment traps and plankton pump from the global ocean.</p>\\n\\n<p>The FORCIS database version 01&nbsp;is composed of 5 files (&ldquo;.csv&rdquo; format). All data coming from different sampling devices were put into separate &ldquo;.csv&rdquo; files. Only the data of the CPR from the Southern Hemisphere have been separated from the Northern Hemisphere CPR data as the data structure is not the same (species counts resolved vs. binned total counts, respectively).&nbsp;&nbsp;</p>\\n\\n<p>Apart from the file of&nbsp; CPR data from the Northern Hemisphere that contains only metadata and binned total counts, all the remaining four files contain 4 blocks:</p>\\n\\n<ul>\\n\\t<li>\\n\\t<p>Block 1: metadata (from column 1 to 71)</p>\\n\\t</li>\\n\\t<li>\\n\\t<p>Block 2: original counts (from column 72 to 274)</p>\\n\\t</li>\\n\\t<li>\\n\\t<p>Block 3: generated counts based on the validated taxonomy (from column 275 to 331). We added &ldquo;_VT&rdquo; to each species name to distinguish it from other taxonomy levels. E.g. &ldquo;g_bulloides&rdquo; became &ldquo;g_bulloides_VT&rdquo;. The number of species counted per subsample is also reported in the column &ldquo;number_of_species_counted_VT&rdquo;</p>\\n\\t</li>\\n\\t<li>\\n\\t<p>Block 4: generated counts based on the lumped taxonomy (from column 332 to 379). In this case, we added &ldquo;_LT&rdquo; to each species name. E.g. &ldquo;n_dutertrei&rdquo; became &ldquo;n_dutertrei_VT&rdquo;. We also calculated the number of species counted per subsample and reported it in the column &ldquo;number_of_species_counted_LT&rdquo;</p>\\n\\t</li>\\n</ul>\\n\\n<p>Foraminifera abundance data counts are reported in different categories in the blocks 1,2 and 3 and described in the table below:</p>\\n\\n<table>\\n\\t<tbody>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p><strong>count_type</strong></p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p><strong>unit</strong></p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Absolute</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>ind/m3</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Relative</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>%</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Raw</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>number of individuals</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Fluxes</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>ind/m2/day</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Bin_Absolute</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>ind/m3</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Bin_Relative</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>%</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Bin_Raw</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>number of individuals</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Bin_Fluxes</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>ind/m2/day</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t</tbody>\\n</table>\\n\\n<p>&nbsp;</p>\\n\\n<p>For more details about the FORCIS database column description, please check the data descriptor paper <strong>Chaabane et al. (2023) (https://doi.org/10.1038/s41597-023-02264-2).</strong></p>\\n\\n<p>The database is kept open for any new entries and the updated version will be released in csv format. The labels of updated versions of the released &ldquo;.csv&rdquo; files will contain the date of their publication and versioning number.</p>\", \"access_right\": \"open\", \"creators\": [{\"name\": \"Chaabane, Sonia\", \"affiliation\": \"CEREGE, France and Max Planck, Germany\", \"orcid\": \"0000-0002-4653-8610\"}, {\"name\": \"de Garidel, Thibault\", \"affiliation\": \"CEREGE, France\", \"orcid\": \"0000-0001-8983-9571\"}, {\"name\": \"Giraud, Xavier\", \"affiliation\": \"CEREGE, France\", \"orcid\": \"0000-0002-6252-7647\"}, {\"name\": \"Schiebel, Ralf\", \"affiliation\": \"Max Planck, Germany\", \"orcid\": \"0000-0001-5067-8176\"}, {\"name\": \"Beaugrand, Gregory\", \"affiliation\": \"LOG, France\"}, {\"name\": \"Brummer, Geert-Jan\", \"affiliation\": \"NIOZ, Netherlands\"}, {\"name\": \"Casajus, Nicolas\", \"affiliation\": \"FRB CESAB\"}, {\"name\": \"Greco, Mattia\", \"affiliation\": \"Polish Academy of Sciences, Poland\"}, {\"name\": \"Grigoratou, Maria\", \"affiliation\": \"Mercator Ocean International, France\"}, {\"name\": \"Howa, H\\u00e9l\\u00e8ne\", \"affiliation\": \"LPG-BIAF, France\"}, {\"name\": \"Jonkers, Lukas\", \"affiliation\": \"MARUM, Germany\"}, {\"name\": \"Kucera, Michal\", \"affiliation\": \"MARUM, Germany\"}, {\"name\": \"Kuroyanagi, Azumi\", \"affiliation\": \"Tohoku Univ., Japan\"}, {\"name\": \"Meilland, Julie\", \"affiliation\": \"MARUM, Germany\"}, {\"name\": \"Monteiro, Fanny\", \"affiliation\": \"BRIDGE, UK\"}, {\"name\": \"Mortyn, Graham\", \"affiliation\": \"ICTA UAB, Spain\"}, {\"name\": \"Almogi-Labin Ahuva\", \"affiliation\": null}, {\"name\": \"Asahi Hirofumi\", \"affiliation\": null}, {\"name\": \"Avnaim-Katav Simona\", \"affiliation\": null}, {\"name\": \"Bassinot Franck\", \"affiliation\": null}, {\"name\": \"Davis Catherine V.\", \"affiliation\": null}, {\"name\": \"Field David B.\", \"affiliation\": null}, {\"name\": \"Hernandez-Almeida Ivan\", \"affiliation\": null}, {\"name\": \"Herut Barak\", \"affiliation\": null}, {\"name\": \"Hosie Graham\", \"affiliation\": null}, {\"name\": \"Howard Will\", \"affiliation\": null}, {\"name\": \"Jentzen Anna\", \"affiliation\": null}, {\"name\": \"Johns David G.\", \"affiliation\": null}, {\"name\": \"Keigwin Lloyd\", \"affiliation\": null}, {\"name\": \"Kitchener John\", \"affiliation\": null}, {\"name\": \"Kohfeld Karen E.\", \"affiliation\": null}, {\"name\": \"Lessa Douglas V.O.\", \"affiliation\": null}, {\"name\": \"Manno Clara\", \"affiliation\": null}, {\"name\": \"Marchant Margarita\", \"affiliation\": null}, {\"name\": \"Ofstad Siri\", \"affiliation\": null}, {\"name\": \"Ortiz Joseph D.\", \"affiliation\": null}, {\"name\": \"Post Alexandra\", \"affiliation\": null}, {\"name\": \"Rigual-Hernandez Andres\", \"affiliation\": null}, {\"name\": \"Rillo Marina C.\", \"affiliation\": null}, {\"name\": \"Robinson Karen\", \"affiliation\": null}, {\"name\": \"Sagawa Takuya\", \"affiliation\": null}, {\"name\": \"Sierro Francisco\", \"affiliation\": null}, {\"name\": \"Takahashi Kunio T.\", \"affiliation\": null}, {\"name\": \"Torfstein Adi\", \"affiliation\": null}, {\"name\": \"Venancio Igor\", \"affiliation\": null}, {\"name\": \"Yamasaki Makoto\", \"affiliation\": null}, {\"name\": \"Ziveri Patrizia\", \"affiliation\": null}], \"keywords\": [\"Planktonic Foraminifera\", \"FORCIS database\", \"Biodiversity\"], \"dates\": [{\"type\": \"updated\"}], \"version\": \"06\", \"resource_type\": {\"title\": \"Dataset\", \"type\": \"dataset\"}, \"license\": {\"id\": \"cc-by-4.0\"}, \"relations\": {\"version\": [{\"index\": 5, \"is_last\": false, \"parent\": {\"pid_type\": \"recid\", \"pid_value\": \"7390791\"}}]}}, \"title\": \"The FORCIS database: A global census of planktonic Foraminifera from ocean waters\", \"links\": {\"self\": \"https://zenodo.org/api/records/10361711\", \"self_html\": \"https://zenodo.org/records/10361711\", \"preview_html\": \"https://zenodo.org/records/10361711?preview=1\", \"doi\": \"https://doi.org/10.5281/zenodo.10361711\", \"self_doi\": \"https://doi.org/10.5281/zenodo.10361711\", \"self_doi_html\": \"https://zenodo.org/doi/10.5281/zenodo.10361711\", \"parent\": \"https://zenodo.org/api/records/7390791\", \"parent_html\": \"https://zenodo.org/records/7390791\", \"parent_doi\": \"https://doi.org/10.5281/zenodo.7390791\", \"parent_doi_html\": \"https://zenodo.org/doi/10.5281/zenodo.7390791\", \"self_iiif_manifest\": \"https://zenodo.org/api/iiif/record:10361711/manifest\", \"self_iiif_sequence\": \"https://zenodo.org/api/iiif/record:10361711/sequence/default\", \"files\": \"https://zenodo.org/api/records/10361711/files\", \"media_files\": \"https://zenodo.org/api/records/10361711/media-files\", \"archive\": \"https://zenodo.org/api/records/10361711/files-archive\", \"archive_media\": \"https://zenodo.org/api/records/10361711/media-files-archive\", \"latest\": \"https://zenodo.org/api/records/10361711/versions/latest\", \"latest_html\": \"https://zenodo.org/records/10361711/latest\", \"versions\": \"https://zenodo.org/api/records/10361711/versions\", \"draft\": \"https://zenodo.org/api/records/10361711/draft\", \"reserve_doi\": \"https://zenodo.org/api/records/10361711/draft/pids/doi\", \"access_links\": \"https://zenodo.org/api/records/10361711/access/links\", \"access_grants\": \"https://zenodo.org/api/records/10361711/access/grants\", \"access_users\": \"https://zenodo.org/api/records/10361711/access/users\", \"access_request\": \"https://zenodo.org/api/records/10361711/access/request\", \"access\": \"https://zenodo.org/api/records/10361711/access\", \"communities\": \"https://zenodo.org/api/records/10361711/communities\", \"communities-suggestions\": \"https://zenodo.org/api/records/10361711/communities-suggestions\", \"requests\": \"https://zenodo.org/api/records/10361711/requests\"}, \"updated\": \"2023-12-14T08:46:31.844922+00:00\", \"recid\": \"10361711\", \"revision\": 6, \"files\": [{\"id\": \"d9bcb4c0-9d1e-4891-8692-b9da80bbe013\", \"key\": \"FORCIS_cpr_south_v05_14092023.csv\", \"size\": 75018303, \"checksum\": \"md5:a8f8416c8aef723209e4a6df03722fdf\", \"links\": {\"self\": \"https://zenodo.org/api/records/10361711/files/FORCIS_cpr_south_v05_14092023.csv/content\"}}, {\"id\": \"7366edfa-448c-46a1-ba91-5add69dca536\", \"key\": \"FORCIS_cpr_north_v05_14092023.csv\", \"size\": 67556549, \"checksum\": \"md5:a32bbb863fe795cfcb953ca8928fd9c8\", \"links\": {\"self\": \"https://zenodo.org/api/records/10361711/files/FORCIS_cpr_north_v05_14092023.csv/content\"}}, {\"id\": \"3bfdef28-2617-4cf0-ae53-031279893f72\", \"key\": \"FORCIS data template.xlsx\", \"size\": 357853, \"checksum\": \"md5:ef3c3d67f1824c026fe6fb36aef0b56b\", \"links\": {\"self\": \"https://zenodo.org/api/records/10361711/files/FORCIS data template.xlsx/content\"}}, {\"id\": \"e5c2d602-1bd0-46cd-80f2-bc1cc624d9c0\", \"key\": \"FORCIS_net_v05_14092023.csv\", \"size\": 27226894, \"checksum\": \"md5:220855dc4346fdb02396f0769586a04f\", \"links\": {\"self\": \"https://zenodo.org/api/records/10361711/files/FORCIS_net_v05_14092023.csv/content\"}}, {\"id\": \"5cdb4444-c2a3-4cb1-9ee6-a83bb1f85c7d\", \"key\": \"FORCIS taxonomy levels.xlsx\", \"size\": 24998, \"checksum\": \"md5:e12a45e2d34def4c1642353597a04bf8\", \"links\": {\"self\": \"https://zenodo.org/api/records/10361711/files/FORCIS taxonomy levels.xlsx/content\"}}, {\"id\": \"4b5ac50b-3574-4749-89a0-b72d6152ed06\", \"key\": \"FORCIS_pump_v05_14092023.csv\", \"size\": 649676, \"checksum\": \"md5:9bee5c30a35dacb623dc7ac4ff564117\", \"links\": {\"self\": \"https://zenodo.org/api/records/10361711/files/FORCIS_pump_v05_14092023.csv/content\"}}, {\"id\": \"e1be5249-87a7-49a1-b73b-19ccc07a20c3\", \"key\": \"FORCIS_trap_v05_14092023.csv\", \"size\": 13270806, \"checksum\": \"md5:76bac6d2c85f699da059bfd48334baf4\", \"links\": {\"self\": \"https://zenodo.org/api/records/10361711/files/FORCIS_trap_v05_14092023.csv/content\"}}, {\"id\": \"2b15c9cd-1a02-41e4-b66f-f76fbab9fbd1\", \"key\": \"iho_oceans_boundaries.rds\", \"size\": 9198965, \"checksum\": \"md5:ff8d2f16650ef1f0cdcb4c3986112648\", \"links\": {\"self\": \"https://zenodo.org/api/records/10361711/files/iho_oceans_boundaries.rds/content\"}}], \"swh\": {}, \"owners\": [{\"id\": \"452144\"}], \"status\": \"published\", \"stats\": {\"downloads\": 5487, \"unique_downloads\": 4158, \"views\": 3330, \"unique_views\": 2971, \"version_downloads\": 128, \"version_unique_downloads\": 119, \"version_unique_views\": 149, \"version_views\": 163}, \"state\": \"done\", \"submitted\": true}, {\"created\": \"2023-09-14T14:03:27.367852+00:00\", \"modified\": \"2023-09-14T14:26:54.043243+00:00\", \"id\": 8345072, \"conceptrecid\": \"7390791\", \"doi\": \"10.5281/zenodo.8345072\", \"conceptdoi\": \"10.5281/zenodo.7390791\", \"doi_url\": \"https://doi.org/10.5281/zenodo.8345072\", \"metadata\": {\"title\": \"The FORCIS database: A global census of planktonic Foraminifera from ocean waters\", \"doi\": \"10.5281/zenodo.8345072\", \"publication_date\": \"2023-09-14\", \"description\": \"<p>The FORCIS (Foraminifera Response to Climatic Stress) database&nbsp;is a synthesis grouping datasets on living planktonic foraminifera. We assembled foraminiferal diversity and distribution data in the global oceans from 1910 until 2018, curating published and unpublished datasets. This database includes data collected using plankton tows, continuous plankton recorder, sediment traps and plankton pump from the global ocean.</p>\\n\\n<p>The FORCIS database version 01&nbsp;is composed of 5 files (&ldquo;.csv&rdquo; format). All data coming from different sampling devices were put into separate &ldquo;.csv&rdquo; files. Only the data of the CPR from the Southern Hemisphere have been separated from the Northern Hemisphere CPR data as the data structure is not the same (species counts resolved vs. binned total counts, respectively).&nbsp;&nbsp;</p>\\n\\n<p>Apart from the file of&nbsp; CPR data from the Northern Hemisphere that contains only metadata and binned total counts, all the remaining four files contain 4 blocks:</p>\\n\\n<ul>\\n\\t<li>\\n\\t<p>Block 1: metadata (from column 1 to 71)</p>\\n\\t</li>\\n\\t<li>\\n\\t<p>Block 2: original counts (from column 72 to 274)</p>\\n\\t</li>\\n\\t<li>\\n\\t<p>Block 3: generated counts based on the validated taxonomy (from column 275 to 331). We added &ldquo;_VT&rdquo; to each species name to distinguish it from other taxonomy levels. E.g. &ldquo;g_bulloides&rdquo; became &ldquo;g_bulloides_VT&rdquo;. The number of species counted per subsample is also reported in the column &ldquo;number_of_species_counted_VT&rdquo;</p>\\n\\t</li>\\n\\t<li>\\n\\t<p>Block 4: generated counts based on the lumped taxonomy (from column 332 to 379). In this case, we added &ldquo;_LT&rdquo; to each species name. E.g. &ldquo;n_dutertrei&rdquo; became &ldquo;n_dutertrei_VT&rdquo;. We also calculated the number of species counted per subsample and reported it in the column &ldquo;number_of_species_counted_LT&rdquo;</p>\\n\\t</li>\\n</ul>\\n\\n<p>Foraminifera abundance data counts are reported in different categories in the blocks 1,2 and 3 and described in the table below:</p>\\n\\n<table align=\\\"center\\\">\\n\\t<tbody>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p><strong>count_type</strong></p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p><strong>unit</strong></p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Absolute</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>ind/m3</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Relative</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>%</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Raw</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>number of individuals</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Fluxes</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>ind/m2/day</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Bin_Absolute</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>ind/m3</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Bin_Relative</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>%</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Bin_Raw</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>number of individuals</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Bin_Fluxes</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>ind/m2/day</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t</tbody>\\n</table>\\n\\n<p>&nbsp;</p>\\n\\n<p>For more details about the FORCIS database column description, please check the data descriptor paper <strong>Chaabane et al. (2023) (https://doi.org/10.1038/s41597-023-02264-2).</strong></p>\\n\\n<p>The database is kept open for any new entries and the updated version will be released in csv format. The labels of updated versions of the released &ldquo;.csv&rdquo; files will contain the date of their publication and versioning number.</p>\", \"access_right\": \"open\", \"creators\": [{\"name\": \"Chaabane, Sonia\", \"affiliation\": \"CEREGE, France and Max Planck, Germany\", \"orcid\": \"0000-0002-4653-8610\"}, {\"name\": \"de Garidel, Thibault\", \"affiliation\": \"CEREGE, France\", \"orcid\": \"0000-0001-8983-9571\"}, {\"name\": \"Giraud, Xavier\", \"affiliation\": \"CEREGE, France\", \"orcid\": \"0000-0002-6252-7647\"}, {\"name\": \"Schiebel, Ralf\", \"affiliation\": \"Max Planck, Germany\", \"orcid\": \"0000-0001-5067-8176\"}, {\"name\": \"Beaugrand, Gregory\", \"affiliation\": \"LOG, France\"}, {\"name\": \"Brummer, Geert-Jan\", \"affiliation\": \"NIOZ, Netherlands\"}, {\"name\": \"Casajus, Nicolas\", \"affiliation\": \"FRB CESAB\"}, {\"name\": \"Greco, Mattia\", \"affiliation\": \"Polish Academy of Sciences, Poland\"}, {\"name\": \"Grigoratou, Maria\", \"affiliation\": \"Mercator Ocean International, France\"}, {\"name\": \"Howa, H\\u00e9l\\u00e8ne\", \"affiliation\": \"LPG-BIAF, France\"}, {\"name\": \"Jonkers, Lukas\", \"affiliation\": \"MARUM, Germany\"}, {\"name\": \"Kucera, Michal\", \"affiliation\": \"MARUM, Germany\"}, {\"name\": \"Kuroyanagi, Azumi\", \"affiliation\": \"Tohoku Univ., Japan\"}, {\"name\": \"Meilland, Julie\", \"affiliation\": \"MARUM, Germany\"}, {\"name\": \"Monteiro, Fanny\", \"affiliation\": \"BRIDGE, UK\"}, {\"name\": \"Mortyn, Graham\", \"affiliation\": \"ICTA UAB, Spain\"}, {\"name\": \"Almogi-Labin Ahuva\", \"affiliation\": null}, {\"name\": \"Asahi Hirofumi\", \"affiliation\": null}, {\"name\": \"Avnaim-Katav Simona\", \"affiliation\": null}, {\"name\": \"Bassinot Franck\", \"affiliation\": null}, {\"name\": \"Davis Catherine V.\", \"affiliation\": null}, {\"name\": \"Field David B.\", \"affiliation\": null}, {\"name\": \"Hernandez-Almeida Ivan\", \"affiliation\": null}, {\"name\": \"Herut Barak\", \"affiliation\": null}, {\"name\": \"Hosie Graham\", \"affiliation\": null}, {\"name\": \"Howard Will\", \"affiliation\": null}, {\"name\": \"Jentzen Anna\", \"affiliation\": null}, {\"name\": \"Johns David G.\", \"affiliation\": null}, {\"name\": \"Keigwin Lloyd\", \"affiliation\": null}, {\"name\": \"Kitchener John\", \"affiliation\": null}, {\"name\": \"Kohfeld Karen E.\", \"affiliation\": null}, {\"name\": \"Lessa Douglas V.O.\", \"affiliation\": null}, {\"name\": \"Manno Clara\", \"affiliation\": null}, {\"name\": \"Marchant Margarita\", \"affiliation\": null}, {\"name\": \"Ofstad Siri\", \"affiliation\": null}, {\"name\": \"Ortiz Joseph D.\", \"affiliation\": null}, {\"name\": \"Post Alexandra\", \"affiliation\": null}, {\"name\": \"Rigual-Hernandez Andres\", \"affiliation\": null}, {\"name\": \"Rillo Marina C.\", \"affiliation\": null}, {\"name\": \"Robinson Karen\", \"affiliation\": null}, {\"name\": \"Sagawa Takuya\", \"affiliation\": null}, {\"name\": \"Sierro Francisco\", \"affiliation\": null}, {\"name\": \"Takahashi Kunio T.\", \"affiliation\": null}, {\"name\": \"Torfstein Adi\", \"affiliation\": null}, {\"name\": \"Venancio Igor\", \"affiliation\": null}, {\"name\": \"Yamasaki Makoto\", \"affiliation\": null}, {\"name\": \"Ziveri Patrizia\", \"affiliation\": null}], \"keywords\": [\"Planktonic Foraminifera\", \"FORCIS database\", \"Biodiversity\"], \"version\": \"05\", \"resource_type\": {\"title\": \"Dataset\", \"type\": \"dataset\"}, \"license\": {\"id\": \"cc-by-4.0\"}, \"relations\": {\"version\": [{\"index\": 4, \"is_last\": false, \"parent\": {\"pid_type\": \"recid\", \"pid_value\": \"7390791\"}}]}}, \"title\": \"The FORCIS database: A global census of planktonic Foraminifera from ocean waters\", \"links\": {\"self\": \"https://zenodo.org/api/records/8345072\", \"self_html\": \"https://zenodo.org/records/8345072\", \"preview_html\": \"https://zenodo.org/records/8345072?preview=1\", \"doi\": \"https://doi.org/10.5281/zenodo.8345072\", \"self_doi\": \"https://doi.org/10.5281/zenodo.8345072\", \"self_doi_html\": \"https://zenodo.org/doi/10.5281/zenodo.8345072\", \"parent\": \"https://zenodo.org/api/records/7390791\", \"parent_html\": \"https://zenodo.org/records/7390791\", \"parent_doi\": \"https://doi.org/10.5281/zenodo.7390791\", \"parent_doi_html\": \"https://zenodo.org/doi/10.5281/zenodo.7390791\", \"self_iiif_manifest\": \"https://zenodo.org/api/iiif/record:8345072/manifest\", \"self_iiif_sequence\": \"https://zenodo.org/api/iiif/record:8345072/sequence/default\", \"files\": \"https://zenodo.org/api/records/8345072/files\", \"media_files\": \"https://zenodo.org/api/records/8345072/media-files\", \"archive\": \"https://zenodo.org/api/records/8345072/files-archive\", \"archive_media\": \"https://zenodo.org/api/records/8345072/media-files-archive\", \"latest\": \"https://zenodo.org/api/records/8345072/versions/latest\", \"latest_html\": \"https://zenodo.org/records/8345072/latest\", \"versions\": \"https://zenodo.org/api/records/8345072/versions\", \"draft\": \"https://zenodo.org/api/records/8345072/draft\", \"reserve_doi\": \"https://zenodo.org/api/records/8345072/draft/pids/doi\", \"access_links\": \"https://zenodo.org/api/records/8345072/access/links\", \"access_grants\": \"https://zenodo.org/api/records/8345072/access/grants\", \"access_users\": \"https://zenodo.org/api/records/8345072/access/users\", \"access_request\": \"https://zenodo.org/api/records/8345072/access/request\", \"access\": \"https://zenodo.org/api/records/8345072/access\", \"communities\": \"https://zenodo.org/api/records/8345072/communities\", \"communities-suggestions\": \"https://zenodo.org/api/records/8345072/communities-suggestions\", \"requests\": \"https://zenodo.org/api/records/8345072/requests\"}, \"updated\": \"2023-09-14T14:26:54.043243+00:00\", \"recid\": \"8345072\", \"revision\": 2, \"files\": [{\"id\": \"d9bcb4c0-9d1e-4891-8692-b9da80bbe013\", \"key\": \"FORCIS_cpr_south_v05_14092023.csv\", \"size\": 75018303, \"checksum\": \"md5:a8f8416c8aef723209e4a6df03722fdf\", \"links\": {\"self\": \"https://zenodo.org/api/records/8345072/files/FORCIS_cpr_south_v05_14092023.csv/content\"}}, {\"id\": \"7366edfa-448c-46a1-ba91-5add69dca536\", \"key\": \"FORCIS_cpr_north_v05_14092023.csv\", \"size\": 67556549, \"checksum\": \"md5:a32bbb863fe795cfcb953ca8928fd9c8\", \"links\": {\"self\": \"https://zenodo.org/api/records/8345072/files/FORCIS_cpr_north_v05_14092023.csv/content\"}}, {\"id\": \"3bfdef28-2617-4cf0-ae53-031279893f72\", \"key\": \"FORCIS data template.xlsx\", \"size\": 357853, \"checksum\": \"md5:ef3c3d67f1824c026fe6fb36aef0b56b\", \"links\": {\"self\": \"https://zenodo.org/api/records/8345072/files/FORCIS data template.xlsx/content\"}}, {\"id\": \"e5c2d602-1bd0-46cd-80f2-bc1cc624d9c0\", \"key\": \"FORCIS_net_v05_14092023.csv\", \"size\": 27226894, \"checksum\": \"md5:220855dc4346fdb02396f0769586a04f\", \"links\": {\"self\": \"https://zenodo.org/api/records/8345072/files/FORCIS_net_v05_14092023.csv/content\"}}, {\"id\": \"4b5ac50b-3574-4749-89a0-b72d6152ed06\", \"key\": \"FORCIS_pump_v05_14092023.csv\", \"size\": 649676, \"checksum\": \"md5:9bee5c30a35dacb623dc7ac4ff564117\", \"links\": {\"self\": \"https://zenodo.org/api/records/8345072/files/FORCIS_pump_v05_14092023.csv/content\"}}, {\"id\": \"e1be5249-87a7-49a1-b73b-19ccc07a20c3\", \"key\": \"FORCIS_trap_v05_14092023.csv\", \"size\": 13270806, \"checksum\": \"md5:76bac6d2c85f699da059bfd48334baf4\", \"links\": {\"self\": \"https://zenodo.org/api/records/8345072/files/FORCIS_trap_v05_14092023.csv/content\"}}, {\"id\": \"5cdb4444-c2a3-4cb1-9ee6-a83bb1f85c7d\", \"key\": \"FORCIS taxonomy levels.xlsx\", \"size\": 24998, \"checksum\": \"md5:e12a45e2d34def4c1642353597a04bf8\", \"links\": {\"self\": \"https://zenodo.org/api/records/8345072/files/FORCIS taxonomy levels.xlsx/content\"}}], \"swh\": {}, \"owners\": [{\"id\": \"452144\"}], \"status\": \"published\", \"stats\": {\"downloads\": 5487, \"unique_downloads\": 4158, \"views\": 3330, \"unique_views\": 2971, \"version_downloads\": 482, \"version_unique_downloads\": 420, \"version_unique_views\": 168, \"version_views\": 178}, \"state\": \"done\", \"submitted\": true}, {\"created\": \"2024-07-08T12:26:21.654864+00:00\", \"modified\": \"2024-07-08T12:26:22.863287+00:00\", \"id\": 12685264, \"conceptrecid\": \"7390791\", \"doi\": \"10.5281/zenodo.12685264\", \"conceptdoi\": \"10.5281/zenodo.7390791\", \"doi_url\": \"https://doi.org/10.5281/zenodo.12685264\", \"metadata\": {\"title\": \"The FORCIS database: A global census of planktonic Foraminifera from ocean waters\", \"doi\": \"10.5281/zenodo.12685264\", \"publication_date\": \"2024-07-08\", \"description\": \"<p>The FORCIS (Foraminifera Response to Climatic Stress) database&nbsp;is a synthesis grouping datasets on living planktonic foraminifera. We assembled foraminiferal diversity and distribution data in the global oceans from 1910 until 2018, curating published and unpublished datasets. This database includes data collected using plankton tows, continuous plankton recorder, sediment traps and plankton pump from the global ocean.</p>\\n\\n<p>The FORCIS database version 01&nbsp;is composed of 5 files (&ldquo;.csv&rdquo; format). All data coming from different sampling devices were put into separate &ldquo;.csv&rdquo; files. Only the data of the CPR from the Southern Hemisphere have been separated from the Northern Hemisphere CPR data as the data structure is not the same (species counts resolved vs. binned total counts, respectively).&nbsp;&nbsp;</p>\\n\\n<p>Apart from the file of&nbsp; CPR data from the Northern Hemisphere that contains only metadata and binned total counts, all the remaining four files contain 4 blocks:</p>\\n\\n<ul>\\n\\t<li>\\n\\t<p>Block 1: metadata (from column 1 to 71)</p>\\n\\t</li>\\n\\t<li>\\n\\t<p>Block 2: original counts (from column 72 to 274)</p>\\n\\t</li>\\n\\t<li>\\n\\t<p>Block 3: generated counts based on the validated taxonomy (from column 275 to 331). We added &ldquo;_VT&rdquo; to each species name to distinguish it from other taxonomy levels. E.g. &ldquo;g_bulloides&rdquo; became &ldquo;g_bulloides_VT&rdquo;. The number of species counted per subsample is also reported in the column &ldquo;number_of_species_counted_VT&rdquo;</p>\\n\\t</li>\\n\\t<li>\\n\\t<p>Block 4: generated counts based on the lumped taxonomy (from column 332 to 379). In this case, we added &ldquo;_LT&rdquo; to each species name. E.g. &ldquo;n_dutertrei&rdquo; became &ldquo;n_dutertrei_VT&rdquo;. We also calculated the number of species counted per subsample and reported it in the column &ldquo;number_of_species_counted_LT&rdquo;</p>\\n\\t</li>\\n</ul>\\n\\n<p>Foraminifera abundance data counts are reported in different categories in the blocks 1,2 and 3 and described in the table below:</p>\\n\\n<table>\\n\\t<tbody>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p><strong>count_type</strong></p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p><strong>unit</strong></p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Absolute</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>ind/m3</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Relative</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>%</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Raw</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>number of individuals</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Fluxes</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>ind/m2/day</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Bin_Absolute</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>ind/m3</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Bin_Relative</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>%</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Bin_Raw</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>number of individuals</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Bin_Fluxes</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>ind/m2/day</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t</tbody>\\n</table>\\n\\n<p>&nbsp;</p>\\n\\n<p>For more details about the FORCIS database column description, please check the data descriptor paper <strong>Chaabane et al. (2023) (https://doi.org/10.1038/s41597-023-02264-2).</strong></p>\\n\\n<p>The database is kept open for any new entries and the updated version will be released in csv format. The labels of updated versions of the released &ldquo;.csv&rdquo; files will contain the date of their publication and versioning number.</p>\", \"access_right\": \"open\", \"creators\": [{\"name\": \"Chaabane, Sonia\", \"affiliation\": \"CEREGE, France and Max Planck, Germany\", \"orcid\": \"0000-0002-4653-8610\"}, {\"name\": \"de Garidel, Thibault\", \"affiliation\": \"CEREGE, France\", \"orcid\": \"0000-0001-8983-9571\"}, {\"name\": \"Giraud, Xavier\", \"affiliation\": \"CEREGE, France\", \"orcid\": \"0000-0002-6252-7647\"}, {\"name\": \"Schiebel, Ralf\", \"affiliation\": \"Max Planck, Germany\", \"orcid\": \"0000-0001-5067-8176\"}, {\"name\": \"Beaugrand, Gregory\", \"affiliation\": \"LOG, France\"}, {\"name\": \"Brummer, Geert-Jan\", \"affiliation\": \"NIOZ, Netherlands\"}, {\"name\": \"Casajus, Nicolas\", \"affiliation\": \"FRB CESAB\"}, {\"name\": \"Greco, Mattia\", \"affiliation\": \"Polish Academy of Sciences, Poland\"}, {\"name\": \"Grigoratou, Maria\", \"affiliation\": \"Mercator Ocean International, France\"}, {\"name\": \"Howa, H\\u00e9l\\u00e8ne\", \"affiliation\": \"LPG-BIAF, France\"}, {\"name\": \"Jonkers, Lukas\", \"affiliation\": \"MARUM, Germany\"}, {\"name\": \"Kucera, Michal\", \"affiliation\": \"MARUM, Germany\"}, {\"name\": \"Kuroyanagi, Azumi\", \"affiliation\": \"Tohoku Univ., Japan\"}, {\"name\": \"Meilland, Julie\", \"affiliation\": \"MARUM, Germany\"}, {\"name\": \"Monteiro, Fanny\", \"affiliation\": \"BRIDGE, UK\"}, {\"name\": \"Mortyn, Graham\", \"affiliation\": \"ICTA UAB, Spain\"}, {\"name\": \"Almogi-Labin Ahuva\", \"affiliation\": null}, {\"name\": \"Asahi Hirofumi\", \"affiliation\": null}, {\"name\": \"Avnaim-Katav Simona\", \"affiliation\": null}, {\"name\": \"Bassinot Franck\", \"affiliation\": null}, {\"name\": \"Davis Catherine V.\", \"affiliation\": null}, {\"name\": \"Field David B.\", \"affiliation\": null}, {\"name\": \"Hernandez-Almeida Ivan\", \"affiliation\": null}, {\"name\": \"Herut Barak\", \"affiliation\": null}, {\"name\": \"Hosie Graham\", \"affiliation\": null}, {\"name\": \"Howard Will\", \"affiliation\": null}, {\"name\": \"Jentzen Anna\", \"affiliation\": null}, {\"name\": \"Johns David G.\", \"affiliation\": null}, {\"name\": \"Keigwin Lloyd\", \"affiliation\": null}, {\"name\": \"Kitchener John\", \"affiliation\": null}, {\"name\": \"Kohfeld Karen E.\", \"affiliation\": null}, {\"name\": \"Lessa Douglas V.O.\", \"affiliation\": null}, {\"name\": \"Manno Clara\", \"affiliation\": null}, {\"name\": \"Marchant Margarita\", \"affiliation\": null}, {\"name\": \"Ofstad Siri\", \"affiliation\": null}, {\"name\": \"Ortiz Joseph D.\", \"affiliation\": null}, {\"name\": \"Post Alexandra\", \"affiliation\": null}, {\"name\": \"Rigual-Hernandez Andres\", \"affiliation\": null}, {\"name\": \"Rillo Marina C.\", \"affiliation\": null}, {\"name\": \"Robinson Karen\", \"affiliation\": null}, {\"name\": \"Sagawa Takuya\", \"affiliation\": null}, {\"name\": \"Sierro Francisco\", \"affiliation\": null}, {\"name\": \"Takahashi Kunio T.\", \"affiliation\": null}, {\"name\": \"Torfstein Adi\", \"affiliation\": null}, {\"name\": \"Venancio Igor\", \"affiliation\": null}, {\"name\": \"Yamasaki Makoto\", \"affiliation\": null}, {\"name\": \"Ziveri Patrizia\", \"affiliation\": null}], \"keywords\": [\"Planktonic Foraminifera\", \"FORCIS database\", \"Biodiversity\"], \"dates\": [{\"type\": \"updated\"}], \"version\": \"09\", \"resource_type\": {\"title\": \"Dataset\", \"type\": \"dataset\"}, \"license\": {\"id\": \"cc-by-4.0\"}, \"relations\": {\"version\": [{\"index\": 8, \"is_last\": false, \"parent\": {\"pid_type\": \"recid\", \"pid_value\": \"7390791\"}}]}}, \"title\": \"The FORCIS database: A global census of planktonic Foraminifera from ocean waters\", \"links\": {\"self\": \"https://zenodo.org/api/records/12685264\", \"self_html\": \"https://zenodo.org/records/12685264\", \"preview_html\": \"https://zenodo.org/records/12685264?preview=1\", \"doi\": \"https://doi.org/10.5281/zenodo.12685264\", \"self_doi\": \"https://doi.org/10.5281/zenodo.12685264\", \"self_doi_html\": \"https://zenodo.org/doi/10.5281/zenodo.12685264\", \"parent\": \"https://zenodo.org/api/records/7390791\", \"parent_html\": \"https://zenodo.org/records/7390791\", \"parent_doi\": \"https://doi.org/10.5281/zenodo.7390791\", \"parent_doi_html\": \"https://zenodo.org/doi/10.5281/zenodo.7390791\", \"self_iiif_manifest\": \"https://zenodo.org/api/iiif/record:12685264/manifest\", \"self_iiif_sequence\": \"https://zenodo.org/api/iiif/record:12685264/sequence/default\", \"files\": \"https://zenodo.org/api/records/12685264/files\", \"media_files\": \"https://zenodo.org/api/records/12685264/media-files\", \"archive\": \"https://zenodo.org/api/records/12685264/files-archive\", \"archive_media\": \"https://zenodo.org/api/records/12685264/media-files-archive\", \"latest\": \"https://zenodo.org/api/records/12685264/versions/latest\", \"latest_html\": \"https://zenodo.org/records/12685264/latest\", \"versions\": \"https://zenodo.org/api/records/12685264/versions\", \"draft\": \"https://zenodo.org/api/records/12685264/draft\", \"reserve_doi\": \"https://zenodo.org/api/records/12685264/draft/pids/doi\", \"access_links\": \"https://zenodo.org/api/records/12685264/access/links\", \"access_grants\": \"https://zenodo.org/api/records/12685264/access/grants\", \"access_users\": \"https://zenodo.org/api/records/12685264/access/users\", \"access_request\": \"https://zenodo.org/api/records/12685264/access/request\", \"access\": \"https://zenodo.org/api/records/12685264/access\", \"communities\": \"https://zenodo.org/api/records/12685264/communities\", \"communities-suggestions\": \"https://zenodo.org/api/records/12685264/communities-suggestions\", \"requests\": \"https://zenodo.org/api/records/12685264/requests\"}, \"updated\": \"2024-07-08T12:26:22.863287+00:00\", \"recid\": \"12685264\", \"revision\": 4, \"files\": [{\"id\": \"1bd56905-0976-44e9-8983-94253a59192e\", \"key\": \"FORCIS_taxonomy_levels.xlsx\", \"size\": 24998, \"checksum\": \"md5:e12a45e2d34def4c1642353597a04bf8\", \"links\": {\"self\": \"https://zenodo.org/api/records/12685264/files/FORCIS_taxonomy_levels.xlsx/content\"}}, {\"id\": \"ad686886-8c8d-40c8-beb8-22d883a7ea9e\", \"key\": \"FORCIS_net_08072024.csv\", \"size\": 27189945, \"checksum\": \"md5:18be71f701075318d7b0a0782d1effc7\", \"links\": {\"self\": \"https://zenodo.org/api/records/12685264/files/FORCIS_net_08072024.csv/content\"}}, {\"id\": \"4c6be10f-b60d-42e7-829b-02b07f0c27f1\", \"key\": \"iho_oceans_boundaries.rds\", \"size\": 9198965, \"checksum\": \"md5:ff8d2f16650ef1f0cdcb4c3986112648\", \"links\": {\"self\": \"https://zenodo.org/api/records/12685264/files/iho_oceans_boundaries.rds/content\"}}, {\"id\": \"2725b38c-1485-4180-b603-ec37aeaa91eb\", \"key\": \"FORCIS_data_template.xlsx\", \"size\": 357853, \"checksum\": \"md5:ef3c3d67f1824c026fe6fb36aef0b56b\", \"links\": {\"self\": \"https://zenodo.org/api/records/12685264/files/FORCIS_data_template.xlsx/content\"}}, {\"id\": \"29a21b13-1a73-4acf-a4e0-8611b6293f82\", \"key\": \"FORCIS_trap_08072024.csv\", \"size\": 13270806, \"checksum\": \"md5:76bac6d2c85f699da059bfd48334baf4\", \"links\": {\"self\": \"https://zenodo.org/api/records/12685264/files/FORCIS_trap_08072024.csv/content\"}}, {\"id\": \"85a4d82c-084c-4bca-ac79-5ce3e80c8bdf\", \"key\": \"FORCIS_pump_08072024.csv\", \"size\": 649676, \"checksum\": \"md5:9bee5c30a35dacb623dc7ac4ff564117\", \"links\": {\"self\": \"https://zenodo.org/api/records/12685264/files/FORCIS_pump_08072024.csv/content\"}}, {\"id\": \"09b1e533-99c6-4459-9060-1dc2812960a4\", \"key\": \"FORCIS_cpr_north_08072024.csv\", \"size\": 67556549, \"checksum\": \"md5:a32bbb863fe795cfcb953ca8928fd9c8\", \"links\": {\"self\": \"https://zenodo.org/api/records/12685264/files/FORCIS_cpr_north_08072024.csv/content\"}}, {\"id\": \"bab54635-a690-4b35-a044-00285093a68d\", \"key\": \"FORCIS_cpr_south_08072024.csv\", \"size\": 64036404, \"checksum\": \"md5:29156b1c61e8f71fc03c08d02418fd79\", \"links\": {\"self\": \"https://zenodo.org/api/records/12685264/files/FORCIS_cpr_south_08072024.csv/content\"}}], \"swh\": {}, \"owners\": [{\"id\": \"452144\"}], \"status\": \"published\", \"stats\": {\"downloads\": 5487, \"unique_downloads\": 4158, \"views\": 3330, \"unique_views\": 2971, \"version_downloads\": 99, \"version_unique_downloads\": 99, \"version_unique_views\": 27, \"version_views\": 35}, \"state\": \"done\", \"submitted\": true}, {\"created\": \"2023-12-14T10:44:39.756498+00:00\", \"modified\": \"2023-12-14T10:44:40.032499+00:00\", \"id\": 10376575, \"conceptrecid\": \"7390791\", \"doi\": \"10.5281/zenodo.10376575\", \"conceptdoi\": \"10.5281/zenodo.7390791\", \"doi_url\": \"https://doi.org/10.5281/zenodo.10376575\", \"metadata\": {\"title\": \"The FORCIS database: A global census of planktonic Foraminifera from ocean waters\", \"doi\": \"10.5281/zenodo.10376575\", \"publication_date\": \"2023-12-14\", \"description\": \"<p>The FORCIS (Foraminifera Response to Climatic Stress) database&nbsp;is a synthesis grouping datasets on living planktonic foraminifera. We assembled foraminiferal diversity and distribution data in the global oceans from 1910 until 2018, curating published and unpublished datasets. This database includes data collected using plankton tows, continuous plankton recorder, sediment traps and plankton pump from the global ocean.</p>\\n\\n<p>The FORCIS database version 01&nbsp;is composed of 5 files (&ldquo;.csv&rdquo; format). All data coming from different sampling devices were put into separate &ldquo;.csv&rdquo; files. Only the data of the CPR from the Southern Hemisphere have been separated from the Northern Hemisphere CPR data as the data structure is not the same (species counts resolved vs. binned total counts, respectively).&nbsp;&nbsp;</p>\\n\\n<p>Apart from the file of&nbsp; CPR data from the Northern Hemisphere that contains only metadata and binned total counts, all the remaining four files contain 4 blocks:</p>\\n\\n<ul>\\n\\t<li>\\n\\t<p>Block 1: metadata (from column 1 to 71)</p>\\n\\t</li>\\n\\t<li>\\n\\t<p>Block 2: original counts (from column 72 to 274)</p>\\n\\t</li>\\n\\t<li>\\n\\t<p>Block 3: generated counts based on the validated taxonomy (from column 275 to 331). We added &ldquo;_VT&rdquo; to each species name to distinguish it from other taxonomy levels. E.g. &ldquo;g_bulloides&rdquo; became &ldquo;g_bulloides_VT&rdquo;. The number of species counted per subsample is also reported in the column &ldquo;number_of_species_counted_VT&rdquo;</p>\\n\\t</li>\\n\\t<li>\\n\\t<p>Block 4: generated counts based on the lumped taxonomy (from column 332 to 379). In this case, we added &ldquo;_LT&rdquo; to each species name. E.g. &ldquo;n_dutertrei&rdquo; became &ldquo;n_dutertrei_VT&rdquo;. We also calculated the number of species counted per subsample and reported it in the column &ldquo;number_of_species_counted_LT&rdquo;</p>\\n\\t</li>\\n</ul>\\n\\n<p>Foraminifera abundance data counts are reported in different categories in the blocks 1,2 and 3 and described in the table below:</p>\\n\\n<table>\\n\\t<tbody>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p><strong>count_type</strong></p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p><strong>unit</strong></p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Absolute</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>ind/m3</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Relative</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>%</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Raw</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>number of individuals</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Fluxes</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>ind/m2/day</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Bin_Absolute</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>ind/m3</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Bin_Relative</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>%</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Bin_Raw</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>number of individuals</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Bin_Fluxes</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>ind/m2/day</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t</tbody>\\n</table>\\n\\n<p>&nbsp;</p>\\n\\n<p>For more details about the FORCIS database column description, please check the data descriptor paper <strong>Chaabane et al. (2023) (https://doi.org/10.1038/s41597-023-02264-2).</strong></p>\\n\\n<p>The database is kept open for any new entries and the updated version will be released in csv format. The labels of updated versions of the released &ldquo;.csv&rdquo; files will contain the date of their publication and versioning number.</p>\", \"access_right\": \"open\", \"creators\": [{\"name\": \"Chaabane, Sonia\", \"affiliation\": \"CEREGE, France and Max Planck, Germany\", \"orcid\": \"0000-0002-4653-8610\"}, {\"name\": \"de Garidel, Thibault\", \"affiliation\": \"CEREGE, France\", \"orcid\": \"0000-0001-8983-9571\"}, {\"name\": \"Giraud, Xavier\", \"affiliation\": \"CEREGE, France\", \"orcid\": \"0000-0002-6252-7647\"}, {\"name\": \"Schiebel, Ralf\", \"affiliation\": \"Max Planck, Germany\", \"orcid\": \"0000-0001-5067-8176\"}, {\"name\": \"Beaugrand, Gregory\", \"affiliation\": \"LOG, France\"}, {\"name\": \"Brummer, Geert-Jan\", \"affiliation\": \"NIOZ, Netherlands\"}, {\"name\": \"Casajus, Nicolas\", \"affiliation\": \"FRB CESAB\"}, {\"name\": \"Greco, Mattia\", \"affiliation\": \"Polish Academy of Sciences, Poland\"}, {\"name\": \"Grigoratou, Maria\", \"affiliation\": \"Mercator Ocean International, France\"}, {\"name\": \"Howa, H\\u00e9l\\u00e8ne\", \"affiliation\": \"LPG-BIAF, France\"}, {\"name\": \"Jonkers, Lukas\", \"affiliation\": \"MARUM, Germany\"}, {\"name\": \"Kucera, Michal\", \"affiliation\": \"MARUM, Germany\"}, {\"name\": \"Kuroyanagi, Azumi\", \"affiliation\": \"Tohoku Univ., Japan\"}, {\"name\": \"Meilland, Julie\", \"affiliation\": \"MARUM, Germany\"}, {\"name\": \"Monteiro, Fanny\", \"affiliation\": \"BRIDGE, UK\"}, {\"name\": \"Mortyn, Graham\", \"affiliation\": \"ICTA UAB, Spain\"}, {\"name\": \"Almogi-Labin Ahuva\", \"affiliation\": null}, {\"name\": \"Asahi Hirofumi\", \"affiliation\": null}, {\"name\": \"Avnaim-Katav Simona\", \"affiliation\": null}, {\"name\": \"Bassinot Franck\", \"affiliation\": null}, {\"name\": \"Davis Catherine V.\", \"affiliation\": null}, {\"name\": \"Field David B.\", \"affiliation\": null}, {\"name\": \"Hernandez-Almeida Ivan\", \"affiliation\": null}, {\"name\": \"Herut Barak\", \"affiliation\": null}, {\"name\": \"Hosie Graham\", \"affiliation\": null}, {\"name\": \"Howard Will\", \"affiliation\": null}, {\"name\": \"Jentzen Anna\", \"affiliation\": null}, {\"name\": \"Johns David G.\", \"affiliation\": null}, {\"name\": \"Keigwin Lloyd\", \"affiliation\": null}, {\"name\": \"Kitchener John\", \"affiliation\": null}, {\"name\": \"Kohfeld Karen E.\", \"affiliation\": null}, {\"name\": \"Lessa Douglas V.O.\", \"affiliation\": null}, {\"name\": \"Manno Clara\", \"affiliation\": null}, {\"name\": \"Marchant Margarita\", \"affiliation\": null}, {\"name\": \"Ofstad Siri\", \"affiliation\": null}, {\"name\": \"Ortiz Joseph D.\", \"affiliation\": null}, {\"name\": \"Post Alexandra\", \"affiliation\": null}, {\"name\": \"Rigual-Hernandez Andres\", \"affiliation\": null}, {\"name\": \"Rillo Marina C.\", \"affiliation\": null}, {\"name\": \"Robinson Karen\", \"affiliation\": null}, {\"name\": \"Sagawa Takuya\", \"affiliation\": null}, {\"name\": \"Sierro Francisco\", \"affiliation\": null}, {\"name\": \"Takahashi Kunio T.\", \"affiliation\": null}, {\"name\": \"Torfstein Adi\", \"affiliation\": null}, {\"name\": \"Venancio Igor\", \"affiliation\": null}, {\"name\": \"Yamasaki Makoto\", \"affiliation\": null}, {\"name\": \"Ziveri Patrizia\", \"affiliation\": null}], \"keywords\": [\"Planktonic Foraminifera\", \"FORCIS database\", \"Biodiversity\"], \"dates\": [{\"type\": \"updated\"}], \"version\": \"07\", \"resource_type\": {\"title\": \"Dataset\", \"type\": \"dataset\"}, \"license\": {\"id\": \"cc-by-4.0\"}, \"relations\": {\"version\": [{\"index\": 6, \"is_last\": false, \"parent\": {\"pid_type\": \"recid\", \"pid_value\": \"7390791\"}}]}}, \"title\": \"The FORCIS database: A global census of planktonic Foraminifera from ocean waters\", \"links\": {\"self\": \"https://zenodo.org/api/records/10376575\", \"self_html\": \"https://zenodo.org/records/10376575\", \"preview_html\": \"https://zenodo.org/records/10376575?preview=1\", \"doi\": \"https://doi.org/10.5281/zenodo.10376575\", \"self_doi\": \"https://doi.org/10.5281/zenodo.10376575\", \"self_doi_html\": \"https://zenodo.org/doi/10.5281/zenodo.10376575\", \"parent\": \"https://zenodo.org/api/records/7390791\", \"parent_html\": \"https://zenodo.org/records/7390791\", \"parent_doi\": \"https://doi.org/10.5281/zenodo.7390791\", \"parent_doi_html\": \"https://zenodo.org/doi/10.5281/zenodo.7390791\", \"self_iiif_manifest\": \"https://zenodo.org/api/iiif/record:10376575/manifest\", \"self_iiif_sequence\": \"https://zenodo.org/api/iiif/record:10376575/sequence/default\", \"files\": \"https://zenodo.org/api/records/10376575/files\", \"media_files\": \"https://zenodo.org/api/records/10376575/media-files\", \"archive\": \"https://zenodo.org/api/records/10376575/files-archive\", \"archive_media\": \"https://zenodo.org/api/records/10376575/media-files-archive\", \"latest\": \"https://zenodo.org/api/records/10376575/versions/latest\", \"latest_html\": \"https://zenodo.org/records/10376575/latest\", \"versions\": \"https://zenodo.org/api/records/10376575/versions\", \"draft\": \"https://zenodo.org/api/records/10376575/draft\", \"reserve_doi\": \"https://zenodo.org/api/records/10376575/draft/pids/doi\", \"access_links\": \"https://zenodo.org/api/records/10376575/access/links\", \"access_grants\": \"https://zenodo.org/api/records/10376575/access/grants\", \"access_users\": \"https://zenodo.org/api/records/10376575/access/users\", \"access_request\": \"https://zenodo.org/api/records/10376575/access/request\", \"access\": \"https://zenodo.org/api/records/10376575/access\", \"communities\": \"https://zenodo.org/api/records/10376575/communities\", \"communities-suggestions\": \"https://zenodo.org/api/records/10376575/communities-suggestions\", \"requests\": \"https://zenodo.org/api/records/10376575/requests\"}, \"updated\": \"2023-12-14T10:44:40.032499+00:00\", \"recid\": \"10376575\", \"revision\": 4, \"files\": [{\"id\": \"d9bcb4c0-9d1e-4891-8692-b9da80bbe013\", \"key\": \"FORCIS_cpr_south_v05_14092023.csv\", \"size\": 75018303, \"checksum\": \"md5:a8f8416c8aef723209e4a6df03722fdf\", \"links\": {\"self\": \"https://zenodo.org/api/records/10376575/files/FORCIS_cpr_south_v05_14092023.csv/content\"}}, {\"id\": \"7366edfa-448c-46a1-ba91-5add69dca536\", \"key\": \"FORCIS_cpr_north_v05_14092023.csv\", \"size\": 67556549, \"checksum\": \"md5:a32bbb863fe795cfcb953ca8928fd9c8\", \"links\": {\"self\": \"https://zenodo.org/api/records/10376575/files/FORCIS_cpr_north_v05_14092023.csv/content\"}}, {\"id\": \"8230819b-632d-48d3-9acd-39079ad6fd6b\", \"key\": \"FORCIS_taxonomy_levels.xlsx\", \"size\": 24998, \"checksum\": \"md5:e12a45e2d34def4c1642353597a04bf8\", \"links\": {\"self\": \"https://zenodo.org/api/records/10376575/files/FORCIS_taxonomy_levels.xlsx/content\"}}, {\"id\": \"e5c2d602-1bd0-46cd-80f2-bc1cc624d9c0\", \"key\": \"FORCIS_net_v05_14092023.csv\", \"size\": 27226894, \"checksum\": \"md5:220855dc4346fdb02396f0769586a04f\", \"links\": {\"self\": \"https://zenodo.org/api/records/10376575/files/FORCIS_net_v05_14092023.csv/content\"}}, {\"id\": \"4b5ac50b-3574-4749-89a0-b72d6152ed06\", \"key\": \"FORCIS_pump_v05_14092023.csv\", \"size\": 649676, \"checksum\": \"md5:9bee5c30a35dacb623dc7ac4ff564117\", \"links\": {\"self\": \"https://zenodo.org/api/records/10376575/files/FORCIS_pump_v05_14092023.csv/content\"}}, {\"id\": \"e1be5249-87a7-49a1-b73b-19ccc07a20c3\", \"key\": \"FORCIS_trap_v05_14092023.csv\", \"size\": 13270806, \"checksum\": \"md5:76bac6d2c85f699da059bfd48334baf4\", \"links\": {\"self\": \"https://zenodo.org/api/records/10376575/files/FORCIS_trap_v05_14092023.csv/content\"}}, {\"id\": \"2b15c9cd-1a02-41e4-b66f-f76fbab9fbd1\", \"key\": \"iho_oceans_boundaries.rds\", \"size\": 9198965, \"checksum\": \"md5:ff8d2f16650ef1f0cdcb4c3986112648\", \"links\": {\"self\": \"https://zenodo.org/api/records/10376575/files/iho_oceans_boundaries.rds/content\"}}, {\"id\": \"7b996c49-726f-4218-9450-6e44d90f527b\", \"key\": \"FORCIS_data_template.xlsx\", \"size\": 357853, \"checksum\": \"md5:ef3c3d67f1824c026fe6fb36aef0b56b\", \"links\": {\"self\": \"https://zenodo.org/api/records/10376575/files/FORCIS_data_template.xlsx/content\"}}], \"swh\": {}, \"owners\": [{\"id\": \"452144\"}], \"status\": \"published\", \"stats\": {\"downloads\": 5487, \"unique_downloads\": 4158, \"views\": 3330, \"unique_views\": 2971, \"version_downloads\": 317, \"version_unique_downloads\": 270, \"version_unique_views\": 122, \"version_views\": 144}, \"state\": \"done\", \"submitted\": true}, {\"created\": \"2024-07-11T13:48:17.680793+00:00\", \"modified\": \"2024-07-11T13:48:18.066790+00:00\", \"id\": 12724286, \"conceptrecid\": \"7390791\", \"doi\": \"10.5281/zenodo.12724286\", \"conceptdoi\": \"10.5281/zenodo.7390791\", \"doi_url\": \"https://doi.org/10.5281/zenodo.12724286\", \"metadata\": {\"title\": \"The FORCIS database: A global census of planktonic Foraminifera from ocean waters\", \"doi\": \"10.5281/zenodo.12724286\", \"publication_date\": \"2024-07-11\", \"description\": \"<p>The FORCIS (Foraminifera Response to Climatic Stress) database&nbsp;is a synthesis grouping datasets on living planktonic foraminifera. We assembled foraminiferal diversity and distribution data in the global oceans from 1910 until 2018, curating published and unpublished datasets. This database includes data collected using plankton tows, continuous plankton recorder, sediment traps and plankton pump from the global ocean.</p>\\n\\n<p>The FORCIS database version 01&nbsp;is composed of 5 files (&ldquo;.csv&rdquo; format). All data coming from different sampling devices were put into separate &ldquo;.csv&rdquo; files. Only the data of the CPR from the Southern Hemisphere have been separated from the Northern Hemisphere CPR data as the data structure is not the same (species counts resolved vs. binned total counts, respectively).&nbsp;&nbsp;</p>\\n\\n<p>Apart from the file of&nbsp; CPR data from the Northern Hemisphere that contains only metadata and binned total counts, all the remaining four files contain 4 blocks:</p>\\n\\n<ul>\\n\\t<li>\\n\\t<p>Block 1: metadata (from column 1 to 71)</p>\\n\\t</li>\\n\\t<li>\\n\\t<p>Block 2: original counts (from column 72 to 274)</p>\\n\\t</li>\\n\\t<li>\\n\\t<p>Block 3: generated counts based on the validated taxonomy (from column 275 to 331). We added &ldquo;_VT&rdquo; to each species name to distinguish it from other taxonomy levels. E.g. &ldquo;g_bulloides&rdquo; became &ldquo;g_bulloides_VT&rdquo;. The number of species counted per subsample is also reported in the column &ldquo;number_of_species_counted_VT&rdquo;</p>\\n\\t</li>\\n\\t<li>\\n\\t<p>Block 4: generated counts based on the lumped taxonomy (from column 332 to 379). In this case, we added &ldquo;_LT&rdquo; to each species name. E.g. &ldquo;n_dutertrei&rdquo; became &ldquo;n_dutertrei_VT&rdquo;. We also calculated the number of species counted per subsample and reported it in the column &ldquo;number_of_species_counted_LT&rdquo;</p>\\n\\t</li>\\n</ul>\\n\\n<p>Foraminifera abundance data counts are reported in different categories in the blocks 1,2 and 3 and described in the table below:</p>\\n\\n<table>\\n\\t<tbody>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p><strong>count_type</strong></p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p><strong>unit</strong></p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Absolute</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>ind/m3</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Relative</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>%</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Raw</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>number of individuals</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Fluxes</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>ind/m2/day</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Bin_Absolute</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>ind/m3</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Bin_Relative</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>%</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Bin_Raw</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>number of individuals</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Bin_Fluxes</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>ind/m2/day</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t</tbody>\\n</table>\\n\\n<p>&nbsp;</p>\\n\\n<p>For more details about the FORCIS database column description, please check the data descriptor paper <strong>Chaabane et al. (2023) (https://doi.org/10.1038/s41597-023-02264-2).</strong></p>\\n\\n<p>The database is kept open for any new entries and the updated version will be released in csv format. The labels of updated versions of the released &ldquo;.csv&rdquo; files will contain the date of their publication and versioning number.</p>\", \"access_right\": \"open\", \"creators\": [{\"name\": \"Chaabane, Sonia\", \"affiliation\": \"CEREGE, France and Max Planck, Germany\", \"orcid\": \"0000-0002-4653-8610\"}, {\"name\": \"de Garidel, Thibault\", \"affiliation\": \"CEREGE, France\", \"orcid\": \"0000-0001-8983-9571\"}, {\"name\": \"Giraud, Xavier\", \"affiliation\": \"CEREGE, France\", \"orcid\": \"0000-0002-6252-7647\"}, {\"name\": \"Schiebel, Ralf\", \"affiliation\": \"Max Planck, Germany\", \"orcid\": \"0000-0001-5067-8176\"}, {\"name\": \"Beaugrand, Gregory\", \"affiliation\": \"LOG, France\"}, {\"name\": \"Brummer, Geert-Jan\", \"affiliation\": \"NIOZ, Netherlands\"}, {\"name\": \"Casajus, Nicolas\", \"affiliation\": \"FRB CESAB\"}, {\"name\": \"Greco, Mattia\", \"affiliation\": \"Polish Academy of Sciences, Poland\"}, {\"name\": \"Grigoratou, Maria\", \"affiliation\": \"Mercator Ocean International, France\"}, {\"name\": \"Howa, H\\u00e9l\\u00e8ne\", \"affiliation\": \"LPG-BIAF, France\"}, {\"name\": \"Jonkers, Lukas\", \"affiliation\": \"MARUM, Germany\"}, {\"name\": \"Kucera, Michal\", \"affiliation\": \"MARUM, Germany\"}, {\"name\": \"Kuroyanagi, Azumi\", \"affiliation\": \"Tohoku Univ., Japan\"}, {\"name\": \"Meilland, Julie\", \"affiliation\": \"MARUM, Germany\"}, {\"name\": \"Monteiro, Fanny\", \"affiliation\": \"BRIDGE, UK\"}, {\"name\": \"Mortyn, Graham\", \"affiliation\": \"ICTA UAB, Spain\"}, {\"name\": \"Almogi-Labin Ahuva\", \"affiliation\": null}, {\"name\": \"Asahi Hirofumi\", \"affiliation\": null}, {\"name\": \"Avnaim-Katav Simona\", \"affiliation\": null}, {\"name\": \"Bassinot Franck\", \"affiliation\": null}, {\"name\": \"Davis Catherine V.\", \"affiliation\": null}, {\"name\": \"Field David B.\", \"affiliation\": null}, {\"name\": \"Hernandez-Almeida Ivan\", \"affiliation\": null}, {\"name\": \"Herut Barak\", \"affiliation\": null}, {\"name\": \"Hosie Graham\", \"affiliation\": null}, {\"name\": \"Howard Will\", \"affiliation\": null}, {\"name\": \"Jentzen Anna\", \"affiliation\": null}, {\"name\": \"Johns David G.\", \"affiliation\": null}, {\"name\": \"Keigwin Lloyd\", \"affiliation\": null}, {\"name\": \"Kitchener John\", \"affiliation\": null}, {\"name\": \"Kohfeld Karen E.\", \"affiliation\": null}, {\"name\": \"Lessa Douglas V.O.\", \"affiliation\": null}, {\"name\": \"Manno Clara\", \"affiliation\": null}, {\"name\": \"Marchant Margarita\", \"affiliation\": null}, {\"name\": \"Ofstad Siri\", \"affiliation\": null}, {\"name\": \"Ortiz Joseph D.\", \"affiliation\": null}, {\"name\": \"Post Alexandra\", \"affiliation\": null}, {\"name\": \"Rigual-Hernandez Andres\", \"affiliation\": null}, {\"name\": \"Rillo Marina C.\", \"affiliation\": null}, {\"name\": \"Robinson Karen\", \"affiliation\": null}, {\"name\": \"Sagawa Takuya\", \"affiliation\": null}, {\"name\": \"Sierro Francisco\", \"affiliation\": null}, {\"name\": \"Takahashi Kunio T.\", \"affiliation\": null}, {\"name\": \"Torfstein Adi\", \"affiliation\": null}, {\"name\": \"Venancio Igor\", \"affiliation\": null}, {\"name\": \"Yamasaki Makoto\", \"affiliation\": null}, {\"name\": \"Ziveri Patrizia\", \"affiliation\": null}], \"keywords\": [\"Planktonic Foraminifera\", \"FORCIS database\", \"Biodiversity\"], \"dates\": [{\"type\": \"updated\"}], \"version\": \"10\", \"resource_type\": {\"title\": \"Dataset\", \"type\": \"dataset\"}, \"license\": {\"id\": \"cc-by-4.0\"}, \"relations\": {\"version\": [{\"index\": 9, \"is_last\": true, \"parent\": {\"pid_type\": \"recid\", \"pid_value\": \"7390791\"}}]}}, \"title\": \"The FORCIS database: A global census of planktonic Foraminifera from ocean waters\", \"links\": {\"self\": \"https://zenodo.org/api/records/12724286\", \"self_html\": \"https://zenodo.org/records/12724286\", \"preview_html\": \"https://zenodo.org/records/12724286?preview=1\", \"doi\": \"https://doi.org/10.5281/zenodo.12724286\", \"self_doi\": \"https://doi.org/10.5281/zenodo.12724286\", \"self_doi_html\": \"https://zenodo.org/doi/10.5281/zenodo.12724286\", \"parent\": \"https://zenodo.org/api/records/7390791\", \"parent_html\": \"https://zenodo.org/records/7390791\", \"parent_doi\": \"https://doi.org/10.5281/zenodo.7390791\", \"parent_doi_html\": \"https://zenodo.org/doi/10.5281/zenodo.7390791\", \"self_iiif_manifest\": \"https://zenodo.org/api/iiif/record:12724286/manifest\", \"self_iiif_sequence\": \"https://zenodo.org/api/iiif/record:12724286/sequence/default\", \"files\": \"https://zenodo.org/api/records/12724286/files\", \"media_files\": \"https://zenodo.org/api/records/12724286/media-files\", \"archive\": \"https://zenodo.org/api/records/12724286/files-archive\", \"archive_media\": \"https://zenodo.org/api/records/12724286/media-files-archive\", \"latest\": \"https://zenodo.org/api/records/12724286/versions/latest\", \"latest_html\": \"https://zenodo.org/records/12724286/latest\", \"versions\": \"https://zenodo.org/api/records/12724286/versions\", \"draft\": \"https://zenodo.org/api/records/12724286/draft\", \"reserve_doi\": \"https://zenodo.org/api/records/12724286/draft/pids/doi\", \"access_links\": \"https://zenodo.org/api/records/12724286/access/links\", \"access_grants\": \"https://zenodo.org/api/records/12724286/access/grants\", \"access_users\": \"https://zenodo.org/api/records/12724286/access/users\", \"access_request\": \"https://zenodo.org/api/records/12724286/access/request\", \"access\": \"https://zenodo.org/api/records/12724286/access\", \"communities\": \"https://zenodo.org/api/records/12724286/communities\", \"communities-suggestions\": \"https://zenodo.org/api/records/12724286/communities-suggestions\", \"requests\": \"https://zenodo.org/api/records/12724286/requests\"}, \"updated\": \"2024-07-11T13:48:18.066790+00:00\", \"recid\": \"12724286\", \"revision\": 4, \"files\": [{\"id\": \"1c00f40e-85d4-4e39-99eb-30411aace76e\", \"key\": \"iho_oceans_boundaries.rds\", \"size\": 9198965, \"checksum\": \"md5:ff8d2f16650ef1f0cdcb4c3986112648\", \"links\": {\"self\": \"https://zenodo.org/api/records/12724286/files/iho_oceans_boundaries.rds/content\"}}, {\"id\": \"e299ff1a-71f9-426e-9762-059e410b0c60\", \"key\": \"FORCIS_cpr_north_11072024.csv\", \"size\": 67556549, \"checksum\": \"md5:a32bbb863fe795cfcb953ca8928fd9c8\", \"links\": {\"self\": \"https://zenodo.org/api/records/12724286/files/FORCIS_cpr_north_11072024.csv/content\"}}, {\"id\": \"26bf5117-9215-42a6-b53f-f4c36d39fa39\", \"key\": \"FORCIS_data_template.xlsx\", \"size\": 357853, \"checksum\": \"md5:ef3c3d67f1824c026fe6fb36aef0b56b\", \"links\": {\"self\": \"https://zenodo.org/api/records/12724286/files/FORCIS_data_template.xlsx/content\"}}, {\"id\": \"07439fa9-ec45-44ca-8c1d-b57b1f45f371\", \"key\": \"FORCIS_taxonomy_levels.xlsx\", \"size\": 24998, \"checksum\": \"md5:e12a45e2d34def4c1642353597a04bf8\", \"links\": {\"self\": \"https://zenodo.org/api/records/12724286/files/FORCIS_taxonomy_levels.xlsx/content\"}}, {\"id\": \"70c5a9c8-4ff4-49bd-b1c7-f72a8e8e6c2d\", \"key\": \"FORCIS_net_11072024.csv\", \"size\": 27189945, \"checksum\": \"md5:18be71f701075318d7b0a0782d1effc7\", \"links\": {\"self\": \"https://zenodo.org/api/records/12724286/files/FORCIS_net_11072024.csv/content\"}}, {\"id\": \"3d3c0c0b-4635-4f51-a3c4-ca7090312277\", \"key\": \"FORCIS_cpr_south_11072024.csv\", \"size\": 64583224, \"checksum\": \"md5:c9e410a749e513c2023780990fc9169e\", \"links\": {\"self\": \"https://zenodo.org/api/records/12724286/files/FORCIS_cpr_south_11072024.csv/content\"}}, {\"id\": \"bfb3f092-e40c-499f-b14e-8d6f62295f89\", \"key\": \"FORCIS_pump_11072024.csv\", \"size\": 649676, \"checksum\": \"md5:9bee5c30a35dacb623dc7ac4ff564117\", \"links\": {\"self\": \"https://zenodo.org/api/records/12724286/files/FORCIS_pump_11072024.csv/content\"}}, {\"id\": \"08699afd-f95e-411b-b956-af10ef25a5a0\", \"key\": \"FORCIS_trap_11072024.csv\", \"size\": 13270806, \"checksum\": \"md5:76bac6d2c85f699da059bfd48334baf4\", \"links\": {\"self\": \"https://zenodo.org/api/records/12724286/files/FORCIS_trap_11072024.csv/content\"}}], \"swh\": {}, \"owners\": [{\"id\": \"452144\"}], \"status\": \"published\", \"stats\": {\"downloads\": 5487, \"unique_downloads\": 4158, \"views\": 3330, \"unique_views\": 2971, \"version_downloads\": 835, \"version_unique_downloads\": 746, \"version_unique_views\": 367, \"version_views\": 446}, \"state\": \"done\", \"submitted\": true}, {\"created\": \"2023-06-14T14:26:25.355493+00:00\", \"modified\": \"2023-09-14T14:03:27.869554+00:00\", \"id\": 7936568, \"conceptrecid\": \"7390791\", \"doi\": \"10.5281/zenodo.7936568\", \"conceptdoi\": \"10.5281/zenodo.7390791\", \"doi_url\": \"https://doi.org/10.5281/zenodo.7936568\", \"metadata\": {\"title\": \"The FORCIS database: A global census of planktonic Foraminifera from ocean waters\", \"doi\": \"10.5281/zenodo.7936568\", \"publication_date\": \"2023-06-14\", \"description\": \"<p>The FORCIS (Foraminifera Response to Climatic Stress) database&nbsp;is a synthesis grouping datasets on living planktonic foraminifera. We assembled foraminiferal diversity and distribution data in the global oceans from 1910 until 2018, curating published and unpublished datasets. This database includes data collected using plankton tows, continuous plankton recorder, sediment traps and plankton pump from the global ocean.</p>\\n\\n<p>The FORCIS database version 01&nbsp;is composed of 5 files (&ldquo;.csv&rdquo; format). All data coming from different sampling devices were put into separate &ldquo;.csv&rdquo; files. Only the data of the CPR from the Southern Hemisphere have been separated from the Northern Hemisphere CPR data as the data structure is not the same (species counts resolved vs. binned total counts, respectively).&nbsp;&nbsp;</p>\\n\\n<p>Apart from the file of&nbsp; CPR data from the Northern Hemisphere that contains only metadata and binned total counts, all the remaining four files contain 4 blocks:</p>\\n\\n<ul>\\n\\t<li>\\n\\t<p>Block 1: metadata (from column 1 to 71)</p>\\n\\t</li>\\n\\t<li>\\n\\t<p>Block 2: original counts (from column 72 to 274)</p>\\n\\t</li>\\n\\t<li>\\n\\t<p>Block 3: generated counts based on the validated taxonomy (from column 275 to 331). We added &ldquo;_VT&rdquo; to each species name to distinguish it from other taxonomy levels. E.g. &ldquo;g_bulloides&rdquo; became &ldquo;g_bulloides_VT&rdquo;. The number of species counted per subsample is also reported in the column &ldquo;number_of_species_counted_VT&rdquo;</p>\\n\\t</li>\\n\\t<li>\\n\\t<p>Block 4: generated counts based on the lumped taxonomy (from column 332 to 379). In this case, we added &ldquo;_LT&rdquo; to each species name. E.g. &ldquo;n_dutertrei&rdquo; became &ldquo;n_dutertrei_VT&rdquo;. We also calculated the number of species counted per subsample and reported it in the column &ldquo;number_of_species_counted_LT&rdquo;</p>\\n\\t</li>\\n</ul>\\n\\n<p>Foraminifera abundance data counts are reported in different categories in the blocks 1,2 and 3 and described in the table below:</p>\\n\\n<table align=\\\"center\\\">\\n\\t<tbody>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p><strong>count_type</strong></p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p><strong>unit</strong></p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Absolute</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>ind/m3</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Relative</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>%</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Raw</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>number of individuals</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Fluxes</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>ind/m2/day</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Bin_Absolute</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>ind/m3</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Bin_Relative</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>%</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Bin_Raw</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>number of individuals</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Bin_Fluxes</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>ind/m2/day</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t</tbody>\\n</table>\\n\\n<p>&nbsp;</p>\\n\\n<p>For more details about the FORCIS database column description, please check the data descriptor paper <strong>Chaabane et al. (2023) (https://doi.org/10.1038/s41597-023-02264-2).</strong></p>\\n\\n<p>The database is kept open for any new entries and the updated version will be released in csv format. The labels of updated versions of the released &ldquo;.csv&rdquo; files will contain the date of their publication and versioning number.</p>\", \"access_right\": \"open\", \"creators\": [{\"name\": \"Chaabane, Sonia\", \"affiliation\": \"CEREGE, France and Max Planck, Germany\", \"orcid\": \"0000-0002-4653-8610\"}, {\"name\": \"de Garidel, Thibault\", \"affiliation\": \"CEREGE, France\", \"orcid\": \"0000-0001-8983-9571\"}, {\"name\": \"Giraud, Xavier\", \"affiliation\": \"CEREGE, France\", \"orcid\": \"0000-0002-6252-7647\"}, {\"name\": \"Schiebel, Ralf\", \"affiliation\": \"Max Planck, Germany\", \"orcid\": \"0000-0001-5067-8176\"}, {\"name\": \"Beaugrand, Gregory\", \"affiliation\": \"LOG, France\"}, {\"name\": \"Brummer, Geert-Jan\", \"affiliation\": \"NIOZ, Netherlands\"}, {\"name\": \"Casajus, Nicolas\", \"affiliation\": \"FRB CESAB\"}, {\"name\": \"Greco, Mattia\", \"affiliation\": \"Polish Academy of Sciences, Poland\"}, {\"name\": \"Grigoratou, Maria\", \"affiliation\": \"Mercator Ocean International, France\"}, {\"name\": \"Howa, H\\u00e9l\\u00e8ne\", \"affiliation\": \"LPG-BIAF, France\"}, {\"name\": \"Jonkers, Lukas\", \"affiliation\": \"MARUM, Germany\"}, {\"name\": \"Kucera, Michal\", \"affiliation\": \"MARUM, Germany\"}, {\"name\": \"Kuroyanagi, Azumi\", \"affiliation\": \"Tohoku Univ., Japan\"}, {\"name\": \"Meilland, Julie\", \"affiliation\": \"MARUM, Germany\"}, {\"name\": \"Monteiro, Fanny\", \"affiliation\": \"BRIDGE, UK\"}, {\"name\": \"Mortyn, Graham\", \"affiliation\": \"ICTA UAB, Spain\"}, {\"name\": \"Almogi-Labin Ahuva\", \"affiliation\": null}, {\"name\": \"Asahi Hirofumi\", \"affiliation\": null}, {\"name\": \"Avnaim-Katav Simona\", \"affiliation\": null}, {\"name\": \"Bassinot Franck\", \"affiliation\": null}, {\"name\": \"Davis Catherine V.\", \"affiliation\": null}, {\"name\": \"Field David B.\", \"affiliation\": null}, {\"name\": \"Hernandez-Almeida Ivan\", \"affiliation\": null}, {\"name\": \"Herut Barak\", \"affiliation\": null}, {\"name\": \"Hosie Graham\", \"affiliation\": null}, {\"name\": \"Howard Will\", \"affiliation\": null}, {\"name\": \"Jentzen Anna\", \"affiliation\": null}, {\"name\": \"Johns David G.\", \"affiliation\": null}, {\"name\": \"Keigwin Lloyd\", \"affiliation\": null}, {\"name\": \"Kitchener John\", \"affiliation\": null}, {\"name\": \"Kohfeld Karen E.\", \"affiliation\": null}, {\"name\": \"Lessa Douglas V.O.\", \"affiliation\": null}, {\"name\": \"Manno Clara\", \"affiliation\": null}, {\"name\": \"Marchant Margarita\", \"affiliation\": null}, {\"name\": \"Ofstad Siri\", \"affiliation\": null}, {\"name\": \"Ortiz Joseph D.\", \"affiliation\": null}, {\"name\": \"Post Alexandra\", \"affiliation\": null}, {\"name\": \"Rigual-Hernandez Andres\", \"affiliation\": null}, {\"name\": \"Rillo Marina C.\", \"affiliation\": null}, {\"name\": \"Robinson Karen\", \"affiliation\": null}, {\"name\": \"Sagawa Takuya\", \"affiliation\": null}, {\"name\": \"Sierro Francisco\", \"affiliation\": null}, {\"name\": \"Takahashi Kunio T.\", \"affiliation\": null}, {\"name\": \"Torfstein Adi\", \"affiliation\": null}, {\"name\": \"Venancio Igor\", \"affiliation\": null}, {\"name\": \"Yamasaki Makoto\", \"affiliation\": null}, {\"name\": \"Ziveri Patrizia\", \"affiliation\": null}], \"keywords\": [\"Planktonic Foraminifera\", \"FORCIS database\", \"Biodiversity\"], \"version\": \"03\", \"resource_type\": {\"title\": \"Dataset\", \"type\": \"dataset\"}, \"license\": {\"id\": \"cc-by-4.0\"}, \"relations\": {\"version\": [{\"index\": 2, \"is_last\": false, \"parent\": {\"pid_type\": \"recid\", \"pid_value\": \"7390791\"}}]}}, \"title\": \"The FORCIS database: A global census of planktonic Foraminifera from ocean waters\", \"links\": {\"self\": \"https://zenodo.org/api/records/7936568\", \"self_html\": \"https://zenodo.org/records/7936568\", \"preview_html\": \"https://zenodo.org/records/7936568?preview=1\", \"doi\": \"https://doi.org/10.5281/zenodo.7936568\", \"self_doi\": \"https://doi.org/10.5281/zenodo.7936568\", \"self_doi_html\": \"https://zenodo.org/doi/10.5281/zenodo.7936568\", \"parent\": \"https://zenodo.org/api/records/7390791\", \"parent_html\": \"https://zenodo.org/records/7390791\", \"parent_doi\": \"https://doi.org/10.5281/zenodo.7390791\", \"parent_doi_html\": \"https://zenodo.org/doi/10.5281/zenodo.7390791\", \"self_iiif_manifest\": \"https://zenodo.org/api/iiif/record:7936568/manifest\", \"self_iiif_sequence\": \"https://zenodo.org/api/iiif/record:7936568/sequence/default\", \"files\": \"https://zenodo.org/api/records/7936568/files\", \"media_files\": \"https://zenodo.org/api/records/7936568/media-files\", \"archive\": \"https://zenodo.org/api/records/7936568/files-archive\", \"archive_media\": \"https://zenodo.org/api/records/7936568/media-files-archive\", \"latest\": \"https://zenodo.org/api/records/7936568/versions/latest\", \"latest_html\": \"https://zenodo.org/records/7936568/latest\", \"versions\": \"https://zenodo.org/api/records/7936568/versions\", \"draft\": \"https://zenodo.org/api/records/7936568/draft\", \"reserve_doi\": \"https://zenodo.org/api/records/7936568/draft/pids/doi\", \"access_links\": \"https://zenodo.org/api/records/7936568/access/links\", \"access_grants\": \"https://zenodo.org/api/records/7936568/access/grants\", \"access_users\": \"https://zenodo.org/api/records/7936568/access/users\", \"access_request\": \"https://zenodo.org/api/records/7936568/access/request\", \"access\": \"https://zenodo.org/api/records/7936568/access\", \"communities\": \"https://zenodo.org/api/records/7936568/communities\", \"communities-suggestions\": \"https://zenodo.org/api/records/7936568/communities-suggestions\", \"requests\": \"https://zenodo.org/api/records/7936568/requests\"}, \"updated\": \"2023-09-14T14:03:27.869554+00:00\", \"recid\": \"7936568\", \"revision\": 6, \"files\": [{\"id\": \"c15c390b-fc08-47ce-80a9-8660e1a59c55\", \"key\": \"FORCIS_pump_v03_14062023.csv\", \"size\": 649676, \"checksum\": \"md5:9bee5c30a35dacb623dc7ac4ff564117\", \"links\": {\"self\": \"https://zenodo.org/api/records/7936568/files/FORCIS_pump_v03_14062023.csv/content\"}}, {\"id\": \"e6baa5e4-59cc-47e2-a840-35fd1680f4c7\", \"key\": \"FORCIS data template.xlsx\", \"size\": 357853, \"checksum\": \"md5:ef3c3d67f1824c026fe6fb36aef0b56b\", \"links\": {\"self\": \"https://zenodo.org/api/records/7936568/files/FORCIS data template.xlsx/content\"}}, {\"id\": \"09aecd1f-b985-40f0-b824-76dfecf5fb39\", \"key\": \"FORCIS_cpr_south_v03_14062023.csv\", \"size\": 75018303, \"checksum\": \"md5:a8f8416c8aef723209e4a6df03722fdf\", \"links\": {\"self\": \"https://zenodo.org/api/records/7936568/files/FORCIS_cpr_south_v03_14062023.csv/content\"}}, {\"id\": \"aae224d3-b875-4f43-b9d5-4426f8a7cfd3\", \"key\": \"FORCIS_trap_v03_14062023.csv\", \"size\": 13270806, \"checksum\": \"md5:76bac6d2c85f699da059bfd48334baf4\", \"links\": {\"self\": \"https://zenodo.org/api/records/7936568/files/FORCIS_trap_v03_14062023.csv/content\"}}, {\"id\": \"7659d1cd-a719-415b-8db1-d47b3b82a1f0\", \"key\": \"FORCIS_cpr_north_v03_14062023.csv\", \"size\": 67556549, \"checksum\": \"md5:a32bbb863fe795cfcb953ca8928fd9c8\", \"links\": {\"self\": \"https://zenodo.org/api/records/7936568/files/FORCIS_cpr_north_v03_14062023.csv/content\"}}, {\"id\": \"c522aecd-250f-4e28-8563-57c1bde7c4f2\", \"key\": \"FORCIS taxonomy levels.xlsx\", \"size\": 24998, \"checksum\": \"md5:e12a45e2d34def4c1642353597a04bf8\", \"links\": {\"self\": \"https://zenodo.org/api/records/7936568/files/FORCIS taxonomy levels.xlsx/content\"}}, {\"id\": \"416b0af1-7a8d-4f5b-b8b9-a622b49229e0\", \"key\": \"FORCIS_net_v03_14062023.csv\", \"size\": 224502433, \"checksum\": \"md5:0e1f788654f026646ca5164cef309a7e\", \"links\": {\"self\": \"https://zenodo.org/api/records/7936568/files/FORCIS_net_v03_14062023.csv/content\"}}], \"swh\": {}, \"owners\": [{\"id\": \"452144\"}], \"status\": \"published\", \"stats\": {\"downloads\": 5487, \"unique_downloads\": 4158, \"views\": 3330, \"unique_views\": 2971, \"version_downloads\": 309, \"version_unique_downloads\": 184, \"version_unique_views\": 281, \"version_views\": 327}, \"state\": \"done\", \"submitted\": true}, {\"created\": \"2022-12-02T14:57:13.868141+00:00\", \"modified\": \"2023-09-14T14:03:27.668572+00:00\", \"id\": 7390792, \"conceptrecid\": \"7390791\", \"doi\": \"10.5281/zenodo.7390792\", \"conceptdoi\": \"10.5281/zenodo.7390791\", \"doi_url\": \"https://doi.org/10.5281/zenodo.7390792\", \"metadata\": {\"title\": \"The FORCIS database: A global census of planktonic Foraminifera from ocean waters\", \"doi\": \"10.5281/zenodo.7390792\", \"publication_date\": \"2022-12-02\", \"description\": \"<p>The FORCIS (Foraminifera Response to Climatic Stress) database&nbsp;is a synthesis grouping datasets on living planktonic foraminifera. We assembled foraminiferal diversity and distribution data in the global oceans from 1910 until 2018, curating published and unpublished datasets. This database includes data collected using plankton tows, continuous plankton recorder, sediment traps and plankton pump from the global ocean.</p>\\n\\n<p>The FORCIS database version 01&nbsp;is composed of 5 files (&ldquo;.csv&rdquo; format). All data coming from different sampling devices were put into separate &ldquo;.csv&rdquo; files. Only the data of the CPR from the Southern Hemisphere have been separated from the Northern Hemisphere CPR data as the data structure is not the same (species counts resolved vs. binned total counts, respectively).&nbsp;&nbsp;</p>\\n\\n<p>Apart from the file of&nbsp; CPR data from the Northern Hemisphere that contains only metadata and binned total counts, all the remaining four files contain 4 blocks:</p>\\n\\n<ul>\\n\\t<li>\\n\\t<p>Block 1: metadata (from column 1 to 71)</p>\\n\\t</li>\\n\\t<li>\\n\\t<p>Block 2: original counts (from column 72 to 274)</p>\\n\\t</li>\\n\\t<li>\\n\\t<p>Block 3: generated counts based on the validated taxonomy (from column 275 to 331). We added &ldquo;_VT&rdquo; to each species name to distinguish it from other taxonomy levels. E.g. &ldquo;g_bulloides&rdquo; became &ldquo;g_bulloides_VT&rdquo;. The number of species counted per subsample is also reported in the column &ldquo;number_of_species_counted_VT&rdquo;</p>\\n\\t</li>\\n\\t<li>\\n\\t<p>Block 4: generated counts based on the lumped taxonomy (from column 332 to 379). In this case, we added &ldquo;_LT&rdquo; to each species name. E.g. &ldquo;n_dutertrei&rdquo; became &ldquo;n_dutertrei_VT&rdquo;. We also calculated the number of species counted per subsample and reported it in the column &ldquo;number_of_species_counted_LT&rdquo;</p>\\n\\t</li>\\n</ul>\\n\\n<p>Foraminifera abundance data counts are reported in different categories in the blocks 1,2 and 3 and described in the table below:</p>\\n\\n<table align=\\\"center\\\">\\n\\t<tbody>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p><strong>count_type</strong></p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p><strong>unit</strong></p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Absolute</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>ind/m3</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Relative</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>%</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Raw</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>number of individuals</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Fluxes</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>ind/m2/day</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Bin_Absolute</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>ind/m3</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Bin_Relative</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>%</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Bin_Raw</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>number of individuals</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Bin_Fluxes</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>ind/m2/day</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t</tbody>\\n</table>\\n\\n<p>&nbsp;</p>\\n\\n<p>For more details about the FORCIS database column description, please check the data descriptor paper Chaabane et al. (2023) (https://doi.org/10.1038/s41597-023-02264-2).</p>\\n\\n<p>The database is kept open for any new entries and the updated version will be released in csv format. The labels of updated versions of the released &ldquo;.csv&rdquo; files will contain the date of their publication and versioning number.</p>\", \"access_right\": \"restricted\", \"creators\": [{\"name\": \"Chaabane, Sonia\", \"affiliation\": \"CEREGE, France and Max Planck, Germany\", \"orcid\": \"0000-0002-4653-8610\"}, {\"name\": \"de Garidel, Thibault\", \"affiliation\": \"CEREGE, France\", \"orcid\": \"0000-0001-8983-9571\"}, {\"name\": \"Giraud, Xavier\", \"affiliation\": \"CEREGE, France\", \"orcid\": \"0000-0002-6252-7647\"}, {\"name\": \"Schiebel, Ralf\", \"affiliation\": \"Max Planck, Germany\", \"orcid\": \"0000-0001-5067-8176\"}, {\"name\": \"Beaugrand, Gregory\", \"affiliation\": \"LOG, France\"}, {\"name\": \"Brummer, Geert-Jan\", \"affiliation\": \"NIOZ, Netherlands\"}, {\"name\": \"Casajus, Nicolas\", \"affiliation\": \"FRB CESAB\"}, {\"name\": \"Greco, Mattia\", \"affiliation\": \"Polish Academy of Sciences, Poland\"}, {\"name\": \"Grigoratou, Maria\", \"affiliation\": \"Mercator Ocean International, France\"}, {\"name\": \"Howa, H\\u00e9l\\u00e8ne\", \"affiliation\": \"LPG-BIAF, France\"}, {\"name\": \"Jonkers, Lukas\", \"affiliation\": \"MARUM, Germany\"}, {\"name\": \"Kucera, Michal\", \"affiliation\": \"MARUM, Germany\"}, {\"name\": \"Kuroyanagi, Azumi\", \"affiliation\": \"Tohoku Univ., Japan\"}, {\"name\": \"Meilland, Julie\", \"affiliation\": \"MARUM, Germany\"}, {\"name\": \"Monteiro, Fanny\", \"affiliation\": \"BRIDGE, UK\"}, {\"name\": \"Mortyn, Graham\", \"affiliation\": \"ICTA UAB, Spain\"}, {\"name\": \"Almogi-Labin Ahuva\", \"affiliation\": null}, {\"name\": \"Asahi Hirofumi\", \"affiliation\": null}, {\"name\": \"Avnaim-Katav Simona\", \"affiliation\": null}, {\"name\": \"Bassinot Franck\", \"affiliation\": null}, {\"name\": \"Davis Catherine V.\", \"affiliation\": null}, {\"name\": \"Field David B.\", \"affiliation\": null}, {\"name\": \"Hernandez-Almeida Ivan\", \"affiliation\": null}, {\"name\": \"Herut Barak\", \"affiliation\": null}, {\"name\": \"Hosie Graham\", \"affiliation\": null}, {\"name\": \"Howard Will\", \"affiliation\": null}, {\"name\": \"Jentzen Anna\", \"affiliation\": null}, {\"name\": \"Johns David G.\", \"affiliation\": null}, {\"name\": \"Keigwin Lloyd\", \"affiliation\": null}, {\"name\": \"Kitchener John\", \"affiliation\": null}, {\"name\": \"Kohfeld Karen E.\", \"affiliation\": null}, {\"name\": \"Lessa Douglas V.O.\", \"affiliation\": null}, {\"name\": \"Manno Clara\", \"affiliation\": null}, {\"name\": \"Marchant Margarita\", \"affiliation\": null}, {\"name\": \"Ofstad Siri\", \"affiliation\": null}, {\"name\": \"Ortiz Joseph D.\", \"affiliation\": null}, {\"name\": \"Post Alexandra\", \"affiliation\": null}, {\"name\": \"Rigual-Hernandez Andres\", \"affiliation\": null}, {\"name\": \"Rillo Marina C.\", \"affiliation\": null}, {\"name\": \"Robinson Karen\", \"affiliation\": null}, {\"name\": \"Sagawa Takuya\", \"affiliation\": null}, {\"name\": \"Sierro Francisco\", \"affiliation\": null}, {\"name\": \"Takahashi Kunio T.\", \"affiliation\": null}, {\"name\": \"Torfstein Adi\", \"affiliation\": null}, {\"name\": \"Venancio Igor\", \"affiliation\": null}, {\"name\": \"Yamasaki Makoto\", \"affiliation\": null}, {\"name\": \"Ziveri Patrizia\", \"affiliation\": null}], \"keywords\": [\"Planktonic Foraminifera\", \"FORCIS database\", \"Biodiversity\"], \"version\": \"01\", \"resource_type\": {\"title\": \"Dataset\", \"type\": \"dataset\"}, \"relations\": {\"version\": [{\"index\": 0, \"is_last\": false, \"parent\": {\"pid_type\": \"recid\", \"pid_value\": \"7390791\"}}]}}, \"title\": \"The FORCIS database: A global census of planktonic Foraminifera from ocean waters\", \"links\": {\"self\": \"https://zenodo.org/api/records/7390792\", \"self_html\": \"https://zenodo.org/records/7390792\", \"preview_html\": \"https://zenodo.org/records/7390792?preview=1\", \"doi\": \"https://doi.org/10.5281/zenodo.7390792\", \"self_doi\": \"https://doi.org/10.5281/zenodo.7390792\", \"self_doi_html\": \"https://zenodo.org/doi/10.5281/zenodo.7390792\", \"parent\": \"https://zenodo.org/api/records/7390791\", \"parent_html\": \"https://zenodo.org/records/7390791\", \"parent_doi\": \"https://doi.org/10.5281/zenodo.7390791\", \"parent_doi_html\": \"https://zenodo.org/doi/10.5281/zenodo.7390791\", \"self_iiif_manifest\": \"https://zenodo.org/api/iiif/record:7390792/manifest\", \"self_iiif_sequence\": \"https://zenodo.org/api/iiif/record:7390792/sequence/default\", \"files\": \"https://zenodo.org/api/records/7390792/files\", \"media_files\": \"https://zenodo.org/api/records/7390792/media-files\", \"archive\": \"https://zenodo.org/api/records/7390792/files-archive\", \"archive_media\": \"https://zenodo.org/api/records/7390792/media-files-archive\", \"latest\": \"https://zenodo.org/api/records/7390792/versions/latest\", \"latest_html\": \"https://zenodo.org/records/7390792/latest\", \"versions\": \"https://zenodo.org/api/records/7390792/versions\", \"draft\": \"https://zenodo.org/api/records/7390792/draft\", \"reserve_doi\": \"https://zenodo.org/api/records/7390792/draft/pids/doi\", \"access_links\": \"https://zenodo.org/api/records/7390792/access/links\", \"access_grants\": \"https://zenodo.org/api/records/7390792/access/grants\", \"access_users\": \"https://zenodo.org/api/records/7390792/access/users\", \"access_request\": \"https://zenodo.org/api/records/7390792/access/request\", \"access\": \"https://zenodo.org/api/records/7390792/access\", \"communities\": \"https://zenodo.org/api/records/7390792/communities\", \"communities-suggestions\": \"https://zenodo.org/api/records/7390792/communities-suggestions\", \"requests\": \"https://zenodo.org/api/records/7390792/requests\"}, \"updated\": \"2023-09-14T14:03:27.668572+00:00\", \"recid\": \"7390792\", \"revision\": 16, \"files\": [], \"swh\": {}, \"owners\": [{\"id\": \"452144\"}], \"status\": \"published\", \"stats\": {\"downloads\": 5487, \"unique_downloads\": 4158, \"views\": 3330, \"unique_views\": 2971, \"version_downloads\": 151, \"version_unique_downloads\": 96, \"version_unique_views\": 955, \"version_views\": 1053}, \"state\": \"done\", \"submitted\": true}, {\"created\": \"2023-07-26T13:31:12.485350+00:00\", \"modified\": \"2023-09-14T14:03:27.973746+00:00\", \"id\": 8186736, \"conceptrecid\": \"7390791\", \"doi\": \"10.5281/zenodo.8186736\", \"conceptdoi\": \"10.5281/zenodo.7390791\", \"doi_url\": \"https://doi.org/10.5281/zenodo.8186736\", \"metadata\": {\"title\": \"The FORCIS database: A global census of planktonic Foraminifera from ocean waters\", \"doi\": \"10.5281/zenodo.8186736\", \"publication_date\": \"2023-07-26\", \"description\": \"<p>The FORCIS (Foraminifera Response to Climatic Stress) database&nbsp;is a synthesis grouping datasets on living planktonic foraminifera. We assembled foraminiferal diversity and distribution data in the global oceans from 1910 until 2018, curating published and unpublished datasets. This database includes data collected using plankton tows, continuous plankton recorder, sediment traps and plankton pump from the global ocean.</p>\\n\\n<p>The FORCIS database version 01&nbsp;is composed of 5 files (&ldquo;.csv&rdquo; format). All data coming from different sampling devices were put into separate &ldquo;.csv&rdquo; files. Only the data of the CPR from the Southern Hemisphere have been separated from the Northern Hemisphere CPR data as the data structure is not the same (species counts resolved vs. binned total counts, respectively).&nbsp;&nbsp;</p>\\n\\n<p>Apart from the file of&nbsp; CPR data from the Northern Hemisphere that contains only metadata and binned total counts, all the remaining four files contain 4 blocks:</p>\\n\\n<ul>\\n\\t<li>\\n\\t<p>Block 1: metadata (from column 1 to 71)</p>\\n\\t</li>\\n\\t<li>\\n\\t<p>Block 2: original counts (from column 72 to 274)</p>\\n\\t</li>\\n\\t<li>\\n\\t<p>Block 3: generated counts based on the validated taxonomy (from column 275 to 331). We added &ldquo;_VT&rdquo; to each species name to distinguish it from other taxonomy levels. E.g. &ldquo;g_bulloides&rdquo; became &ldquo;g_bulloides_VT&rdquo;. The number of species counted per subsample is also reported in the column &ldquo;number_of_species_counted_VT&rdquo;</p>\\n\\t</li>\\n\\t<li>\\n\\t<p>Block 4: generated counts based on the lumped taxonomy (from column 332 to 379). In this case, we added &ldquo;_LT&rdquo; to each species name. E.g. &ldquo;n_dutertrei&rdquo; became &ldquo;n_dutertrei_VT&rdquo;. We also calculated the number of species counted per subsample and reported it in the column &ldquo;number_of_species_counted_LT&rdquo;</p>\\n\\t</li>\\n</ul>\\n\\n<p>Foraminifera abundance data counts are reported in different categories in the blocks 1,2 and 3 and described in the table below:</p>\\n\\n<table align=\\\"center\\\">\\n\\t<tbody>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p><strong>count_type</strong></p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p><strong>unit</strong></p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Absolute</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>ind/m3</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Relative</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>%</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Raw</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>number of individuals</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Fluxes</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>ind/m2/day</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Bin_Absolute</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>ind/m3</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Bin_Relative</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>%</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Bin_Raw</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>number of individuals</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Bin_Fluxes</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>ind/m2/day</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t</tbody>\\n</table>\\n\\n<p>&nbsp;</p>\\n\\n<p>For more details about the FORCIS database column description, please check the data descriptor paper <strong>Chaabane et al. (2023) (https://doi.org/10.1038/s41597-023-02264-2).</strong></p>\\n\\n<p>The database is kept open for any new entries and the updated version will be released in csv format. The labels of updated versions of the released &ldquo;.csv&rdquo; files will contain the date of their publication and versioning number.</p>\", \"access_right\": \"open\", \"creators\": [{\"name\": \"Chaabane, Sonia\", \"affiliation\": \"CEREGE, France and Max Planck, Germany\", \"orcid\": \"0000-0002-4653-8610\"}, {\"name\": \"de Garidel, Thibault\", \"affiliation\": \"CEREGE, France\", \"orcid\": \"0000-0001-8983-9571\"}, {\"name\": \"Giraud, Xavier\", \"affiliation\": \"CEREGE, France\", \"orcid\": \"0000-0002-6252-7647\"}, {\"name\": \"Schiebel, Ralf\", \"affiliation\": \"Max Planck, Germany\", \"orcid\": \"0000-0001-5067-8176\"}, {\"name\": \"Beaugrand, Gregory\", \"affiliation\": \"LOG, France\"}, {\"name\": \"Brummer, Geert-Jan\", \"affiliation\": \"NIOZ, Netherlands\"}, {\"name\": \"Casajus, Nicolas\", \"affiliation\": \"FRB CESAB\"}, {\"name\": \"Greco, Mattia\", \"affiliation\": \"Polish Academy of Sciences, Poland\"}, {\"name\": \"Grigoratou, Maria\", \"affiliation\": \"Mercator Ocean International, France\"}, {\"name\": \"Howa, H\\u00e9l\\u00e8ne\", \"affiliation\": \"LPG-BIAF, France\"}, {\"name\": \"Jonkers, Lukas\", \"affiliation\": \"MARUM, Germany\"}, {\"name\": \"Kucera, Michal\", \"affiliation\": \"MARUM, Germany\"}, {\"name\": \"Kuroyanagi, Azumi\", \"affiliation\": \"Tohoku Univ., Japan\"}, {\"name\": \"Meilland, Julie\", \"affiliation\": \"MARUM, Germany\"}, {\"name\": \"Monteiro, Fanny\", \"affiliation\": \"BRIDGE, UK\"}, {\"name\": \"Mortyn, Graham\", \"affiliation\": \"ICTA UAB, Spain\"}, {\"name\": \"Almogi-Labin Ahuva\", \"affiliation\": null}, {\"name\": \"Asahi Hirofumi\", \"affiliation\": null}, {\"name\": \"Avnaim-Katav Simona\", \"affiliation\": null}, {\"name\": \"Bassinot Franck\", \"affiliation\": null}, {\"name\": \"Davis Catherine V.\", \"affiliation\": null}, {\"name\": \"Field David B.\", \"affiliation\": null}, {\"name\": \"Hernandez-Almeida Ivan\", \"affiliation\": null}, {\"name\": \"Herut Barak\", \"affiliation\": null}, {\"name\": \"Hosie Graham\", \"affiliation\": null}, {\"name\": \"Howard Will\", \"affiliation\": null}, {\"name\": \"Jentzen Anna\", \"affiliation\": null}, {\"name\": \"Johns David G.\", \"affiliation\": null}, {\"name\": \"Keigwin Lloyd\", \"affiliation\": null}, {\"name\": \"Kitchener John\", \"affiliation\": null}, {\"name\": \"Kohfeld Karen E.\", \"affiliation\": null}, {\"name\": \"Lessa Douglas V.O.\", \"affiliation\": null}, {\"name\": \"Manno Clara\", \"affiliation\": null}, {\"name\": \"Marchant Margarita\", \"affiliation\": null}, {\"name\": \"Ofstad Siri\", \"affiliation\": null}, {\"name\": \"Ortiz Joseph D.\", \"affiliation\": null}, {\"name\": \"Post Alexandra\", \"affiliation\": null}, {\"name\": \"Rigual-Hernandez Andres\", \"affiliation\": null}, {\"name\": \"Rillo Marina C.\", \"affiliation\": null}, {\"name\": \"Robinson Karen\", \"affiliation\": null}, {\"name\": \"Sagawa Takuya\", \"affiliation\": null}, {\"name\": \"Sierro Francisco\", \"affiliation\": null}, {\"name\": \"Takahashi Kunio T.\", \"affiliation\": null}, {\"name\": \"Torfstein Adi\", \"affiliation\": null}, {\"name\": \"Venancio Igor\", \"affiliation\": null}, {\"name\": \"Yamasaki Makoto\", \"affiliation\": null}, {\"name\": \"Ziveri Patrizia\", \"affiliation\": null}], \"keywords\": [\"Planktonic Foraminifera\", \"FORCIS database\", \"Biodiversity\"], \"version\": \"04\", \"resource_type\": {\"title\": \"Dataset\", \"type\": \"dataset\"}, \"license\": {\"id\": \"cc-by-4.0\"}, \"relations\": {\"version\": [{\"index\": 3, \"is_last\": false, \"parent\": {\"pid_type\": \"recid\", \"pid_value\": \"7390791\"}}]}}, \"title\": \"The FORCIS database: A global census of planktonic Foraminifera from ocean waters\", \"links\": {\"self\": \"https://zenodo.org/api/records/8186736\", \"self_html\": \"https://zenodo.org/records/8186736\", \"preview_html\": \"https://zenodo.org/records/8186736?preview=1\", \"doi\": \"https://doi.org/10.5281/zenodo.8186736\", \"self_doi\": \"https://doi.org/10.5281/zenodo.8186736\", \"self_doi_html\": \"https://zenodo.org/doi/10.5281/zenodo.8186736\", \"parent\": \"https://zenodo.org/api/records/7390791\", \"parent_html\": \"https://zenodo.org/records/7390791\", \"parent_doi\": \"https://doi.org/10.5281/zenodo.7390791\", \"parent_doi_html\": \"https://zenodo.org/doi/10.5281/zenodo.7390791\", \"self_iiif_manifest\": \"https://zenodo.org/api/iiif/record:8186736/manifest\", \"self_iiif_sequence\": \"https://zenodo.org/api/iiif/record:8186736/sequence/default\", \"files\": \"https://zenodo.org/api/records/8186736/files\", \"media_files\": \"https://zenodo.org/api/records/8186736/media-files\", \"archive\": \"https://zenodo.org/api/records/8186736/files-archive\", \"archive_media\": \"https://zenodo.org/api/records/8186736/media-files-archive\", \"latest\": \"https://zenodo.org/api/records/8186736/versions/latest\", \"latest_html\": \"https://zenodo.org/records/8186736/latest\", \"versions\": \"https://zenodo.org/api/records/8186736/versions\", \"draft\": \"https://zenodo.org/api/records/8186736/draft\", \"reserve_doi\": \"https://zenodo.org/api/records/8186736/draft/pids/doi\", \"access_links\": \"https://zenodo.org/api/records/8186736/access/links\", \"access_grants\": \"https://zenodo.org/api/records/8186736/access/grants\", \"access_users\": \"https://zenodo.org/api/records/8186736/access/users\", \"access_request\": \"https://zenodo.org/api/records/8186736/access/request\", \"access\": \"https://zenodo.org/api/records/8186736/access\", \"communities\": \"https://zenodo.org/api/records/8186736/communities\", \"communities-suggestions\": \"https://zenodo.org/api/records/8186736/communities-suggestions\", \"requests\": \"https://zenodo.org/api/records/8186736/requests\"}, \"updated\": \"2023-09-14T14:03:27.973746+00:00\", \"recid\": \"8186736\", \"revision\": 3, \"files\": [{\"id\": \"c8d3c264-6e9a-413c-8320-0d9d86bfb29b\", \"key\": \"FORCIS_cpr_north_v04_26072023.csv\", \"size\": 67556549, \"checksum\": \"md5:a32bbb863fe795cfcb953ca8928fd9c8\", \"links\": {\"self\": \"https://zenodo.org/api/records/8186736/files/FORCIS_cpr_north_v04_26072023.csv/content\"}}, {\"id\": \"8628166a-be41-427d-adc2-e2aac300af20\", \"key\": \"FORCIS_trap_v04_26072023.csv\", \"size\": 13270806, \"checksum\": \"md5:76bac6d2c85f699da059bfd48334baf4\", \"links\": {\"self\": \"https://zenodo.org/api/records/8186736/files/FORCIS_trap_v04_26072023.csv/content\"}}, {\"id\": \"e6baa5e4-59cc-47e2-a840-35fd1680f4c7\", \"key\": \"FORCIS data template.xlsx\", \"size\": 357853, \"checksum\": \"md5:ef3c3d67f1824c026fe6fb36aef0b56b\", \"links\": {\"self\": \"https://zenodo.org/api/records/8186736/files/FORCIS data template.xlsx/content\"}}, {\"id\": \"39e1e55c-038f-4739-aa9c-2f441c440af4\", \"key\": \"FORCIS_pump_v04_26072023.csv\", \"size\": 649676, \"checksum\": \"md5:9bee5c30a35dacb623dc7ac4ff564117\", \"links\": {\"self\": \"https://zenodo.org/api/records/8186736/files/FORCIS_pump_v04_26072023.csv/content\"}}, {\"id\": \"21d35cfe-e887-4498-921a-c9295927ce27\", \"key\": \"FORCIS_cpr_south_v04_26072023.csv\", \"size\": 75018303, \"checksum\": \"md5:a8f8416c8aef723209e4a6df03722fdf\", \"links\": {\"self\": \"https://zenodo.org/api/records/8186736/files/FORCIS_cpr_south_v04_26072023.csv/content\"}}, {\"id\": \"c522aecd-250f-4e28-8563-57c1bde7c4f2\", \"key\": \"FORCIS taxonomy levels.xlsx\", \"size\": 24998, \"checksum\": \"md5:e12a45e2d34def4c1642353597a04bf8\", \"links\": {\"self\": \"https://zenodo.org/api/records/8186736/files/FORCIS taxonomy levels.xlsx/content\"}}, {\"id\": \"1328a878-18c3-4226-9d3b-bbc1daff72db\", \"key\": \"FORCIS_net_v04_26072023.csv\", \"size\": 28369859, \"checksum\": \"md5:03fde71e007516cef9a83f53daa6d2c9\", \"links\": {\"self\": \"https://zenodo.org/api/records/8186736/files/FORCIS_net_v04_26072023.csv/content\"}}], \"swh\": {}, \"owners\": [{\"id\": \"452144\"}], \"status\": \"published\", \"stats\": {\"downloads\": 5487, \"unique_downloads\": 4158, \"views\": 3330, \"unique_views\": 2971, \"version_downloads\": 603, \"version_unique_downloads\": 507, \"version_unique_views\": 228, \"version_views\": 244}, \"state\": \"done\", \"submitted\": true}, {\"created\": \"2023-04-14T12:20:37.565498+00:00\", \"modified\": \"2023-09-14T14:03:27.766774+00:00\", \"id\": 7827791, \"conceptrecid\": \"7390791\", \"doi\": \"10.5281/zenodo.7827791\", \"conceptdoi\": \"10.5281/zenodo.7390791\", \"doi_url\": \"https://doi.org/10.5281/zenodo.7827791\", \"metadata\": {\"title\": \"The FORCIS database: A global census of planktonic Foraminifera from ocean waters\", \"doi\": \"10.5281/zenodo.7827791\", \"publication_date\": \"2023-05-24\", \"description\": \"<p>The FORCIS (Foraminifera Response to Climatic Stress) database&nbsp;is a synthesis grouping datasets on living planktonic foraminifera. We assembled foraminiferal diversity and distribution data in the global oceans from 1910 until 2018, curating published and unpublished datasets. This database includes data collected using plankton tows, continuous plankton recorder, sediment traps and plankton pump from the global ocean.</p>\\n\\n<p>The FORCIS database version 01&nbsp;is composed of 5 files (&ldquo;.csv&rdquo; format). All data coming from different sampling devices were put into separate &ldquo;.csv&rdquo; files. Only the data of the CPR from the Southern Hemisphere have been separated from the Northern Hemisphere CPR data as the data structure is not the same (species counts resolved vs. binned total counts, respectively).&nbsp;&nbsp;</p>\\n\\n<p>Apart from the file of&nbsp; CPR data from the Northern Hemisphere that contains only metadata and binned total counts, all the remaining four files contain 4 blocks:</p>\\n\\n<ul>\\n\\t<li>\\n\\t<p>Block 1: metadata (from column 1 to 71)</p>\\n\\t</li>\\n\\t<li>\\n\\t<p>Block 2: original counts (from column 72 to 274)</p>\\n\\t</li>\\n\\t<li>\\n\\t<p>Block 3: generated counts based on the validated taxonomy (from column 275 to 331). We added &ldquo;_VT&rdquo; to each species name to distinguish it from other taxonomy levels. E.g. &ldquo;g_bulloides&rdquo; became &ldquo;g_bulloides_VT&rdquo;. The number of species counted per subsample is also reported in the column &ldquo;number_of_species_counted_VT&rdquo;</p>\\n\\t</li>\\n\\t<li>\\n\\t<p>Block 4: generated counts based on the lumped taxonomy (from column 332 to 379). In this case, we added &ldquo;_LT&rdquo; to each species name. E.g. &ldquo;n_dutertrei&rdquo; became &ldquo;n_dutertrei_VT&rdquo;. We also calculated the number of species counted per subsample and reported it in the column &ldquo;number_of_species_counted_LT&rdquo;</p>\\n\\t</li>\\n</ul>\\n\\n<p>Foraminifera abundance data counts are reported in different categories in the blocks 1,2 and 3 and described in the table below:</p>\\n\\n<table align=\\\"center\\\">\\n\\t<tbody>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p><strong>count_type</strong></p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p><strong>unit</strong></p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Absolute</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>ind/m3</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Relative</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>%</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Raw</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>number of individuals</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Fluxes</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>ind/m2/day</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Bin_Absolute</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>ind/m3</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Bin_Relative</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>%</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Bin_Raw</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>number of individuals</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Bin_Fluxes</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>ind/m2/day</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t</tbody>\\n</table>\\n\\n<p>&nbsp;</p>\\n\\n<p>For more details about the FORCIS database column description, please check the data descriptor paper Chaabane et al. (20XX) (doi).</p>\\n\\n<p>The database is kept open for any new entries and the updated version will be released in csv format. The labels of updated versions of the released &ldquo;.csv&rdquo; files will contain the date of their publication and versioning number.</p>\", \"access_right\": \"open\", \"creators\": [{\"name\": \"Chaabane, Sonia\", \"affiliation\": \"CEREGE, France and Max Planck, Germany\", \"orcid\": \"0000-0002-4653-8610\"}, {\"name\": \"de Garidel, Thibault\", \"affiliation\": \"CEREGE, France\", \"orcid\": \"0000-0001-8983-9571\"}, {\"name\": \"Giraud, Xavier\", \"affiliation\": \"CEREGE, France\", \"orcid\": \"0000-0002-6252-7647\"}, {\"name\": \"Schiebel, Ralf\", \"affiliation\": \"Max Planck, Germany\", \"orcid\": \"0000-0001-5067-8176\"}, {\"name\": \"Beaugrand, Gregory\", \"affiliation\": \"LOG, France\"}, {\"name\": \"Brummer, Geert-Jan\", \"affiliation\": \"NIOZ, Netherlands\"}, {\"name\": \"Casajus, Nicolas\", \"affiliation\": \"FRB CESAB\"}, {\"name\": \"Greco, Mattia\", \"affiliation\": \"Polish Academy of Sciences, Poland\"}, {\"name\": \"Grigoratou, Maria\", \"affiliation\": \"Mercator Ocean International, France\"}, {\"name\": \"Howa, H\\u00e9l\\u00e8ne\", \"affiliation\": \"LPG-BIAF, France\"}, {\"name\": \"Jonkers, Lukas\", \"affiliation\": \"MARUM, Germany\"}, {\"name\": \"Kucera, Michal\", \"affiliation\": \"MARUM, Germany\"}, {\"name\": \"Kuroyanagi, Azumi\", \"affiliation\": \"Tohoku Univ., Japan\"}, {\"name\": \"Meilland, Julie\", \"affiliation\": \"MARUM, Germany\"}, {\"name\": \"Monteiro, Fanny\", \"affiliation\": \"BRIDGE, UK\"}, {\"name\": \"Mortyn, Graham\", \"affiliation\": \"ICTA UAB, Spain\"}, {\"name\": \"Almogi-Labin Ahuva\", \"affiliation\": null}, {\"name\": \"Asahi Hirofumi\", \"affiliation\": null}, {\"name\": \"Avnaim-Katav Simona\", \"affiliation\": null}, {\"name\": \"Bassinot Franck\", \"affiliation\": null}, {\"name\": \"Davis Catherine V.\", \"affiliation\": null}, {\"name\": \"Field David B.\", \"affiliation\": null}, {\"name\": \"Hernandez-Almeida Ivan\", \"affiliation\": null}, {\"name\": \"Herut Barak\", \"affiliation\": null}, {\"name\": \"Hosie Graham\", \"affiliation\": null}, {\"name\": \"Howard Will\", \"affiliation\": null}, {\"name\": \"Jentzen Anna\", \"affiliation\": null}, {\"name\": \"Johns David G.\", \"affiliation\": null}, {\"name\": \"Keigwin Lloyd\", \"affiliation\": null}, {\"name\": \"Kitchener John\", \"affiliation\": null}, {\"name\": \"Kohfeld Karen E.\", \"affiliation\": null}, {\"name\": \"Lessa Douglas V.O.\", \"affiliation\": null}, {\"name\": \"Manno Clara\", \"affiliation\": null}, {\"name\": \"Marchant Margarita\", \"affiliation\": null}, {\"name\": \"Ofstad Siri\", \"affiliation\": null}, {\"name\": \"Ortiz Joseph D.\", \"affiliation\": null}, {\"name\": \"Post Alexandra\", \"affiliation\": null}, {\"name\": \"Rigual-Hernandez Andres\", \"affiliation\": null}, {\"name\": \"Rillo Marina C.\", \"affiliation\": null}, {\"name\": \"Robinson Karen\", \"affiliation\": null}, {\"name\": \"Sagawa Takuya\", \"affiliation\": null}, {\"name\": \"Sierro Francisco\", \"affiliation\": null}, {\"name\": \"Takahashi Kunio T.\", \"affiliation\": null}, {\"name\": \"Torfstein Adi\", \"affiliation\": null}, {\"name\": \"Venancio Igor\", \"affiliation\": null}, {\"name\": \"Yamasaki Makoto\", \"affiliation\": null}, {\"name\": \"Ziveri Patrizia\", \"affiliation\": null}], \"keywords\": [\"Planktonic Foraminifera\", \"FORCIS database\", \"Biodiversity\"], \"version\": \"02\", \"resource_type\": {\"title\": \"Dataset\", \"type\": \"dataset\"}, \"license\": {\"id\": \"cc-by-4.0\"}, \"relations\": {\"version\": [{\"index\": 1, \"is_last\": false, \"parent\": {\"pid_type\": \"recid\", \"pid_value\": \"7390791\"}}]}}, \"title\": \"The FORCIS database: A global census of planktonic Foraminifera from ocean waters\", \"links\": {\"self\": \"https://zenodo.org/api/records/7827791\", \"self_html\": \"https://zenodo.org/records/7827791\", \"preview_html\": \"https://zenodo.org/records/7827791?preview=1\", \"doi\": \"https://doi.org/10.5281/zenodo.7827791\", \"self_doi\": \"https://doi.org/10.5281/zenodo.7827791\", \"self_doi_html\": \"https://zenodo.org/doi/10.5281/zenodo.7827791\", \"parent\": \"https://zenodo.org/api/records/7390791\", \"parent_html\": \"https://zenodo.org/records/7390791\", \"parent_doi\": \"https://doi.org/10.5281/zenodo.7390791\", \"parent_doi_html\": \"https://zenodo.org/doi/10.5281/zenodo.7390791\", \"self_iiif_manifest\": \"https://zenodo.org/api/iiif/record:7827791/manifest\", \"self_iiif_sequence\": \"https://zenodo.org/api/iiif/record:7827791/sequence/default\", \"files\": \"https://zenodo.org/api/records/7827791/files\", \"media_files\": \"https://zenodo.org/api/records/7827791/media-files\", \"archive\": \"https://zenodo.org/api/records/7827791/files-archive\", \"archive_media\": \"https://zenodo.org/api/records/7827791/media-files-archive\", \"latest\": \"https://zenodo.org/api/records/7827791/versions/latest\", \"latest_html\": \"https://zenodo.org/records/7827791/latest\", \"versions\": \"https://zenodo.org/api/records/7827791/versions\", \"draft\": \"https://zenodo.org/api/records/7827791/draft\", \"reserve_doi\": \"https://zenodo.org/api/records/7827791/draft/pids/doi\", \"access_links\": \"https://zenodo.org/api/records/7827791/access/links\", \"access_grants\": \"https://zenodo.org/api/records/7827791/access/grants\", \"access_users\": \"https://zenodo.org/api/records/7827791/access/users\", \"access_request\": \"https://zenodo.org/api/records/7827791/access/request\", \"access\": \"https://zenodo.org/api/records/7827791/access\", \"communities\": \"https://zenodo.org/api/records/7827791/communities\", \"communities-suggestions\": \"https://zenodo.org/api/records/7827791/communities-suggestions\", \"requests\": \"https://zenodo.org/api/records/7827791/requests\"}, \"updated\": \"2023-09-14T14:03:27.766774+00:00\", \"recid\": \"7827791\", \"revision\": 10, \"files\": [{\"id\": \"c0e17a31-6457-4dc1-966b-0fd8bcadaaf2\", \"key\": \"FORCIS_pump_v01_02122022.csv\", \"size\": 529224, \"checksum\": \"md5:5ca923d1ac5f68781872891a327617bf\", \"links\": {\"self\": \"https://zenodo.org/api/records/7827791/files/FORCIS_pump_v01_02122022.csv/content\"}}, {\"id\": \"91a07638-7531-4d36-9f45-2ea86ddcc265\", \"key\": \"FORCIS_net_v01_02122022.csv\", \"size\": 90809731, \"checksum\": \"md5:32525a56f69e2aa0efa672e8ef1a3f23\", \"links\": {\"self\": \"https://zenodo.org/api/records/7827791/files/FORCIS_net_v01_02122022.csv/content\"}}, {\"id\": \"0780c5a0-93df-479c-ae1d-60d37056e186\", \"key\": \"FORCIS data template.xlsx\", \"size\": 357853, \"checksum\": \"md5:ef3c3d67f1824c026fe6fb36aef0b56b\", \"links\": {\"self\": \"https://zenodo.org/api/records/7827791/files/FORCIS data template.xlsx/content\"}}, {\"id\": \"ce2496ad-e949-4c8e-8a9e-9ab09d3e411d\", \"key\": \"FORCIS_cpr_south_v01_02122022.csv\", \"size\": 61869825, \"checksum\": \"md5:00bd312f83264e8cdfa659780b328e03\", \"links\": {\"self\": \"https://zenodo.org/api/records/7827791/files/FORCIS_cpr_south_v01_02122022.csv/content\"}}, {\"id\": \"e3deb95d-af54-4518-8b84-d1ffcfda7abb\", \"key\": \"FORCIS_cpr_north_v01_02122022.csv\", \"size\": 61791717, \"checksum\": \"md5:4ee57d506314729ff2410b8fa9ddb2ca\", \"links\": {\"self\": \"https://zenodo.org/api/records/7827791/files/FORCIS_cpr_north_v01_02122022.csv/content\"}}, {\"id\": \"3e0b2f9a-0130-4eab-a1f1-a942630828f8\", \"key\": \"FORCIS_trap_v01_02122022.csv\", \"size\": 12893278, \"checksum\": \"md5:2bda4856102f02b1558c8eacd8390745\", \"links\": {\"self\": \"https://zenodo.org/api/records/7827791/files/FORCIS_trap_v01_02122022.csv/content\"}}, {\"id\": \"3dd0269f-0b33-4798-8dff-69260b599fdb\", \"key\": \"FORCIS taxonomy levels.xlsx\", \"size\": 24998, \"checksum\": \"md5:e12a45e2d34def4c1642353597a04bf8\", \"links\": {\"self\": \"https://zenodo.org/api/records/7827791/files/FORCIS taxonomy levels.xlsx/content\"}}], \"swh\": {}, \"owners\": [{\"id\": \"452144\"}], \"status\": \"published\", \"stats\": {\"downloads\": 5487, \"unique_downloads\": 4158, \"views\": 3330, \"unique_views\": 2971, \"version_downloads\": 364, \"version_unique_downloads\": 263, \"version_unique_views\": 370, \"version_views\": 410}, \"state\": \"done\", \"submitted\": true}, {\"created\": \"2024-02-09T15:18:50.110550+00:00\", \"modified\": \"2024-02-09T15:18:50.503015+00:00\", \"id\": 10640925, \"conceptrecid\": \"7390791\", \"doi\": \"10.5281/zenodo.10640925\", \"conceptdoi\": \"10.5281/zenodo.7390791\", \"doi_url\": \"https://doi.org/10.5281/zenodo.10640925\", \"metadata\": {\"title\": \"The FORCIS database: A global census of planktonic Foraminifera from ocean waters\", \"doi\": \"10.5281/zenodo.10640925\", \"publication_date\": \"2024-02-09\", \"description\": \"<p>The FORCIS (Foraminifera Response to Climatic Stress) database&nbsp;is a synthesis grouping datasets on living planktonic foraminifera. We assembled foraminiferal diversity and distribution data in the global oceans from 1910 until 2018, curating published and unpublished datasets. This database includes data collected using plankton tows, continuous plankton recorder, sediment traps and plankton pump from the global ocean.</p>\\n\\n<p>The FORCIS database version 01&nbsp;is composed of 5 files (&ldquo;.csv&rdquo; format). All data coming from different sampling devices were put into separate &ldquo;.csv&rdquo; files. Only the data of the CPR from the Southern Hemisphere have been separated from the Northern Hemisphere CPR data as the data structure is not the same (species counts resolved vs. binned total counts, respectively).&nbsp;&nbsp;</p>\\n\\n<p>Apart from the file of&nbsp; CPR data from the Northern Hemisphere that contains only metadata and binned total counts, all the remaining four files contain 4 blocks:</p>\\n\\n<ul>\\n\\t<li>\\n\\t<p>Block 1: metadata (from column 1 to 71)</p>\\n\\t</li>\\n\\t<li>\\n\\t<p>Block 2: original counts (from column 72 to 274)</p>\\n\\t</li>\\n\\t<li>\\n\\t<p>Block 3: generated counts based on the validated taxonomy (from column 275 to 331). We added &ldquo;_VT&rdquo; to each species name to distinguish it from other taxonomy levels. E.g. &ldquo;g_bulloides&rdquo; became &ldquo;g_bulloides_VT&rdquo;. The number of species counted per subsample is also reported in the column &ldquo;number_of_species_counted_VT&rdquo;</p>\\n\\t</li>\\n\\t<li>\\n\\t<p>Block 4: generated counts based on the lumped taxonomy (from column 332 to 379). In this case, we added &ldquo;_LT&rdquo; to each species name. E.g. &ldquo;n_dutertrei&rdquo; became &ldquo;n_dutertrei_VT&rdquo;. We also calculated the number of species counted per subsample and reported it in the column &ldquo;number_of_species_counted_LT&rdquo;</p>\\n\\t</li>\\n</ul>\\n\\n<p>Foraminifera abundance data counts are reported in different categories in the blocks 1,2 and 3 and described in the table below:</p>\\n\\n<table>\\n\\t<tbody>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p><strong>count_type</strong></p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p><strong>unit</strong></p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Absolute</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>ind/m3</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Relative</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>%</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Raw</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>number of individuals</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Fluxes</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>ind/m2/day</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Bin_Absolute</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>ind/m3</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Bin_Relative</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>%</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Bin_Raw</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>number of individuals</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t\\t<tr>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>Bin_Fluxes</p>\\n\\t\\t\\t</td>\\n\\t\\t\\t<td>\\n\\t\\t\\t<p>ind/m2/day</p>\\n\\t\\t\\t</td>\\n\\t\\t</tr>\\n\\t</tbody>\\n</table>\\n\\n<p>&nbsp;</p>\\n\\n<p>For more details about the FORCIS database column description, please check the data descriptor paper <strong>Chaabane et al. (2023) (https://doi.org/10.1038/s41597-023-02264-2).</strong></p>\\n\\n<p>The database is kept open for any new entries and the updated version will be released in csv format. The labels of updated versions of the released &ldquo;.csv&rdquo; files will contain the date of their publication and versioning number.</p>\", \"access_right\": \"open\", \"creators\": [{\"name\": \"Chaabane, Sonia\", \"affiliation\": \"CEREGE, France and Max Planck, Germany\", \"orcid\": \"0000-0002-4653-8610\"}, {\"name\": \"de Garidel, Thibault\", \"affiliation\": \"CEREGE, France\", \"orcid\": \"0000-0001-8983-9571\"}, {\"name\": \"Giraud, Xavier\", \"affiliation\": \"CEREGE, France\", \"orcid\": \"0000-0002-6252-7647\"}, {\"name\": \"Schiebel, Ralf\", \"affiliation\": \"Max Planck, Germany\", \"orcid\": \"0000-0001-5067-8176\"}, {\"name\": \"Beaugrand, Gregory\", \"affiliation\": \"LOG, France\"}, {\"name\": \"Brummer, Geert-Jan\", \"affiliation\": \"NIOZ, Netherlands\"}, {\"name\": \"Casajus, Nicolas\", \"affiliation\": \"FRB CESAB\"}, {\"name\": \"Greco, Mattia\", \"affiliation\": \"Polish Academy of Sciences, Poland\"}, {\"name\": \"Grigoratou, Maria\", \"affiliation\": \"Mercator Ocean International, France\"}, {\"name\": \"Howa, H\\u00e9l\\u00e8ne\", \"affiliation\": \"LPG-BIAF, France\"}, {\"name\": \"Jonkers, Lukas\", \"affiliation\": \"MARUM, Germany\"}, {\"name\": \"Kucera, Michal\", \"affiliation\": \"MARUM, Germany\"}, {\"name\": \"Kuroyanagi, Azumi\", \"affiliation\": \"Tohoku Univ., Japan\"}, {\"name\": \"Meilland, Julie\", \"affiliation\": \"MARUM, Germany\"}, {\"name\": \"Monteiro, Fanny\", \"affiliation\": \"BRIDGE, UK\"}, {\"name\": \"Mortyn, Graham\", \"affiliation\": \"ICTA UAB, Spain\"}, {\"name\": \"Almogi-Labin Ahuva\", \"affiliation\": null}, {\"name\": \"Asahi Hirofumi\", \"affiliation\": null}, {\"name\": \"Avnaim-Katav Simona\", \"affiliation\": null}, {\"name\": \"Bassinot Franck\", \"affiliation\": null}, {\"name\": \"Davis Catherine V.\", \"affiliation\": null}, {\"name\": \"Field David B.\", \"affiliation\": null}, {\"name\": \"Hernandez-Almeida Ivan\", \"affiliation\": null}, {\"name\": \"Herut Barak\", \"affiliation\": null}, {\"name\": \"Hosie Graham\", \"affiliation\": null}, {\"name\": \"Howard Will\", \"affiliation\": null}, {\"name\": \"Jentzen Anna\", \"affiliation\": null}, {\"name\": \"Johns David G.\", \"affiliation\": null}, {\"name\": \"Keigwin Lloyd\", \"affiliation\": null}, {\"name\": \"Kitchener John\", \"affiliation\": null}, {\"name\": \"Kohfeld Karen E.\", \"affiliation\": null}, {\"name\": \"Lessa Douglas V.O.\", \"affiliation\": null}, {\"name\": \"Manno Clara\", \"affiliation\": null}, {\"name\": \"Marchant Margarita\", \"affiliation\": null}, {\"name\": \"Ofstad Siri\", \"affiliation\": null}, {\"name\": \"Ortiz Joseph D.\", \"affiliation\": null}, {\"name\": \"Post Alexandra\", \"affiliation\": null}, {\"name\": \"Rigual-Hernandez Andres\", \"affiliation\": null}, {\"name\": \"Rillo Marina C.\", \"affiliation\": null}, {\"name\": \"Robinson Karen\", \"affiliation\": null}, {\"name\": \"Sagawa Takuya\", \"affiliation\": null}, {\"name\": \"Sierro Francisco\", \"affiliation\": null}, {\"name\": \"Takahashi Kunio T.\", \"affiliation\": null}, {\"name\": \"Torfstein Adi\", \"affiliation\": null}, {\"name\": \"Venancio Igor\", \"affiliation\": null}, {\"name\": \"Yamasaki Makoto\", \"affiliation\": null}, {\"name\": \"Ziveri Patrizia\", \"affiliation\": null}], \"keywords\": [\"Planktonic Foraminifera\", \"FORCIS database\", \"Biodiversity\"], \"dates\": [{\"type\": \"updated\"}], \"version\": \"08\", \"resource_type\": {\"title\": \"Dataset\", \"type\": \"dataset\"}, \"license\": {\"id\": \"cc-by-4.0\"}, \"relations\": {\"version\": [{\"index\": 7, \"is_last\": false, \"parent\": {\"pid_type\": \"recid\", \"pid_value\": \"7390791\"}}]}}, \"title\": \"The FORCIS database: A global census of planktonic Foraminifera from ocean waters\", \"links\": {\"self\": \"https://zenodo.org/api/records/10640925\", \"self_html\": \"https://zenodo.org/records/10640925\", \"preview_html\": \"https://zenodo.org/records/10640925?preview=1\", \"doi\": \"https://doi.org/10.5281/zenodo.10640925\", \"self_doi\": \"https://doi.org/10.5281/zenodo.10640925\", \"self_doi_html\": \"https://zenodo.org/doi/10.5281/zenodo.10640925\", \"parent\": \"https://zenodo.org/api/records/7390791\", \"parent_html\": \"https://zenodo.org/records/7390791\", \"parent_doi\": \"https://doi.org/10.5281/zenodo.7390791\", \"parent_doi_html\": \"https://zenodo.org/doi/10.5281/zenodo.7390791\", \"self_iiif_manifest\": \"https://zenodo.org/api/iiif/record:10640925/manifest\", \"self_iiif_sequence\": \"https://zenodo.org/api/iiif/record:10640925/sequence/default\", \"files\": \"https://zenodo.org/api/records/10640925/files\", \"media_files\": \"https://zenodo.org/api/records/10640925/media-files\", \"archive\": \"https://zenodo.org/api/records/10640925/files-archive\", \"archive_media\": \"https://zenodo.org/api/records/10640925/media-files-archive\", \"latest\": \"https://zenodo.org/api/records/10640925/versions/latest\", \"latest_html\": \"https://zenodo.org/records/10640925/latest\", \"versions\": \"https://zenodo.org/api/records/10640925/versions\", \"draft\": \"https://zenodo.org/api/records/10640925/draft\", \"reserve_doi\": \"https://zenodo.org/api/records/10640925/draft/pids/doi\", \"access_links\": \"https://zenodo.org/api/records/10640925/access/links\", \"access_grants\": \"https://zenodo.org/api/records/10640925/access/grants\", \"access_users\": \"https://zenodo.org/api/records/10640925/access/users\", \"access_request\": \"https://zenodo.org/api/records/10640925/access/request\", \"access\": \"https://zenodo.org/api/records/10640925/access\", \"communities\": \"https://zenodo.org/api/records/10640925/communities\", \"communities-suggestions\": \"https://zenodo.org/api/records/10640925/communities-suggestions\", \"requests\": \"https://zenodo.org/api/records/10640925/requests\"}, \"updated\": \"2024-02-09T15:18:50.503015+00:00\", \"recid\": \"10640925\", \"revision\": 4, \"files\": [{\"id\": \"c548ee12-bdee-4fa6-ba30-29da20826be4\", \"key\": \"FORCIS_cpr_north_09022024.csv\", \"size\": 67556549, \"checksum\": \"md5:a32bbb863fe795cfcb953ca8928fd9c8\", \"links\": {\"self\": \"https://zenodo.org/api/records/10640925/files/FORCIS_cpr_north_09022024.csv/content\"}}, {\"id\": \"c36ffbbd-abb6-4a32-b6e4-7dbb1c1053d4\", \"key\": \"iho_oceans_boundaries.rds\", \"size\": 9198965, \"checksum\": \"md5:ff8d2f16650ef1f0cdcb4c3986112648\", \"links\": {\"self\": \"https://zenodo.org/api/records/10640925/files/iho_oceans_boundaries.rds/content\"}}, {\"id\": \"8a72da29-30b4-4cab-b021-43ad0ffb1f2b\", \"key\": \"FORCIS_pump_09022024.csv\", \"size\": 649676, \"checksum\": \"md5:9bee5c30a35dacb623dc7ac4ff564117\", \"links\": {\"self\": \"https://zenodo.org/api/records/10640925/files/FORCIS_pump_09022024.csv/content\"}}, {\"id\": \"ed56a716-8936-4275-9bca-55ea2dff37d4\", \"key\": \"FORCIS_taxonomy_levels.xlsx\", \"size\": 24998, \"checksum\": \"md5:e12a45e2d34def4c1642353597a04bf8\", \"links\": {\"self\": \"https://zenodo.org/api/records/10640925/files/FORCIS_taxonomy_levels.xlsx/content\"}}, {\"id\": \"0de960bd-d7ce-4c2e-9322-da32a69f4cee\", \"key\": \"FORCIS_net_09022024.csv\", \"size\": 27189945, \"checksum\": \"md5:18be71f701075318d7b0a0782d1effc7\", \"links\": {\"self\": \"https://zenodo.org/api/records/10640925/files/FORCIS_net_09022024.csv/content\"}}, {\"id\": \"c7639454-996f-42dc-b51d-ed633a594a25\", \"key\": \"FORCIS_cpr_south_09022024.csv\", \"size\": 75018303, \"checksum\": \"md5:a8f8416c8aef723209e4a6df03722fdf\", \"links\": {\"self\": \"https://zenodo.org/api/records/10640925/files/FORCIS_cpr_south_09022024.csv/content\"}}, {\"id\": \"c532f07d-b743-4444-bf6e-ad7b87bfef2b\", \"key\": \"FORCIS_data_template.xlsx\", \"size\": 357853, \"checksum\": \"md5:ef3c3d67f1824c026fe6fb36aef0b56b\", \"links\": {\"self\": \"https://zenodo.org/api/records/10640925/files/FORCIS_data_template.xlsx/content\"}}, {\"id\": \"22f24a02-40e9-4599-b97a-68e499fb186e\", \"key\": \"FORCIS_trap_09022024.csv\", \"size\": 13270806, \"checksum\": \"md5:76bac6d2c85f699da059bfd48334baf4\", \"links\": {\"self\": \"https://zenodo.org/api/records/10640925/files/FORCIS_trap_09022024.csv/content\"}}], \"swh\": {}, \"owners\": [{\"id\": \"452144\"}], \"status\": \"published\", \"stats\": {\"downloads\": 5487, \"unique_downloads\": 4158, \"views\": 3330, \"unique_views\": 2971, \"version_downloads\": 2179, \"version_unique_downloads\": 1448, \"version_unique_views\": 286, \"version_views\": 308}, \"state\": \"done\", \"submitted\": true}], \"total\": 10}, \"aggregations\": {\"access_status\": {\"buckets\": [{\"key\": \"open\", \"doc_count\": 9, \"label\": \"Open\", \"is_selected\": false}, {\"key\": \"restricted\", \"doc_count\": 1, \"label\": \"Restricted\", \"is_selected\": false}], \"label\": \"Access status\"}, \"resource_type\": {\"buckets\": [{\"key\": \"dataset\", \"doc_count\": 10, \"label\": \"Dataset\", \"is_selected\": false, \"inner\": {\"buckets\": []}}], \"label\": \"Resource types\"}, \"subject\": {\"buckets\": [{\"key\": \"Biodiversity\", \"doc_count\": 10, \"label\": \"Biodiversity\", \"is_selected\": false}, {\"key\": \"FORCIS database\", \"doc_count\": 10, \"label\": \"FORCIS database\", \"is_selected\": false}, {\"key\": \"Planktonic Foraminifera\", \"doc_count\": 10, \"label\": \"Planktonic Foraminifera\", \"is_selected\": false}], \"label\": \"Subjects\"}, \"file_type\": {\"buckets\": [{\"key\": \"csv\", \"doc_count\": 9, \"label\": \"CSV\", \"is_selected\": false}, {\"key\": \"xlsx\", \"doc_count\": 9, \"label\": \"XLSX\", \"is_selected\": false}, {\"key\": \"rds\", \"doc_count\": 5, \"label\": \"RDS\", \"is_selected\": false}], \"label\": \"File type\"}}, \"links\": {\"self\": \"https://zenodo.org/api/records?allversions=True&page=1&q=conceptrecid%3A7390791&size=25&sort=bestmatch\"}}"), 
    cache = new.env(parent = emptyenv())), class = "httr2_response")
