% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pp_foot.R
\name{pp_foot}
\alias{pp_foot}
\title{Posterior predictive checks for football models}
\usage{
pp_foot(object, data, type = "aggregated", coverage = 0.95)
}
\arguments{
\item{object}{An object either of class \code{stanFoot}, \code{CmdStanFit}, \code{stanfit}.}

\item{data}{A data frame containing match data with columns:
\itemize{
  \item \code{periods}:  Time point of each observation (integer >= 1).
  \item \code{home_team}: Home team's name (character string).
  \item \code{away_team}: Away team's name (character string).
  \item \code{home_goals}: Goals scored by the home team (integer >= 0).
  \item \code{away_goals}: Goals scored by the away team (integer >= 0).
}}

\item{type}{Type of plots, one among \code{"aggregated"} or \code{"matches"}. Default is \code{"aggregated"}.}

\item{coverage}{Argument to specify the width \eqn{1-\alpha} of posterior probability intervals. Default is 0.95.}
}
\value{
A list with elements:
\itemize{
  \item{\code{pp_plot}}: A \code{ggplot} object for the selected \code{type} of plot.
  \item{\code{pp_table}}: A data frame of summary statistics:
    \itemize{
      \item For \code{"aggregated"}: Goal differences and their Bayesian p‑values.
      \item For \code{"matches"}: Nominal \code{1-alpha} and observed empirical Bayesian coverage.
    }
}
}
\description{
The function provides posterior predictive plots to check the adequacy of the Bayesian models as
returned by the \code{stan_foot} function.
}
\details{
Posterior predictive plots: when \code{"aggregated"} (default) is selected, the function
returns a frequency plot for some pre-selected goal-difference values,
along with their correspondent Bayesian p-values, computed as
\eqn{Pr(y_rep \ge y)|y)}, where \eqn{y_rep} is a data replication from the
posterior predictive distribution (more details in Gelman et al., 2013).
Bayesian p-values very close to 0 or 1 could exhibit
possible model misfits.

When \code{"matches"} is selected an ordered-frequency plot for all the
goal-differences in the considered matches is provided, along with the
empirical Bayesian coverage at level \eqn{1-\alpha}.
}
\examples{
\dontrun{
if (instantiate::stan_cmdstan_exists()) {
  library(dplyr)

  data("italy")
  italy_2000 <- italy \%>\%
    dplyr::select(Season, home, visitor, hgoal, vgoal) \%>\%
    dplyr::filter(Season == "2000")

  colnames(italy_2000) <- c("periods", "home_team", "away_team", "home_goals", "away_goals")

  fit <- stan_foot(italy_2000, "double_pois", iter_sampling = 200)

  pp_foot(fit, italy_2000)
}
}

}
\references{
Gelman, A., Carlin, J. B., Stern, H. S., Dunson, D. B., Vehtari, A., & Rubin, D. B. (2013). Bayesian data analysis. CRC press.
}
\author{
Leonardo Egidi \email{legidi@units.it} and Roberto Macrì Demartino \email{roberto.macridemartino@deams.units.it}
}
