% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mesh_2d.R
\name{fm_hexagon_lattice}
\alias{fm_hexagon_lattice}
\title{Create hexagon lattice points}
\usage{
fm_hexagon_lattice(
  bnd,
  edge_len = NULL,
  buffer_n = 0.49,
  align = "origin",
  meta = FALSE
)
}
\arguments{
\item{bnd}{Boundary object (\code{sf} polygon or boundary \code{fm_segm} object)}

\item{edge_len}{Triangle edge length. Default \code{diff(fm_bbox(bnd)[[1]]) / 250}.}

\item{buffer_n}{Number of triangle height multiples for buffer inside the
boundary object to the start of the lattice. Default 0.49.}

\item{align}{Alignment of the hexagon lattice, either a length-2 numeric, or
character, a \code{sf}/\code{sfc}/\code{sfg} object containing a single point), or
\code{character}, default \code{"origin"}:
\describe{
\item{"origin"}{align the lattice with the coordinate system origin}
\item{"bbox"}{align the lattice with the midpoint of the bounding box of
\code{bnd}}
\item{"centroid"}{align the lattice with the centroid of the boundary,
\code{sf::st_centroid(bnd)}}
}}

\item{meta}{logical; if \code{TRUE}, return a list with diagnostic information
from the lattice construction (including the points themselves in \code{lattice})}
}
\value{
An \code{sfc} object with points, if \code{meta} is \code{FALSE} (default), or if
\code{meta=TRUE}, a list:
\describe{
\item{lattice}{\code{sfc} with lattice points}
\item{edge_len}{\code{numeric} with edge length}
\item{bnd_inner}{\code{sf} object with the inner boundary used to filter points
outside of a \code{edge_len * buffer_n} distance from the boundary}
\item{grid_n}{\code{integer} with the number of points in each direction prior to
filtering}
\item{align}{\code{numeric} with the alignment coordinates of the hexagon lattice}
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} from \verb{0.3.0.9001}. Create
hexagon lattice points within a boundary. By default, the hexagonal lattice
is anchored at the coordinate system origin, so that grids with different
but overlapping boundaries will have matching points.
}
\examples{
(m <- fm_mesh_2d(
  fm_hexagon_lattice(
    fmexample$boundary_sf[[1]],
    edge_len = 0.1 * 5
  ),
  max.edge = c(0.2, 1) * 5,
  boundary = fmexample$boundary_sf
))

(m2 <- fm_mesh_2d(
  fm_hexagon_lattice(
    fmexample$boundary_sf[[1]],
    edge_len = 0.1 * 5,
    align = "centroid"
  ),
  max.edge = c(0.2, 1) * 5,
  boundary = fmexample$boundary_sf
))

if (require("ggplot2", quietly = TRUE) &&
  require("patchwork", quietly = TRUE)) {
  ((ggplot() +
    geom_fm(data = m) +
    geom_point(aes(0, 0), col = "red")) |
    (ggplot() +
      geom_fm(data = m2) +
      geom_point(aes(0, 0), col = "red") +
      geom_sf(data = sf::st_centroid(fmexample$boundary_sf[[1]]))
    )
  )
}
}
\seealso{
\code{\link[=fm_mesh_2d]{fm_mesh_2d()}}
}
\author{
Man Ho Suen \href{mailto:M.H.Suen@sms.ed.ac.uk}{M.H.Suen@sms.ed.ac.uk},
Finn Lindgren \href{mailto:Finn.Lindgren@gmail.com}{Finn.Lindgren@gmail.com}
}
