% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fee_pois.R
\name{fee_pois}
\alias{fee_pois}
\title{First-Exposure Effect for One-Inflated Positive Poisson Model}
\usage{
fee_pois(b, g, X, Z)
}
\arguments{
\item{b}{A numeric vector of estimated coefficients for the rate.}

\item{g}{A numeric vector of estimated coefficients for inflation.}

\item{X}{A numeric matrix of covariates for the rate.}

\item{Z}{A numeric matrix of covariates for inflation.}
}
\value{
A numeric vector of first-exposure effect(s).
}
\description{
Computes the first-exposure effect (FEE) for a model estimated using the
one-inflated positive Poisson distribution. The FEE represents the change in 
expected counts associated with the first exposure to treatment, relative to 
the counterfactual positive Poisson model.This function is used internally by
\code{\link{fee}} at given covariate values.
}
\seealso{
\code{\link{fee}}, \code{\link{fee_negbin}}
}
\keyword{internal}
