% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single_insert.R
\name{ft_insert}
\alias{ft_insert}
\title{Insert New Levels into a Factor Vector After Specified Targets}
\usage{
ft_insert(
  factor_vec,
  insert,
  target = NULL,
  positions = NULL,
  pattern = NULL,
  case = FALSE,
  insert_after_na = FALSE,
  allow_duplicates = FALSE,
  inplace = FALSE
)
}
\arguments{
\item{factor_vec}{A factor vector into which new levels will be inserted.}

\item{insert}{A character vector of new levels to insert. Each new level corresponds to the respective target level or position.}

\item{target}{A character vector specifying the levels after which the new levels will be inserted. Overrides \code{positions} and \code{pattern} if provided.}

\item{positions}{An integer vector specifying the positions of levels after which the new levels will be inserted. Overrides \code{target} and \code{pattern} if both are provided.}

\item{pattern}{A regular expression pattern to identify target levels for insertion. Overrides both \code{target} and \code{positions} if provided.}

\item{case}{Logical. Should pattern matching be case-sensitive? Defaults to \code{FALSE}.}

\item{insert_after_na}{Logical. Should \code{NA} be considered as a target level for insertion? Defaults to \code{FALSE}.}

\item{allow_duplicates}{Logical. If \code{TRUE}, allows insertion of new levels that already exist in the factor by making them unique (appending suffixes). Defaults to \code{FALSE}.}

\item{inplace}{Logical. If \code{TRUE}, returns a new factor vector with elements reordered to align with the new levels' order. If \code{FALSE}, returns a new factor vector with only the levels' order adjusted, leaving the data vector's elements' order unchanged. Defaults to \code{FALSE}.}
}
\value{
A new factor vector with the new levels inserted at the specified positions. If \code{inplace = TRUE}, the data vector's elements are reordered to match the new levels' order. If \code{inplace = FALSE}, only the levels' order is adjusted without changing the data vector's elements' order.
}
\description{
Inserts one or more new levels into a factor vector immediately after specified target levels or
positions. Each new level corresponds to its respective target in a one-to-one manner.
Supports exact matches, position-based targeting, and pattern-based matching with optional case sensitivity.
Can handle multiple insertions, manage duplicates, and optionally reorder the data vector's elements to
align with the new levels.
}
\examples{
# Example 1: Insert 'date' after position 2 and 'grape' after position 4
# without allowing duplicates, returning a new factor vector
factor_vec <- factor(c('apple', 'banana', 'cherry', 'date', 'fig', 'grape'))
new_factor <- ft_insert(
  factor_vec,
  insert = c('date', 'grape'),
  positions = c(2, 4),
  inplace = FALSE
)
print(new_factor)
# [1] apple  banana date   cherry fig    grape
# Levels: apple banana date cherry fig grape

# Example 2: Insert 'date' after position 2 and 'grape' after position 4,
# allowing duplicates, returning a new factor vector
new_factor_dup <- ft_insert(
  factor_vec,
  insert = c('date', 'grape'),
  positions = c(2, 4),
  allow_duplicates = TRUE,
  inplace = FALSE
)
print(new_factor_dup)
# [1] apple  banana date   cherry fig    grape.1
# Levels: apple banana date cherry fig grape.1

# Example 3: Insert 'date' after position 2 and 'grape' after position 4,
# and reorder data elements
new_factor_inplace <- ft_insert(
  factor_vec,
  insert = c('date', 'grape'),
  positions = c(2, 4),
  inplace = TRUE
)
print(new_factor_inplace)
# [1] apple  banana date   cherry fig    grape
# Levels: apple banana date cherry fig grape

# Example 4: Insert 'kiwi' after 'banana' and 'grape', case-sensitive,
# allowing duplicates, returning a new factor vector
factor_vec_case <- factor(c('Apple', 'banana', 'Cherry', 'date', 'Fig', 'grape'))
new_factor_case <- ft_insert(
  factor_vec_case,
  insert = c('kiwi', 'kiwi'),
  target = c('banana', 'grape'),
  case = TRUE,
  allow_duplicates = TRUE,
  inplace = FALSE
)
print(new_factor_case)
# [1] Apple   banana  Cherry  date    Fig     grape   kiwi    kiwi.1

# Example 5: Insert 'lychee' after NA, returning a new factor vector
factor_vec_na <- factor(c('apple', NA, 'banana', 'cherry', NA, 'date'))
new_factor_na <- ft_insert(
  factor_vec_na,
  insert = 'lychee',
  insert_after_na = TRUE,
  inplace = FALSE
)
print(new_factor_na)
# [1] apple  <NA>    lychee banana cherry <NA>    date
# Example 6:
factor_vec <- factor(c('apple', 'banana', 'cherry', 'date', 'fig', 'grape'))
}
\author{
Kai Guo
}
