% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stretch.r
\name{stretch,GRaster-method}
\alias{stretch,GRaster-method}
\alias{stretch}
\title{Rescale values in a GRaster}
\usage{
\S4method{stretch}{GRaster}(x, minv = 0, maxv = 255, minq = 0, maxq = 1, smin = NA, smax = NA)
}
\arguments{
\item{x}{A \code{GRaster}.}

\item{minv, maxv}{Numeric: Minimum and maximum values to which to rescale values.}

\item{minq, maxq}{Numeric: Specifies range of values to rescale, given by their quantiles. The default is to stretch all values (the 0th and 100th quantiles). One or both are  ignored if \code{smin} and/or \code{smax} are provided.}

\item{smin, smax}{Numeric or \code{NA}: Specifies range of values to rescale. If \code{NA} (default), then all values are rescaled.}
}
\value{
A \code{GRaster}.
}
\description{
\code{stretch()} rescales the values in a \code{GRaster}. All values can be rescaled, or just values in a user-defined range. This range can be given by specifying either the lower and upper bounds of the range using \code{smin} and \code{smax}, and/or by the quantiles (across all cells of the raster) using \code{minq} and \code{maxq}.
}
\examples{
if (grassStarted()) {

# Setup
library(terra)

# Example data
madElev <- fastData("madElev")

# Convert a SpatRaster to a GRaster
elev <- fast(madElev)

### Stretch based on user-defined range

#  fasterRaster
fr <- stretch(elev, smin=1, smax=100)
fr

# terra
tr <- stretch(madElev, smin = 1, smax = 100)
tr

# Compare fasterRaster to terra output
fr <- rast(fr)
fr <- extend(fr, tr)
fr - tr

### Stretch values in a certain quantile range

#  fasterRaster
fr <- stretch(elev, minq = 0.25, maxq = 0.75)
fr

# terra
tr <- stretch(madElev, minq = 0.25, maxq = 0.75)
tr

# Compare fasterRaster to terra output
fr <- rast(fr)
fr <- extend(fr, tr)
fr - tr

}
}
\seealso{
\code{\link[terra:stretch]{terra::stretch()}} and tool \code{r.rescale} in \strong{GRASS} (not used on this function)
}
