% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid.r
\name{grid,GRaster-method}
\alias{grid,GRaster-method}
\alias{grid}
\alias{grid,GVector-method}
\title{Create a grid GVector}
\usage{
\S4method{grid}{GRaster}(x, nx = NULL, ny = NULL, use = "number", angle = 0)

\S4method{grid}{GVector}(x, nx = NULL, ny = NULL, use = "number", angle = 0)
}
\arguments{
\item{x}{A \code{GRaster} or \code{GVector}.}

\item{nx, ny}{Integer or numeric:
\itemize{
\item If \code{use} is \code{"number"}, then these values represent the number of rows and columns in the grid.
\item If \code{use} is \code{size}, then these values represent the size of the cells in the x- and y-dimensions.
}}

\item{use}{Character: How to generate the grid. If this is \code{number} (default), then \code{nx} and \code{ny} are taken to be the number of grid cells. If \code{size}, then \code{nx} and \code{ny} are taken to be the size of the grid cells.}

\item{angle}{Numeric: Degrees by which to rotate grid (from north, clockwise).}
}
\value{
A \code{GVector}.
}
\description{
This function creates a \code{GVector} of "wall-to-wall" cells (like a lattice). The input can be a \code{GVector} or \code{GRaster}, which provides the extent of the output.
}
\examples{
if (grassStarted()) {

# Setup
library(sf)

# Points vector of specimens of species in the plant genus Dypsis
madCoast0 <- fastData("madCoast0")

# Convert sf to a GVector:
coast <- fast(madCoast0)

### grid

# grid specified by number of cells in x-dimension
g1 <- grid(coast, nx = 10)
plot(coast, col = "cornflowerblue")
plot(g1, add = TRUE)

# grid specified by number of cells in x- and y-dimension
g2 <- grid(coast, nx = 10, ny = 5)
plot(coast, col = "cornflowerblue")
plot(g2, add = TRUE)

# grid specified by size of cells in both dimensions
g3 <- grid(coast, nx = 1250, ny = 2000, use = "size")
plot(coast, col = "cornflowerblue")
plot(g3, add = TRUE)

### hexagons

hexes <- hexagons(coast, ny = 10)
plot(hexes)
plot(coast, lwd = 2, add = TRUE)

hexes <- hexagons(coast, ny = 10, expand = c(0.3, 0.1))
plot(hexes)
plot(coast, lwd = 2, add = TRUE)

}
}
\seealso{
\code{\link[=hexagons]{hexagons()}}, tool \code{v.mkgrid} in \strong{GRASS}
}
