% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geomorphons.r
\name{geomorphons,GRaster-method}
\alias{geomorphons,GRaster-method}
\alias{geomorphons}
\title{Identify terrain feature types}
\usage{
\S4method{geomorphons}{GRaster}(
  x,
  inner = 0,
  outer = 3,
  unit = "cells",
  flat = 1,
  flatDist = 0,
  mode = "1"
)
}
\arguments{
\item{x}{A single-layer \code{GRaster}, typically representing elevation.}

\item{inner, outer}{Integer: Inner and outer radii of the torus used to identify geomorphons, in cells or meters (set by argument \code{unit}). The inner default value is 0 and the outer default value is 3. The \code{outer} radius sets the maximum size of a geomorphon that that can be identified, and \code{inner} sets the smallest size. If \code{unit} is \code{"meters"}, the value of \code{outer} must be larger than the smaller dimension of any cell in the east-west and north-south directions.}

\item{unit}{Character: Units of \code{inner} and outer; can be either \code{"cells"} (default) or \code{"meters"}. Partial matching is used.}

\item{flat}{Numeric value >= 0: Minimum difference (in degrees) between the focal area areas around it for a geomorphon to be considered as "flat". Larger cells (i.e., ~1 km resolution or larger) require smaller values (<<1) to correctly identify flat areas. Higher values result in more areas being classified as "flat" geomorphons. The default value is 1.}

\item{flatDist}{Numeric: Distance (in meters) to correct for the effect of large distances on the diminished capacity to identify "flat" geomorphons. If the distance between the focal area and a surrounding area surpasses this distance, then the effective value of \code{flat} will be reduced}

\item{mode}{Character: Method for implementing the zenith/line-of-site search. Partial matching is used:
\itemize{
\item \code{"1"} (default): The "original" geomorphon mode (in \strong{GRASS} tool \code{r.geomorphon}, the "anglev1" method)
\item \code{"2"}: Better handling of cases with equal zenith/nadir angles (the "anglev2" method)
\item \code{"2d"}: As \code{"2"}, but takes into account zenith/nadir distance ("anglev2_distance" method)
}}
}
\value{
A categorical \code{GRaster} where each geomorphon is a category (see \code{vignette("GRasters", package = "fasterRaster")}).
}
\description{
Geomorphons are idealized terrain types calculated from an elevator raster based on a moving window of a given size. The window is a torus (which can have an inner radius of 0, so can also be a circle), which allows it to identify geomorphons of a given size while ignoring ones larger or smaller. There are 10 basic geomorphons. Consult the the manual for \strong{GRASS} tool \code{r.geomorphon} using \code{grassHelp("r.geomorphon")} for more details and diagrams of each type of geomorphon. Geomorphon types include:
\enumerate{
\item Flat areas: Focal area has approximately the same elevation as surrounding areas
\item Pits: An area is lower than all other surrounding areas
\item Valley: Focal area has elevation similar to two opposing side of the window but lower than the other two opposing sides
\item Footslope: Focal region is at the "bottom" of a slope
\item Hollow: A small valley/indention in the crest of a hill
\item Slope: Cells in the window form an approximately uniform slope
\item Spur: An extrusion at the foot of a hill (i.e.,, a small hill extending out from the foot of a slope)
\item Shoulder: The crest of a slope
\item Ridge: Opposite of a valley; focal area is higher than two opposing sides but approximately the same elevation as the other two opposing sides
\item Peak: Focal area is higher than any other in the window
}
}
\examples{
if (grassStarted()) {

# Setup
library(terra)

# Example data
madElev <- fastData("madElev")

# Convert a SpatRaster to a GRaster:
elev <- fast(madElev)

# Geomorphons:
geos <- geomorphons(elev)
geos
levels(geos) # levels
freq(geos) # frequencies across cells

col <- c("gray90", "red", "orange", "blue", "green", "pink", "firebrick",
  "purple", "gray50", "black")
plot(geos, col = col)

}
}
\seealso{
\strong{GRASS} manual for tool \code{r.geomorphon} (see \code{grassHelp("r.geomorphon")})
}
