% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solution.R
\name{solution}
\alias{solution}
\alias{sol_num}
\alias{sol_int}
\alias{sol_mc}
\alias{sol_info}
\alias{sol_mc_ans}
\alias{sol_meta}
\alias{sol_mc_tf}
\alias{solution.default}
\alias{sol_ans}
\alias{sol_tf}
\title{Solutions}
\usage{
solution(x, ...)

\method{solution}{default}(x, ...)

sol_int(x, tol = NA, digits = NA)

sol_num(x, tol = NA, digits = NA)

sol_mc(x, y, sample = NULL, shuffle = order, none = NULL)

sol_ans(x, ...)

sol_tf(x, ...)

sol_info(x, ...)

sol_mc_ans(x, ...)

sol_meta(x, ...)

sol_mc_tf(x, ...)
}
\arguments{
\item{x}{numeric solution or false MC solutions}

\item{...}{further parameters}

\item{tol}{numeric: tolerance for a numeric solution (default: \code{NA})}

\item{digits}{integer: number of digits for rounding (default: \code{NA})}

\item{y}{true MC solutions}

\item{sample}{integer: sampling numbers for false and/or true solutions (default: \code{NULL})}

\item{shuffle}{logical or function: shuffling or ordering of solutions (default \code{order})}

\item{none}{character: if you do not wish to choose any of the false and/or true solutions offered (default: \code{NULL})}
}
\value{
A \code{solution} object.
}
\description{
Creates a \code{solution} object and prints a meta information block for the following:
\itemize{
\item \code{solution} the default is \code{sol_num}
\item \code{sol_num} for a numerical solution
\item \code{sol_int} for an integer solution
\item \code{sol_mc} for a multiple choice solution
\item \code{sol_ans} for the answer list of a multiple choice solution
\item \code{sol_tf} for the solution list (True or False) of a multiple choice solution
\item \code{sol_info} for creating a Meta-Information block
}
}
\details{
For numerical solutions you can set \code{tol} and/or \code{digits}.
If they are not set, they are automatically selected.
If \code{tol} is not set and \code{length(x)>1} then the tolerance is chosen as \code{min(diff(sort(x)))/2}.
Otherwise, as \code{max(0.001, 0.001*abs(x))}. I
If \code{tol} is negative, \code{tolerance} is set to \code{10^tol}, otherwise it is used as it is.
If \code{digits} is not set, \code{ceiling(-log10(tolerance))} is used.
}
\examples{
s <- sol_num(pi)
sol_info(s)
# set same tolerances, e.g. for a probability
sol_num(0.1)
sol_num(0.1, tol=0.001)
sol_num(0.1, tol=-3)
# MC: Which are prime numbers?
prime <- c(2, 3, 5, 7, 11, 13, 17, 19, 23, 29)
nonprime <- setdiff(2:30, prime)
# choose five false and two correct solutions
s <- sol_mc(nonprime, prime, sample=c(5,2), none="There are no prime numbers in the list")  
sol_ans(s)
sol_tf(s)
sol_info(s)
}
