% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.prob.R
\name{is.prob}
\alias{is.prob}
\alias{is_prob_interval}
\alias{is_prob}
\alias{in_range}
\title{Interval Checker}
\usage{
is.prob(x, open = TRUE, min = 0, max = 1)

is_prob_interval(x, open = TRUE, min = 0, max = 1)

is_prob(x, open = TRUE, min = 0, max = 1)

in_range(x, open = TRUE, min = 0, max = 1)
}
\arguments{
\item{x}{numeric: values to check}

\item{open}{logical: checks if the left and right borders are open or closed (default: \code{TRUE})}

\item{min}{numeric: minimal value (default: \code{0})}

\item{max}{numeric: maximal value (default: \code{1})}
}
\value{
A logical vector with the same length as \code{x}.
}
\description{
Checks if \code{x} is in an opened or closed interval between \code{min} and \code{max}.
The default is set as such, that the chosen interval is an interval of \eqn{(0,1)}.
For example, in the case of \code{x} being a probability.
}
\examples{
is.prob(runif(1))
}
