% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eq5d_devlin.R
\name{table_1_2_1}
\alias{table_1_2_1}
\title{Table 1.2.1: Frequency of levels by dimensions, by follow-up}
\usage{
table_1_2_1(
  df,
  names_eq5d = NULL,
  name_fu = NULL,
  levels_fu = NULL,
  eq5d_version = NULL
)
}
\arguments{
\item{df}{Data frame with the EQ-5D and follow-up columns}

\item{names_eq5d}{Character vector of column names for the EQ-5D dimensions}

\item{name_fu}{Character string for the follow-up column. If NULL, the function will check if there is a column named "follow-up" or "fu", in which case the first of those will be used.}

\item{levels_fu}{Character vector containing the order of the values in the follow-up column. 
If NULL (default value), the levels will be ordered in the order of appearance in df.}

\item{eq5d_version}{Version of the EQ-5D instrument}
}
\value{
Summary data frame.
}
\description{
Table 1.2.1: Frequency of levels by dimensions, by follow-up
}
\examples{
table_1_2_1(
  df = example_data,
  names_eq5d = c("mo", "sc", "ua", "pd", "ad"),
  name_fu = "time",
  levels_fu = c("Pre-op" , "Post-op"),
  eq5d_version = "3L"
)
}
